/*
 * Decompiled with CFR 0.152.
 */
package com.ef_prime.rflow.ui.base;

import com.ef_prime.rflow.Rflow;
import com.ef_prime.rflow.core.app.file.TextFile;
import com.ef_prime.rflow.core.base.FileResource;
import com.ef_prime.rflow.core.base.RflowVersion;
import com.ef_prime.rflow.core.util.Version;
import com.ef_prime.rflow.resource.Messages;
import com.ef_prime.rflow.ui.app.file.FileUIUtility;
import com.ef_prime.rflow.ui.app.file.FileViewer;
import com.ef_prime.rflow.ui.common.view.Page;
import com.ef_prime.rflow.ui.common.view.PagesViewFactory;
import com.ef_prime.rflow.ui.common.view.View;
import com.ef_prime.rflow.ui.common.view.ViewOpenType;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Window;
import java.io.File;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;

public class AboutDialog
extends View
implements HyperlinkListener {
    public AboutDialog() {
        JLabel jLabel = new JLabel(FileResource.getIcon("img/splash.png"), 0);
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add(jLabel);
        JEditorPane jEditorPane = new JEditorPane("text/html", AboutDialog.getAbout());
        jEditorPane.setBorder(new EmptyBorder(10, 10, 0, 10));
        jEditorPane.setEditable(false);
        jEditorPane.setOpaque(false);
        jEditorPane.putClientProperty("JEditorPane.honorDisplayProperties", Boolean.TRUE);
        jEditorPane.setFont(jLabel.getFont());
        jEditorPane.addHyperlinkListener(this);
        this.setLayout(new BorderLayout());
        this.add((Component)jPanel, "North");
        this.add((Component)jEditorPane, "Center");
    }

    public static void show(Window window) {
        PagesViewFactory.createCloseOnlyView(new Page(new AboutDialog())).showDialog(window, Messages.getString("Action.about"), false, null);
    }

    private static String getAbout() {
        Version version = RflowVersion.get();
        String string = version.getDate();
        String string2 = string.length() > 10 ? string.substring(0, 10) : string;
        String string3 = version.getYear();
        if (string3 == null) {
            string3 = "2017";
        }
        if (string2.isEmpty()) {
            string2 = "-";
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<html><body><b>R AnalyticFlow ");
        stringBuilder.append(version.getVersionString() + " " + version.getLabel());
        stringBuilder.append("</b>");
        stringBuilder.append(" (" + string2 + ")&nbsp;&nbsp;<font color=\"#3A5FCD\"><a href='releasenotes'>" + Messages.getString("Message.release_notes") + "</a></font>");
        stringBuilder.append("<br><br>");
        stringBuilder.append("Copyright (c) 2007-" + string3 + ", Ef-prime, Inc. and other licensors. All rights reserved.<br>");
        stringBuilder.append("R AnalyticFlow and the R AnalyticFlow logos are trademarks of Ef-prime, Inc.<br>");
        stringBuilder.append("See <font color=\"#3A5FCD\"><a href='license'>license</a></font> for detailed conditions about the programs and other trademarks.</body></html>");
        return stringBuilder.toString();
    }

    @Override
    public void hyperlinkUpdate(HyperlinkEvent hyperlinkEvent) {
        if (hyperlinkEvent.getEventType() != HyperlinkEvent.EventType.ACTIVATED) {
            return;
        }
        String string = hyperlinkEvent.getDescription();
        File file = null;
        if ("releasenotes".equals(string)) {
            file = FileResource.getReleaseNotes().toFile();
            if (file != null) {
                FileUIUtility.browse(Rflow.mainFrame(), file.toURI().toString());
            }
        } else if ("license".equals(string) && (file = FileResource.getLicense().toFile()) != null) {
            TextFile.get(file).putValue(TextFile.TYPE, "Plain Text");
            FileViewer fileViewer = new FileViewer();
            fileViewer.setFile(file);
            fileViewer.setActionButton(false);
            Rflow.mainView().openViewAtDefaultObjectPane(fileViewer, ViewOpenType.OPEN_NEW, true);
        }
    }
}

