/*
 * Decompiled with CFR 0.152.
 */
package com.ef_prime.rflow.ui.base;

import com.ef_prime.rflow.Rflow;
import com.ef_prime.rflow.RflowActions;
import com.ef_prime.rflow.core.base.DevelSettings;
import com.ef_prime.rflow.core.base.ProjectsManager;
import com.ef_prime.rflow.core.base.RflowEventHandler;
import com.ef_prime.rflow.core.base.Settings;
import com.ef_prime.rflow.core.common.keyvalue.ValueChangeEvent;
import com.ef_prime.rflow.core.common.keyvalue.ValueChangeEventHandler;
import com.ef_prime.rflow.node.ui.OpManager;
import com.ef_prime.rflow.node.ui.OpPopupMenu;
import com.ef_prime.rflow.node.ui.OpTreeNode;
import com.ef_prime.rflow.resource.Messages;
import com.ef_prime.rflow.ui.app.r.RUIBuilderView;
import com.ef_prime.rflow.ui.base.CustomNodeManagerView;
import com.ef_prime.rflow.ui.common.component.Actions;
import com.ef_prime.rflow.ui.common.component.LoggableAction;
import com.ef_prime.rflow.ui.common.component.ShapeIconFactory;
import com.ef_prime.rflow.ui.common.event.ChangeEvent;
import com.ef_prime.rflow.ui.common.event.ChangeEventHandler;
import com.ef_prime.rflow.ui.common.view.PagesView;
import com.ef_prime.rflow.ui.common.view.PagesViewFactory;
import com.ef_prime.rflow.ui.common.view.ViewOpenType;
import com.ef_prime.rflow.ui.util.UIUtility;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.List;
import javax.swing.Action;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JToolBar;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;

public class Bar
extends JToolBar
implements ValueChangeEventHandler,
RflowEventHandler,
ChangeEventHandler {
    private BarActions actions = new BarActions();
    private JButton popupingButton;
    private JPopupMenu popup;
    private MouseHandler mouseHandler = new MouseHandler();
    private JButton addonButton;
    private JButton saveProjectButton;
    private JButton bookmarkButton;

    public Bar() {
        this.setFloatable(false);
        this.addonButton = this.createUINodeButton(OpManager.getInstance().getAddon());
        this.add(this.addonButton);
        if (Rflow.develSettings().getValue(DevelSettings.KEY_TOOLBAR_SELECTOR).booleanValue()) {
            this.add(this.createButton(this.actions.get(BarActions.DropDown.class)));
        }
        this.addSeparator();
        RflowActions rflowActions = Rflow.getInstance().getActions();
        this.add(this.createButton(rflowActions.get("PROJECTS")));
        this.saveProjectButton = this.createButton(rflowActions.get("SAVE_PROJECT"));
        this.add(this.saveProjectButton);
        this.bookmarkButton = this.createButton(rflowActions.get("BOOKMARK"));
        this.add(this.bookmarkButton);
        this.load(OpManager.getInstance().getCurrentTreeNode());
        Rflow.settings().addEventHandler(this);
        Rflow.getInstance().addRflowEventHandler(this);
        ProjectsManager.getInstance().addChangeEventHandler(this);
        OpManager.getInstance().addChangeEventHandler(this);
    }

    private JButton createUINodeButton(OpTreeNode opTreeNode) {
        JButton jButton = this.createButton(new PopupAction(opTreeNode));
        UIUtility.insertMouseListener(jButton, this.mouseHandler);
        jButton.addMouseMotionListener(this.mouseHandler);
        return jButton;
    }

    private JButton createButton(Action action) {
        JButton jButton = new JButton(action);
        jButton.setFocusPainted(false);
        return jButton;
    }

    private void refershButtons() {
        Component[] componentArray;
        for (Component component : componentArray = this.getComponents()) {
            if (!(component instanceof JButton)) continue;
            JButton jButton = (JButton)component;
            Action action = jButton.getAction();
            boolean bl = Rflow.settings().getValue(Settings.TOOLBAR_SMALL_ICON);
            boolean bl2 = Rflow.settings().getValue(Settings.TOOLBAR_HIDE_LABEL);
            jButton.setIcon((Icon)action.getValue(bl ? "SmallIcon" : "SwingLargeIconKey"));
            jButton.setHideActionText(bl2);
            jButton.setToolTipText(bl2 ? (String)action.getValue("Name") : null);
            if (!bl2) {
                if (bl) {
                    jButton.setHorizontalTextPosition(4);
                    jButton.setVerticalTextPosition(0);
                    jButton.setHorizontalAlignment(2);
                    jButton.setAlignmentX(0.0f);
                    continue;
                }
                jButton.setHorizontalTextPosition(0);
                jButton.setVerticalTextPosition(3);
                jButton.setHorizontalAlignment(0);
                jButton.setAlignmentX(0.5f);
                continue;
            }
            jButton.setHorizontalAlignment(0);
            jButton.setAlignmentX(0.5f);
        }
        this.revalidate();
        this.repaint();
    }

    private void load(OpTreeNode opTreeNode) {
        Component[] componentArray;
        for (Component component : componentArray = this.getComponents()) {
            if (component == this.addonButton) break;
            this.remove(component);
        }
        int n = 0;
        for (OpTreeNode opTreeNode2 : opTreeNode) {
            Component component;
            if (opTreeNode2.isModel()) continue;
            component = this.createUINodeButton(opTreeNode2);
            this.add(component, n++);
        }
        this.refershButtons();
    }

    private void refreshBookmarkButton() {
        this.bookmarkButton.setVisible(!Rflow.project().isNewProject() && !ProjectsManager.getInstance().contains(Rflow.project()));
    }

    @Override
    public void valueChanged(ValueChangeEvent valueChangeEvent) {
        if (Settings.TOOLBAR_SMALL_ICON.equals(valueChangeEvent.getKey())) {
            this.refershButtons();
        } else if (Settings.TOOLBAR_HIDE_LABEL.equals(valueChangeEvent.getKey())) {
            this.refershButtons();
        }
    }

    @Override
    public void rflowWillShutdown() {
    }

    @Override
    public void rflowProjectDidStart() {
        this.saveProjectButton.setVisible(Rflow.project().isNewProject());
        this.refreshBookmarkButton();
    }

    @Override
    public void rflowProjectWillEnd() {
    }

    @Override
    public void handleChanged(ChangeEvent changeEvent) {
        if (changeEvent.getSource() == ProjectsManager.getInstance()) {
            this.refreshBookmarkButton();
        } else if (changeEvent.getSource() == OpManager.getInstance()) {
            this.load(OpManager.getInstance().getCurrentTreeNode());
        }
    }

    private class BarActions
    extends Actions {
        public BarActions() {
            this.put(new UIBuilder());
            this.put(new EditUI());
            this.put(new DropDown());
        }

        private class UIBuilder
        extends LoggableAction {
            public UIBuilder() {
                this.putValue("Name", Messages.getStringWithDots("Bar.addon.new"));
            }

            @Override
            public void action(ActionEvent actionEvent) {
                Rflow.mainView().getDefaultFlowPane().openView(new RUIBuilderView(), ViewOpenType.OPEN_NEW, true);
            }
        }

        private class EditUI
        extends LoggableAction {
            public EditUI() {
                this.putValue("Name", Messages.getStringWithDots("Action.manage"));
            }

            @Override
            public void action(ActionEvent actionEvent) {
                CustomNodeManagerView customNodeManagerView = new CustomNodeManagerView();
                PagesView pagesView = PagesViewFactory.createCloseOnlyView(customNodeManagerView);
                pagesView.showDialog(Rflow.mainFrame(), Messages.getString("Action.manage"), false, new Dimension(300, 400));
            }
        }

        private class DropDown
        extends LoggableAction {
            public DropDown() {
                Icon icon = ShapeIconFactory.create(3, 8, Color.DARK_GRAY);
                this.putValue("SmallIcon", icon);
                this.putValue("SwingLargeIconKey", icon);
            }

            @Override
            public void action(ActionEvent actionEvent) {
                Component component = (Component)actionEvent.getSource();
                JPopupMenu jPopupMenu = new JPopupMenu();
                List<OpTreeNode> list = OpManager.getInstance().getTrees();
                ButtonGroup buttonGroup = new ButtonGroup();
                for (OpTreeNode opTreeNode : list) {
                    JRadioButtonMenuItem jRadioButtonMenuItem = new JRadioButtonMenuItem(new ChangeToolbar(opTreeNode));
                    jPopupMenu.add(jRadioButtonMenuItem);
                    buttonGroup.add(jRadioButtonMenuItem);
                    jRadioButtonMenuItem.setSelected(OpManager.getInstance().getCurrentTreeNode() == opTreeNode);
                }
                jPopupMenu.show(component, 0, component.getHeight());
            }
        }

        private class ChangeToolbar
        extends LoggableAction {
            private OpTreeNode node;

            public ChangeToolbar(OpTreeNode opTreeNode) {
                this.node = opTreeNode;
                this.putValue("Name", opTreeNode.getName());
            }

            @Override
            public void action(ActionEvent actionEvent) {
                OpManager.getInstance().setCurrentTreeNode(this.node);
            }
        }
    }

    private class MouseHandler
    extends MouseAdapter {
        private MouseHandler() {
        }

        private void showPopupMenu(JButton jButton) {
            PopupAction popupAction = (PopupAction)jButton.getAction();
            popupAction.showPopupMenu(jButton);
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            JButton jButton = (JButton)mouseEvent.getSource();
            this.showPopupMenu(jButton);
        }

        @Override
        public void mouseMoved(MouseEvent mouseEvent) {
            JButton jButton = (JButton)mouseEvent.getSource();
            if (Bar.this.popupingButton != null && Bar.this.popupingButton != jButton) {
                this.showPopupMenu(jButton);
            }
        }
    }

    private class PopupAction
    extends LoggableAction
    implements PopupMenuListener {
        private OpTreeNode node;
        private JButton source;

        public PopupAction(OpTreeNode opTreeNode) {
            this.node = opTreeNode;
            this.putValue("Name", opTreeNode.getName());
            this.putValue("SmallIcon", opTreeNode.getSmallIcon());
            this.putValue("SwingLargeIconKey", opTreeNode.getIcon());
        }

        public void showPopupMenu(JButton jButton) {
            this.source = jButton;
            if (Bar.this.popupingButton == this.source) {
                if (Bar.this.popup != null) {
                    Bar.this.popupingButton = null;
                    Bar.this.popup.setVisible(false);
                }
                return;
            }
            Bar.this.popupingButton = this.source;
            Bar.this.popup = OpPopupMenu.createPopupMenu(this.node, Rflow.mainView().getSelectedItem(), false);
            Bar.this.popup.addPopupMenuListener(this);
            this.configurePopupMenu(Bar.this.popup);
            if (Bar.this.getOrientation() == 1) {
                Bar.this.popup.show(this.source, this.source.getWidth(), 0);
            } else {
                Bar.this.popup.show(this.source, 0, this.source.getHeight());
            }
        }

        protected void configurePopupMenu(JPopupMenu jPopupMenu) {
            if (this.node == OpManager.getInstance().getAddon()) {
                jPopupMenu.addSeparator();
                jPopupMenu.add(Bar.this.actions.get(BarActions.UIBuilder.class));
                jPopupMenu.add(Bar.this.actions.get(BarActions.EditUI.class));
            }
        }

        @Override
        public void action(ActionEvent actionEvent) {
        }

        @Override
        public void popupMenuWillBecomeVisible(PopupMenuEvent popupMenuEvent) {
        }

        @Override
        public void popupMenuWillBecomeInvisible(PopupMenuEvent popupMenuEvent) {
            boolean bl;
            boolean bl2 = bl = this.source.getMousePosition() != null;
            if (!bl && Bar.this.popupingButton == this.source) {
                Bar.this.popupingButton = null;
            }
        }

        @Override
        public void popupMenuCanceled(PopupMenuEvent popupMenuEvent) {
        }
    }
}

