/*
 * Decompiled with CFR 0.152.
 */
package com.ef_prime.rflow.ui.base;

import com.ef_prime.rflow.core.app.r.base.RUtility;
import com.ef_prime.rflow.core.flow.FlowNode;
import com.ef_prime.rflow.core.flow.FlowNodeSelectionEvent;
import com.ef_prime.rflow.core.flow.FlowNodeSelectionEventHandler;
import com.ef_prime.rflow.node.NodeModel;
import com.ef_prime.rflow.node.NodeModelChangeListener;
import com.ef_prime.rflow.ui.app.r.script.AbstractRCodingTextArea;
import com.ef_prime.rflow.ui.app.r.script.RCodingTextArea;
import com.ef_prime.rflow.ui.common.component.SideBorder;
import com.ef_prime.rflow.ui.flow.FlowViewer;
import edu.uci.ics.jung.visualization.PickedState;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.AbstractAction;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.text.BadLocationException;

public class CodeBar
extends JPanel
implements FlowNodeSelectionEventHandler,
NodeModelChangeListener {
    private AbstractRCodingTextArea codeField = new RCodingTextArea();
    private FlowNode node;
    private FlowViewer viewer;
    private JLabel iconLabel = new JLabel();
    private static final Color background = UIManager.getColor("Panel.background");

    public CodeBar(FlowViewer flowViewer) {
        this.viewer = flowViewer;
        this.setLayout(new BoxLayout(this, 0));
        final SideBorder sideBorder = new SideBorder(4, Color.ORANGE);
        final SideBorder sideBorder2 = new SideBorder(4, Color.LIGHT_GRAY);
        this.setBorder(sideBorder2);
        int n = 25;
        this.setPreferredSize(new Dimension(Integer.MAX_VALUE, n));
        this.setMaximumSize(new Dimension(Integer.MAX_VALUE, n));
        this.setMinimumSize(new Dimension(0, n));
        this.iconLabel.setPreferredSize(new Dimension(25, 25));
        this.iconLabel.setHorizontalAlignment(0);
        this.add(this.iconLabel);
        this.codeField.setBorder(new EmptyBorder(4, 3, 3, 3));
        this.codeField.setHighlightCurrentLine(false);
        this.codeField.setMarkOccurrences(false);
        this.codeField.setLineWrap(false);
        this.codeField.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent focusEvent) {
                if (CodeBar.this.codeField.isEditable()) {
                    CodeBar.this.setBorder(sideBorder);
                }
            }

            @Override
            public void focusLost(FocusEvent focusEvent) {
                CodeBar.this.setBorder(sideBorder2);
                CodeBar.this.sendCode2Model();
            }
        });
        this.codeField.getActionMap().put("CodeBar.Enter", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CodeBar.this.requestFocusInWindow();
            }
        });
        this.codeField.getInputMap().put(KeyStroke.getKeyStroke(10, 0), "CodeBar.Enter");
        JScrollPane jScrollPane = new JScrollPane((Component)((Object)this.codeField));
        jScrollPane.setHorizontalScrollBarPolicy(31);
        jScrollPane.setVerticalScrollBarPolicy(21);
        jScrollPane.setBorder(null);
        this.add(jScrollPane);
    }

    public void load() {
        this.viewer.getPickedState().addSelectionEventHandler(this);
        FlowNode.addNodeModelChangeListener(this);
        this.update((PickedState)this.viewer.getPickedState());
        this.codeField.startAutoCompletionNotifier();
    }

    public void unload() {
        this.codeField.endAutoCompletionNotifier();
        this.clear();
        this.viewer.getPickedState().removeSelectionEventHandler(this);
        FlowNode.removeNodeModelChangeListener(this);
    }

    public void clear() {
        this.node = null;
        try {
            this.codeField.getDocument().remove(0, this.codeField.getDocument().getLength());
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
        this.codeField.setEditable(false);
        this.setBackground(background);
        this.codeField.setBackground(background);
        this.iconLabel.setIcon(null);
        this.repaint();
    }

    public void setText(String string) {
        if (string == null || string.length() < 1) {
            this.codeField.setText("");
        } else {
            this.codeField.setText(string);
        }
        this.codeField.setCaretPosition(0);
        this.codeField.discardAllEdits();
    }

    public void startEditing() {
        this.codeField.requestFocusInWindow();
    }

    private void sendCode2Model() {
        String string;
        NodeModel nodeModel;
        NodeModel nodeModel2 = nodeModel = this.node == null ? null : this.node.getModel();
        if (nodeModel != null && nodeModel.isEditable() && !(string = RUtility.trimNewLine(nodeModel.getCommand())).equals(this.codeField.getText())) {
            nodeModel.setCommand(RUtility.appendNewLine(this.codeField.getText()));
            FlowNode.fireNodeModelChanged(this.node);
        }
    }

    private void setModel(FlowNode flowNode) {
        NodeModel nodeModel;
        if (this.node != null && this.node != flowNode) {
            this.sendCode2Model();
        }
        this.node = flowNode;
        NodeModel nodeModel2 = nodeModel = flowNode == null ? null : flowNode.getModel();
        if (nodeModel != null) {
            this.codeField.setEditable(nodeModel.isEditable());
            if (!nodeModel.isEditable()) {
                this.setBackground(background);
                this.codeField.setBackground(background);
            } else {
                this.setBackground(Color.WHITE);
                this.codeField.setBackground(Color.WHITE);
            }
            String string = nodeModel.getCommand();
            string = RUtility.trimNewLine(string);
            this.setText(nodeModel.isEditable() ? string : this.omitCommand(string));
            Icon icon = flowNode.getSmallIcon();
            this.iconLabel.setIcon(icon);
            this.revalidate();
            this.repaint();
        } else {
            this.clear();
        }
    }

    private String omitCommand(String string) {
        Object object = string.replaceAll("\n", "  ");
        if (((String)(object = ((String)object).replaceAll("\t", ""))).length() > 50) {
            object = ((String)object).substring(0, 50) + "...";
        }
        return object;
    }

    public void update(PickedState pickedState) {
        if (pickedState.getPickedVertices().size() == 1) {
            FlowNode flowNode = (FlowNode)pickedState.getPickedVertices().iterator().next();
            if (this.viewer == null || this.viewer.getGraph() == flowNode.getGraph()) {
                this.setModel(flowNode);
                return;
            }
        }
        this.setModel(null);
    }

    @Override
    public void flowSelectionChanged(FlowNodeSelectionEvent flowNodeSelectionEvent) {
        this.update((PickedState)flowNodeSelectionEvent.getState());
    }

    @Override
    public void nodeModelChanged(FlowNode flowNode) {
        if (flowNode == this.node) {
            this.setModel(flowNode);
        }
    }

    @Override
    public void subflowNodeModelChanged(FlowNode flowNode) {
    }
}

