/*
 * Decompiled with CFR 0.152.
 */
package com.ef_prime.rflow.ui.base;

import com.ef_prime.rflow.Rflow;
import com.ef_prime.rflow.core.app.r.RAddonBuilderModel;
import com.ef_prime.rflow.core.app.r.RAddonOp;
import com.ef_prime.rflow.core.base.UserFolder;
import com.ef_prime.rflow.node.ui.OpManager;
import com.ef_prime.rflow.node.ui.OpTreeNode;
import com.ef_prime.rflow.resource.Messages;
import com.ef_prime.rflow.ui.app.file.FileUIUtility;
import com.ef_prime.rflow.ui.app.r.RUIBuilderView;
import com.ef_prime.rflow.ui.base.Icons;
import com.ef_prime.rflow.ui.common.component.Actions;
import com.ef_prime.rflow.ui.common.component.LoggableAction;
import com.ef_prime.rflow.ui.common.event.ChangeEvent;
import com.ef_prime.rflow.ui.common.event.ChangeEventHandler;
import com.ef_prime.rflow.ui.common.view.Page;
import com.ef_prime.rflow.ui.common.view.ViewOpenType;
import com.ef_prime.rflow.ui.util.UIUtility;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.io.IOException;
import javax.swing.Action;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.ListCellRenderer;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import net.miginfocom.layout.LC;
import net.miginfocom.swing.MigLayout;
import org.pushingpixels.substance.api.renderers.SubstanceDefaultListCellRenderer;

public class CustomNodeManagerView
extends Page
implements ListSelectionListener,
MouseListener {
    private JList<OpTreeNode> entriesList;
    private ListActions actions;

    public CustomNodeManagerView() {
        DefaultListModel defaultListModel = new DefaultListModel();
        this.entriesList = new JList(defaultListModel);
        this.entriesList.setCellRenderer((ListCellRenderer<OpTreeNode>)((Object)new ListRenderer()));
        this.entriesList.setSelectionMode(0);
        this.entriesList.addListSelectionListener(this);
        this.entriesList.addMouseListener(this);
        this.refreshList();
        this.actions = new ListActions();
        JToolBar jToolBar = new JToolBar(1);
        jToolBar.setFloatable(false);
        jToolBar.add(this.createButton(this.actions.get(ListActions.Edit.class)));
        jToolBar.add(this.createButton(this.actions.get(ListActions.Add.class)));
        jToolBar.add(this.createButton(this.actions.get(ListActions.Remove.class)));
        JPanel jPanel = new JPanel((LayoutManager)new MigLayout(new LC().insets("10", "0", "0", "0").fill()));
        jPanel.add(new JButton(this.actions.get(ListActions.OpenPath.class)));
        this.setLayout(new BorderLayout());
        this.add((Component)new JScrollPane(this.entriesList), "Center");
        this.add((Component)jToolBar, "West");
        this.add((Component)jPanel, "South");
        this.actions.updateState();
    }

    private void refreshList() {
        DefaultListModel<OpTreeNode> defaultListModel = this.getListModel();
        defaultListModel.removeAllElements();
        OpTreeNode opTreeNode = OpManager.getInstance().getAddon();
        for (OpTreeNode opTreeNode2 : opTreeNode) {
            defaultListModel.addElement(opTreeNode2);
        }
    }

    private DefaultListModel<OpTreeNode> getListModel() {
        return (DefaultListModel)this.entriesList.getModel();
    }

    public OpTreeNode getSelectedNode() {
        return this.entriesList.getSelectedValue();
    }

    private JButton createButton(Action action) {
        JButton jButton = new JButton(action);
        jButton.setHideActionText(true);
        jButton.setFocusable(false);
        jButton.setToolTipText((String)action.getValue("Name"));
        return jButton;
    }

    @Override
    public boolean canGoNext() {
        return this.getSelectedNode() != null;
    }

    @Override
    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        this.dispatchPageEvent(0);
        this.actions.updateState();
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        if (UIUtility.isLeftMouseButton(mouseEvent) && mouseEvent.getClickCount() == 2) {
            this.actions.doAction(ListActions.Edit.class);
        }
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    private static class ListRenderer
    extends SubstanceDefaultListCellRenderer {
        private ListRenderer() {
        }

        public Component getListCellRendererComponent(JList<?> jList, Object object, int n, boolean bl, boolean bl2) {
            super.getListCellRendererComponent(jList, object, n, bl, bl2);
            OpTreeNode opTreeNode = (OpTreeNode)object;
            this.setText(opTreeNode.getName());
            this.setIcon(opTreeNode.getSmallIcon());
            return this;
        }
    }

    private class ListActions
    extends Actions {
        public ListActions() {
            this.put(new Edit());
            this.put(new Add());
            this.put(new Remove());
            this.put(new OpenPath());
        }

        private void updateState() {
            boolean bl = !CustomNodeManagerView.this.entriesList.isSelectionEmpty();
            this.get(Edit.class).setEnabled(bl);
            this.get(Remove.class).setEnabled(bl);
        }

        private RAddonOp getModel(int n) {
            if (n < 0 || n >= CustomNodeManagerView.this.entriesList.getModel().getSize()) {
                return null;
            }
            OpTreeNode opTreeNode = CustomNodeManagerView.this.entriesList.getModel().getElementAt(n);
            if (opTreeNode == null) {
                return null;
            }
            return (RAddonOp)opTreeNode.getModel();
        }

        private File getFile(RAddonOp rAddonOp) {
            if (rAddonOp == null) {
                return null;
            }
            String string = rAddonOp.getData().getPath();
            File file = UserFolder.getCustomUIDir();
            return new File(file, string);
        }

        private class Edit
        extends LoggableAction
        implements ChangeEventHandler {
            public Edit() {
                this.putValue("Name", Messages.getString("Action.edit"));
                this.putValue("SmallIcon", Icons.getIcon("16/pencil.png"));
            }

            @Override
            public void action(ActionEvent actionEvent) {
                RAddonOp rAddonOp = ListActions.this.getModel(CustomNodeManagerView.this.entriesList.getSelectedIndex());
                if (rAddonOp == null) {
                    return;
                }
                File file = ListActions.this.getFile(rAddonOp);
                RAddonBuilderModel rAddonBuilderModel = new RAddonBuilderModel(file);
                try {
                    rAddonBuilderModel.load();
                    RUIBuilderView rUIBuilderView = new RUIBuilderView(rAddonBuilderModel);
                    rUIBuilderView.addChangeEventHandler(this);
                    Rflow.mainView().getDefaultFlowPane().openView(rUIBuilderView, ViewOpenType.OPEN_NEW, true);
                    CustomNodeManagerView.this.next();
                }
                catch (IOException iOException) {
                    UIUtility.showErrorDialog((Component)Rflow.mainFrame(), "Error occurred while reading a file.", iOException);
                }
            }

            @Override
            public void handleChanged(ChangeEvent changeEvent) {
                CustomNodeManagerView.this.entriesList.repaint();
            }
        }

        private class Add
        extends LoggableAction
        implements ChangeEventHandler {
            public Add() {
                this.putValue("Name", Messages.getString("Action.new"));
                this.putValue("SmallIcon", Icons.getIcon("16/add.png"));
            }

            @Override
            public void action(ActionEvent actionEvent) {
                RUIBuilderView rUIBuilderView = new RUIBuilderView();
                rUIBuilderView.addChangeEventHandler(this);
                Rflow.mainView().getDefaultFlowPane().openView(new RUIBuilderView(), ViewOpenType.OPEN_NEW, true);
            }

            @Override
            public void handleChanged(ChangeEvent changeEvent) {
                CustomNodeManagerView.this.refreshList();
            }
        }

        private class Remove
        extends LoggableAction {
            public Remove() {
                this.putValue("Name", Messages.getString("Action.remove"));
                this.putValue("SmallIcon", Icons.getIcon("16/delete.png"));
            }

            @Override
            public void action(ActionEvent actionEvent) {
                int[] nArray = CustomNodeManagerView.this.entriesList.getSelectedIndices();
                if (nArray == null || nArray.length == 0) {
                    return;
                }
                RAddonOp rAddonOp = ListActions.this.getModel(nArray[0]);
                if (!UIUtility.confirmDelete(CustomNodeManagerView.this.entriesList, nArray.length, rAddonOp.getTitle())) {
                    return;
                }
                for (int i = nArray.length - 1; i >= 0; --i) {
                    int n = nArray[i];
                    RAddonOp rAddonOp2 = ListActions.this.getModel(n);
                    if (rAddonOp2 == null) continue;
                    OpTreeNode opTreeNode = CustomNodeManagerView.this.entriesList.getModel().getElementAt(n);
                    File file = ListActions.this.getFile(rAddonOp2);
                    if (file.exists() && !file.delete()) {
                        UIUtility.showErrorDialog(CustomNodeManagerView.this.entriesList, Messages.getString("Error.file.delete") + ": " + String.valueOf(file));
                    }
                    CustomNodeManagerView.this.getListModel().remove(n);
                    OpManager.getInstance().removeAddon(opTreeNode);
                }
            }
        }

        private class OpenPath
        extends LoggableAction {
            public OpenPath() {
                this.putValue("Name", Messages.getString("Bar.addon.open_path"));
                this.putValue("SmallIcon", Icons.getIcon("16/folder.png"));
            }

            @Override
            public void action(ActionEvent actionEvent) {
                File file = UserFolder.getCustomUIDir();
                if (!file.exists()) {
                    file.mkdirs();
                }
                FileUIUtility.openPath(file);
            }
        }
    }
}

