/*
 * Decompiled with CFR 0.152.
 */
package com.ef_prime.rflow.ui.base;

import com.ef_prime.rflow.Rflow;
import com.ef_prime.rflow.core.base.FileEdit;
import com.ef_prime.rflow.core.base.WorkingDirectory;
import com.ef_prime.rflow.resource.Messages;
import com.ef_prime.rflow.ui.common.component.RflowOptionPane;
import com.ef_prime.rflow.ui.util.UIUtility;
import java.awt.Component;
import java.io.IOException;
import javax.swing.JDialog;
import javax.swing.JOptionPane;

public class FileEditUIUtilty {
    public static boolean confirmAndSave(FileEdit fileEdit) {
        if (fileEdit == null || !fileEdit.isDirty() || fileEdit.getFile() == null) {
            return true;
        }
        String string = Messages.format("Message.confirm_save_file", fileEdit.getFileEditName());
        int n = RflowOptionPane.showConfirmDialog((Component)Rflow.mainFrame(), string, Messages.getString("Message.confirm"), 3);
        switch (n) {
            case 0: {
                if (!FileEditUIUtilty.checkExternalEdit(fileEdit)) {
                    return false;
                }
                try {
                    FileEditUIUtilty.save(fileEdit);
                    break;
                }
                catch (IOException iOException) {
                    UIUtility.showErrorDialog((Component)Rflow.mainFrame(), Messages.getString("Error.save") + ": " + String.valueOf(fileEdit.getFile()), iOException);
                    return false;
                }
            }
            case 1: {
                fileEdit.clearEdit();
                fileEdit.dispatchFileEditEvent(4);
                break;
            }
            default: {
                return false;
            }
        }
        return true;
    }

    private static boolean checkExternalEdit(FileEdit fileEdit) {
        if (!fileEdit.hasLastModifiedChanged()) {
            return true;
        }
        String string = Messages.format("Message.confirm_changed", fileEdit.getFile().getName());
        JOptionPane jOptionPane = new JOptionPane(string, 2);
        String string2 = Messages.getString("ConfirmOverwrite.overwrite");
        String string3 = Messages.getString("Button.cancel");
        jOptionPane.setOptions(new String[]{string2, string3});
        JDialog jDialog = jOptionPane.createDialog(Rflow.mainFrame(), Messages.getString("Error.title.warning"));
        jDialog.setVisible(true);
        jDialog.dispose();
        String string4 = (String)jOptionPane.getValue();
        if (string4 == null) {
            return false;
        }
        return string4.equals(string2);
    }

    private static void save(FileEdit fileEdit) throws IOException {
        fileEdit.safeSave(WorkingDirectory.toAbsolutePath(fileEdit.getFile()).toPath(), Rflow.project().getTempDir().toPath());
        fileEdit.dispatchFileEditEvent(3);
    }
}

