/*
 * Decompiled with CFR 0.152.
 */
package com.ef_prime.rflow.ui.base;

import com.ef_prime.rflow.core.base.FileResource;
import com.ef_prime.rflow.core.base.Project;
import com.ef_prime.rflow.core.common.xml.XmlContext;
import com.ef_prime.rflow.core.flow.FlowModel;
import com.ef_prime.rflow.core.util.YamlEx;
import com.ef_prime.rflow.ui.base.Icons;
import com.ef_prime.rflow.ui.base.ProjectNode;
import java.io.File;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Vector;
import javax.swing.Icon;
import org.apache.commons.io.FilenameUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class FileProjectNode
extends ProjectNode {
    private static final Icon PROJECT_ICON = Icons.getIcon("16/package.png");
    private static final Icon RFLOW_ICON = FileResource.getIcon("img/doc_16.png");
    protected File file;
    protected boolean isDirectory;
    private boolean fileExists;
    private boolean isProject;
    protected Vector<ProjectNode> childrenTemp;

    public FileProjectNode(File file) {
        this.init(file);
        this.setDefaultName();
    }

    FileProjectNode() {
    }

    protected void init(File file) {
        this.file = file;
        this.isDirectory = file.isDirectory();
        this.fileExists = file.exists();
        this.isProject = this.isDirectory ? Project.isProject(file) : false;
        this.setAllowsChildren(false);
    }

    private void setDefaultName() {
        String string = "";
        if (this.isProject) {
            try {
                string = Project.getName(this.file);
            }
            catch (IOException iOException) {
                string = this.file.getName();
            }
        } else {
            string = this.isFlowFile() ? FilenameUtils.removeExtension((String)this.file.getName()) : this.file.getName();
        }
        this.setName(string);
    }

    @Override
    public String getType() {
        return "entry";
    }

    @Override
    public boolean isFile() {
        return true;
    }

    @Override
    public File getFile() {
        return this.file;
    }

    @Override
    public boolean fileExists() {
        return this.fileExists;
    }

    @Override
    public boolean isProject() {
        return this.isProject;
    }

    @Override
    public Icon getIcon() {
        if (this.isProject) {
            return PROJECT_ICON;
        }
        if (this.isFlowFile()) {
            return RFLOW_ICON;
        }
        return null;
    }

    @Override
    public void refreshChildrenWork() {
        this.init(this.file);
    }

    @Override
    public void refreshChildrenDone() {
        this.removeAllChildren();
        if (this.childrenTemp == null) {
            return;
        }
        for (ProjectNode projectNode : this.childrenTemp) {
            this.add(projectNode);
        }
        this.childrenTemp = null;
    }

    @Override
    public ProjectNode copy() {
        FileProjectNode fileProjectNode = new FileProjectNode();
        fileProjectNode.init(this.file);
        fileProjectNode.setName(this.getName());
        return fileProjectNode;
    }

    @Override
    public boolean isFlowFile() {
        return FlowModel.isRflow(this.file.getName());
    }

    @Override
    public void storeToElement(XmlContext xmlContext, Document document, Element element) {
        element.setAttribute("name", this.getName());
        String string = FilenameUtils.separatorsToUnix((String)this.file.getAbsolutePath());
        element.setAttribute("path", string);
    }

    @Override
    public void loadElement(Element element, XmlContext xmlContext) {
        String string = element.getAttribute("path");
        this.init(new File(string));
        this.setName(element.getAttribute("name"));
        if (this.getName().isEmpty()) {
            this.setDefaultName();
        }
    }

    @Override
    public Object toYamlValue(YamlEx yamlEx) {
        LinkedHashMap<String, Object> linkedHashMap = new LinkedHashMap<String, Object>();
        linkedHashMap.put("type", this.getType());
        linkedHashMap.put("name", this.getName());
        linkedHashMap.put("path", FilenameUtils.separatorsToUnix((String)this.file.getAbsolutePath()));
        linkedHashMap.put("project", this.isProject);
        linkedHashMap.put("dir", this.isDirectory);
        return linkedHashMap;
    }

    @Override
    public void loadYamlValue(YamlEx yamlEx, Object object) {
        Map map = (Map)YamlEx.typeCheck(Map.class, object);
        String string = YamlEx.string(map.get("path"));
        this.init(new File(string));
        this.setName(YamlEx.string(map.get("name")));
        if (this.getName().isEmpty()) {
            this.setDefaultName();
        }
    }
}

