/*
 * Decompiled with CFR 0.152.
 */
package com.ef_prime.rflow.ui.base;

import com.ef_prime.rflow.core.app.file.FileInfo;
import com.ef_prime.rflow.core.app.file.FileInfos;
import com.ef_prime.rflow.core.base.Project;
import com.ef_prime.rflow.ui.base.FileProjectNode;
import java.io.File;
import java.io.IOException;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.lang3.ArrayUtils;

public class FileProjectNodeEx
extends FileProjectNode {
    private static final Logger LOGGER = Logger.getLogger(FileProjectNodeEx.class.getName());

    public FileProjectNodeEx(File file) {
        super(file);
    }

    @Override
    protected void init(File file) {
        super.init(file);
        this.setAllowsChildren(this.isDirectory);
    }

    @Override
    public void refreshChildrenWork() {
        super.refreshChildrenWork();
        this.childrenTemp = new Vector();
        if (this.isProject()) {
            Project project = Project.createProject(this.file);
            try {
                project.loadProjectFile();
            }
            catch (IOException iOException) {
                LOGGER.log(Level.WARNING, "Failed to project file: " + String.valueOf(project.getProjectFile()), iOException);
            }
            Object[] objectArray = project.getFlowDir().listFiles();
            if (ArrayUtils.isEmpty((Object[])objectArray)) {
                return;
            }
            for (Object object : objectArray) {
                FileInfo fileInfo = FileInfos.getInstance().getFileInfo((File)object);
                if (!fileInfo.isRflow()) continue;
                this.childrenTemp.add(new FileProjectNodeEx((File)object));
            }
            return;
        }
        if (!this.isDirectory) {
            return;
        }
        for (File file : this.file.listFiles()) {
            if (!file.isDirectory()) {
                return;
            }
            this.childrenTemp.add(new FileProjectNodeEx(file));
        }
    }
}

