/*
 * Decompiled with CFR 0.152.
 */
package com.ef_prime.rflow.ui.base;

import com.ef_prime.rflow.ui.common.component.OverlaidIcon;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import javax.imageio.ImageIO;
import javax.swing.GrayFilter;
import javax.swing.Icon;
import javax.swing.ImageIcon;

public class Icons {
    private static final Map<String, BufferedImage> map = new HashMap<String, BufferedImage>();
    private static final Map<String, Image> imageMap = new HashMap<String, Image>();

    public static ImageIcon getIcon(String string) {
        BufferedImage bufferedImage = Icons.getImage(string);
        return bufferedImage == null ? null : new ImageIcon(bufferedImage);
    }

    public static ImageIcon getDisabledIcon(String string) {
        Image image = Icons.getDisabledImage(string);
        return image == null ? null : new ImageIcon(image);
    }

    public static ImageIcon getIcon(String string, String string2, int n, int n2) {
        ImageIcon imageIcon = Icons.getIcon(string);
        if (imageIcon == null) {
            return null;
        }
        ImageIcon imageIcon2 = Icons.getIcon(string2);
        if (imageIcon2 == null) {
            return null;
        }
        return new OverlaidIcon(imageIcon, imageIcon2, n, n2);
    }

    public static ImageIcon getOverlaidIcon(String string, String string2) {
        ImageIcon imageIcon = Icons.getIcon(string);
        if (imageIcon == null) {
            return null;
        }
        int n = imageIcon.getIconHeight() / 2;
        ImageIcon imageIcon2 = Icons.getIcon(string2, n);
        if (imageIcon2 == null) {
            return null;
        }
        return new OverlaidIcon(imageIcon, imageIcon2, n, n);
    }

    public static ImageIcon getOverlaidIcon(Icon icon, String string) {
        if (icon == null) {
            return null;
        }
        int n = icon.getIconHeight() / 2;
        return Icons.getOverlaidIcon(icon, string, n);
    }

    public static ImageIcon getOverlaidIcon(Icon icon, String string, int n) {
        return Icons.getOverlaidIcon(icon, string, n, icon.getIconWidth() - n, icon.getIconHeight() - n);
    }

    public static ImageIcon getOverlaidIcon(Icon icon, String string, int n, int n2, int n3) {
        if (icon == null) {
            return null;
        }
        ImageIcon imageIcon = Icons.getIcon(string, n);
        if (imageIcon == null) {
            return null;
        }
        return new OverlaidIcon(icon, imageIcon, n2, n3);
    }

    public static ImageIcon getIcon(String string, int n) {
        BufferedImage bufferedImage = Icons.getImage(string, n);
        return bufferedImage == null ? null : new ImageIcon(bufferedImage);
    }

    public static BufferedImage getImage(String string) {
        if (string == null) {
            return null;
        }
        BufferedImage bufferedImage = map.get(string);
        if (bufferedImage == null) {
            URL uRL = Icons.class.getResource("/com/ef_prime/rflow/resource/icon/" + string);
            if (uRL == null) {
                return null;
            }
            try {
                bufferedImage = ImageIO.read(uRL);
            }
            catch (IOException iOException) {
                return null;
            }
            map.put(string, bufferedImage);
        }
        return bufferedImage;
    }

    public static BufferedImage getImage(String string, int n) {
        String string2 = string + ":size:" + n;
        BufferedImage bufferedImage = map.get(string2);
        if (bufferedImage == null) {
            BufferedImage bufferedImage2 = Icons.getImage(string);
            if (bufferedImage2 == null) {
                return null;
            }
            bufferedImage = new BufferedImage(n, n, 2);
            Graphics2D graphics2D = bufferedImage.createGraphics();
            graphics2D.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
            graphics2D.drawImage(bufferedImage2, 0, 0, n, n, null);
            graphics2D.dispose();
            map.put(string2, bufferedImage);
        }
        return bufferedImage;
    }

    public static Image getDisabledImage(String string) {
        String string2 = string + ":disabled:";
        Image image = imageMap.get(string2);
        if (image == null) {
            BufferedImage bufferedImage = Icons.getImage(string);
            if (bufferedImage == null) {
                return null;
            }
            image = GrayFilter.createDisabledImage(bufferedImage);
            imageMap.put(string2, image);
        }
        return image;
    }
}

