/*
 * Decompiled with CFR 0.152.
 */
package com.ef_prime.rflow.ui.base;

import com.ef_prime.rflow.Rflow;
import com.ef_prime.rflow.core.base.LogFormatter;
import com.ef_prime.rflow.core.base.LogManager;
import com.ef_prime.rflow.core.base.Settings;
import com.ef_prime.rflow.core.base.UserFolder;
import com.ef_prime.rflow.core.base.WorkingDirectory;
import com.ef_prime.rflow.core.common.util.Utility;
import com.ef_prime.rflow.resource.Messages;
import com.ef_prime.rflow.ui.base.Icons;
import com.ef_prime.rflow.ui.common.component.FlatSplitPane;
import com.ef_prime.rflow.ui.common.component.LoggableAction;
import com.ef_prime.rflow.ui.common.view.LazyLoadView;
import com.ef_prime.rflow.ui.util.FontSupport;
import com.ef_prime.rflow.ui.util.UIUtility;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import java.util.zip.GZIPInputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.swing.ActionMap;
import javax.swing.DefaultListModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import net.miginfocom.layout.LC;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.pushingpixels.substance.api.renderers.SubstanceDefaultListCellRenderer;

public class LogView
extends LazyLoadView {
    private static final Logger LOGGER = Logger.getLogger(LogView.class.getName());
    private static final String[] LEVELS = new String[]{Level.ALL.getName(), Level.FINEST.getName(), Level.FINER.getName(), Level.FINE.getName(), Level.CONFIG.getName(), Level.INFO.getName(), Level.WARNING.getName(), Level.SEVERE.getName()};
    private static final SimpleAttributeSet CONFIG_ATTR = new SimpleAttributeSet();
    private JTextPane textPane;
    private LogHandler logHandler;
    private DefaultListModel<LogSession> sessionListModel;
    private JList<LogSession> sessionList;
    private Set<String> levelFilter = new HashSet<String>(9);

    public LogView() {
        this.setTitle(Messages.getString("View.AppLog.title"));
    }

    @Override
    protected boolean canBeUnreadWhenShowing() {
        return true;
    }

    @Override
    protected void loadContent() {
        String string = Rflow.settings().getValue(Settings.LOG_CONSOLE_LEVEL);
        if (string.isEmpty()) {
            string = Level.INFO.getName();
        }
        this.textPane = new JTextPane();
        this.textPane.setEditable(false);
        this.textPane.addMouseListener(new LogOutputMouseHandler());
        FontSupport.setCodeFont(this.textPane);
        JScrollPane jScrollPane = new JScrollPane(this.textPane);
        this.sessionListModel = new DefaultListModel();
        this.sessionList = new JList<LogSession>(this.sessionListModel);
        this.sessionList.setCellRenderer((ListCellRenderer<LogSession>)((Object)new LogSessionListRenderer()));
        this.sessionList.getSelectionModel().addListSelectionListener(new LogSessionSelectionHandler());
        JScrollPane jScrollPane2 = new JScrollPane(this.sessionList);
        JComboBox<String> jComboBox = new JComboBox<String>(LEVELS);
        jComboBox.setSelectedItem(string);
        jComboBox.addActionListener(new LevelSelectorHandler());
        JPanel jPanel = new JPanel((LayoutManager)new MigLayout(new LC().insets("2")));
        jPanel.add(new JLabel(Messages.getString("View.AppLog.level")));
        jPanel.add(jComboBox);
        JToolBar jToolBar = new JToolBar();
        jToolBar.setLayout((LayoutManager)new MigLayout(new LC().insets("0").alignX("right")));
        jToolBar.setFloatable(false);
        jToolBar.add(jPanel);
        jToolBar.add(new SaveAs());
        this.setLayout(new BorderLayout());
        FlatSplitPane flatSplitPane = new FlatSplitPane(jScrollPane2, (Component)jScrollPane, 180);
        this.add(flatSplitPane);
        this.add((Component)jToolBar, "North");
        this.setLevelFilter(string);
        this.refreshSessions();
    }

    @Override
    protected void viewDidBecomeDisplayable() {
        super.viewDidBecomeDisplayable();
        this.install();
    }

    @Override
    protected void viewDidBecomeUndisplayable() {
        super.viewDidBecomeUndisplayable();
        this.uninstall();
    }

    public void install() {
        if (this.logHandler == null) {
            this.logHandler = new LogHandler();
            this.logHandler.setLevel(Rflow.settings().getLogConsoleLevel());
            Logger logger = Logger.getLogger("com.ef_prime");
            logger.addHandler(this.logHandler);
        }
    }

    public void uninstall() {
        if (this.logHandler != null) {
            Logger logger = Logger.getLogger("com.ef_prime");
            logger.removeHandler(this.logHandler);
            this.logHandler = null;
        }
    }

    private void refreshSessions() {
        this.sessionListModel.clear();
        Date date = LogManager.getInstance().getDateFromFile(LogManager.getInstance().getLogFile());
        if (date == null) {
            date = new Date();
        }
        this.sessionListModel.addElement(new LogSession(null, date));
        File file = UserFolder.getLogDir();
        File[] fileArray = file.listFiles();
        if (fileArray == null) {
            return;
        }
        Arrays.sort(fileArray, new DateFileSorter());
        int n = Math.min(fileArray.length, 30);
        String[] stringArray = new String[]{"log", "gz", "zip"};
        for (int i = 0; i < n; ++i) {
            Date date2;
            File file2 = fileArray[i];
            if (!FilenameUtils.isExtension((String)file2.getName(), (String[])stringArray) || file2.equals(LogManager.getInstance().getLogFile()) || (date2 = LogManager.getInstance().getDateFromFile(file2)) == null) continue;
            this.sessionListModel.addElement(new LogSession(file2, date2));
        }
        this.sessionList.setSelectedIndex(0);
    }

    private void setLevelFilter(String string) {
        this.levelFilter.clear();
        if (Level.OFF.getName().equals(string)) {
            return;
        }
        int n = ArrayUtils.indexOf((Object[])LEVELS, (Object)string, (int)0);
        if (n == -1) {
            Collections.addAll(this.levelFilter, LEVELS);
        } else {
            for (int i = n; i < LEVELS.length; ++i) {
                this.levelFilter.add(LEVELS[i]);
            }
        }
    }

    private void refreshLogOutput() {
        LogSession logSession = this.sessionList.getSelectedValue();
        if (logSession == null) {
            return;
        }
        try {
            Document document = this.textPane.getDocument();
            document.remove(0, document.getLength());
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
        new LogReadWorker(logSession.getFile()).execute();
    }

    static {
        StyleConstants.setForeground(CONFIG_ATTR, new Color(0, 128, 0));
    }

    private class LogOutputMouseHandler
    implements MouseListener {
        private LogOutputMouseHandler() {
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            if (UIUtility.isRightMouseButton(mouseEvent)) {
                JPopupMenu jPopupMenu = new JPopupMenu();
                if (LogView.this.textPane.getSelectionStart() != LogView.this.textPane.getSelectionEnd()) {
                    ActionMap actionMap = LogView.this.textPane.getActionMap();
                    JMenuItem jMenuItem = new JMenuItem(actionMap.get("copy-to-clipboard"));
                    jMenuItem.setText(Messages.getString("Action.copy"));
                    jMenuItem.setAccelerator(KeyStroke.getKeyStroke(67, UIUtility.MENU_KEY_MASK));
                    jPopupMenu.add(jMenuItem);
                }
                jPopupMenu.add(new SelectAll());
                jPopupMenu.show((Component)mouseEvent.getSource(), mouseEvent.getX(), mouseEvent.getY());
            }
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
        }
    }

    private static class LogSessionListRenderer
    extends SubstanceDefaultListCellRenderer {
        private LogSessionListRenderer() {
        }

        public Component getListCellRendererComponent(JList<?> jList, Object object, int n, boolean bl, boolean bl2) {
            super.getListCellRendererComponent(jList, object, n, bl, bl2);
            LogSession logSession = (LogSession)object;
            this.setText(logSession.getTitle());
            return this;
        }
    }

    private class LogSessionSelectionHandler
    implements ListSelectionListener {
        private LogSessionSelectionHandler() {
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            if (listSelectionEvent.getValueIsAdjusting()) {
                return;
            }
            LogView.this.refreshLogOutput();
        }
    }

    private class LevelSelectorHandler
    implements ActionListener {
        private LevelSelectorHandler() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            JComboBox jComboBox = (JComboBox)Utility.cast(actionEvent.getSource());
            String string = jComboBox.getSelectedItem().toString();
            LogView.this.setLevelFilter(string);
            LogView.this.refreshLogOutput();
        }
    }

    private class SaveAs
    extends LoggableAction {
        public SaveAs() {
            this.putValue("Name", Messages.getStringWithDots("Action.save_as"));
            this.putValue("ShortDescription", this.getValue("Name"));
            this.putValue("SmallIcon", Icons.getIcon("16/diskette.png"));
        }

        @Override
        public void action(ActionEvent actionEvent) {
            LogSession logSession = LogView.this.sessionList.getSelectedValue();
            if (logSession == null) {
                return;
            }
            File file = UIUtility.chooseFileAwt(Rflow.mainFrame(), Messages.getString("Action.save"), 1, WorkingDirectory.toAbsolutePath(new File(logSession.getFile().getName())));
            if (file == null) {
                return;
            }
            try {
                Files.copy(logSession.getFile().toPath(), file.toPath(), StandardCopyOption.REPLACE_EXISTING);
            }
            catch (IOException iOException) {
                UIUtility.showErrorDialog((Component)Rflow.mainFrame(), iOException);
            }
        }
    }

    private class LogHandler
    extends Handler {
        private static final int LIMIT = 65000;

        public LogHandler() {
            this.setFormatter(new LogFormatter());
        }

        @Override
        public void publish(LogRecord logRecord) {
            if (logRecord.getLevel().intValue() >= Level.WARNING.intValue()) {
                UIUtility.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        LogView.this.setUnread(true);
                    }
                });
            }
            if (LogView.this.sessionList == null || LogView.this.textPane == null) {
                return;
            }
            LogSession logSession = LogView.this.sessionList.getSelectedValue();
            if (logSession == null || !logSession.isCurrent()) {
                return;
            }
            if (!LogView.this.levelFilter.contains(logRecord.getLevel().getName())) {
                return;
            }
            final String string = this.getFormatter().format(logRecord);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    Document document = LogView.this.textPane.getDocument();
                    try {
                        document.insertString(document.getLength(), string, null);
                    }
                    catch (BadLocationException badLocationException) {
                        LOGGER.log(Level.SEVERE, "Failed to insert string.", badLocationException);
                    }
                    if (document.getLength() > 65000) {
                        int n = document.getLength() - 65000;
                        try {
                            String string2 = document.getText(0, document.getLength());
                            int n2 = string2.indexOf(10, n) + 1;
                            if (n2 > 0) {
                                document.remove(0, n2);
                            }
                        }
                        catch (BadLocationException badLocationException) {
                            LOGGER.log(Level.SEVERE, "Failed to remove text.", badLocationException);
                        }
                    }
                    LogView.this.textPane.setCaretPosition(document.getLength());
                }
            });
        }

        @Override
        public void flush() {
        }

        @Override
        public void close() throws SecurityException {
        }
    }

    private static class LogSession {
        private static final DateFormat TITLE_FORMAT = new SimpleDateFormat("yyyy-MM-dd HH:mm");
        private File file;
        private Date date;

        public LogSession(File file, Date date) {
            this.file = file;
            this.date = date;
        }

        public boolean isCurrent() {
            return this.file == null;
        }

        public File getFile() {
            if (this.file == null) {
                return LogManager.getInstance().getLogFile();
            }
            return this.file;
        }

        public String getTitle() {
            String string = TITLE_FORMAT.format(this.date);
            return this.isCurrent() ? string + " " + Messages.getString("View.AppLog.current") : string;
        }
    }

    private static class DateFileSorter
    implements Comparator<File> {
        private DateFileSorter() {
        }

        @Override
        public int compare(File file, File file2) {
            int n = file.getName().compareTo(file2.getName());
            if (n != 0) {
                return -n;
            }
            if (file.lastModified() < file2.lastModified()) {
                return 1;
            }
            return -1;
        }
    }

    private class LogReadWorker
    extends SwingWorker<List<String>, Object> {
        private File file;

        public LogReadWorker(File file) {
            this.file = file;
        }

        @Override
        protected List<String> doInBackground() throws Exception {
            ArrayList<String> arrayList = new ArrayList<String>();
            if (FilenameUtils.isExtension((String)this.file.getName(), (String)"gz")) {
                try (BufferedReader bufferedReader = new BufferedReader(new InputStreamReader((InputStream)new GZIPInputStream(new FileInputStream(this.file)), StandardCharsets.UTF_8));){
                    this.readLines(bufferedReader, arrayList);
                }
            }
            if (FilenameUtils.isExtension((String)this.file.getName(), (String)"zip")) {
                try (ZipInputStream zipInputStream = new ZipInputStream((InputStream)new FileInputStream(this.file), StandardCharsets.UTF_8);
                     BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(zipInputStream));){
                    ZipEntry zipEntry;
                    int n = 0;
                    while ((zipEntry = zipInputStream.getNextEntry()) != null) {
                        if (zipEntry.isDirectory()) continue;
                        if (n > 2) {
                        }
                        if (n > 0) {
                            arrayList.add("\n");
                            arrayList.add("============================== R Process Log ==============================\n");
                            arrayList.add("\n");
                        }
                        this.readLines(bufferedReader, arrayList);
                        ++n;
                    }
                }
            } else {
                try (BufferedReader bufferedReader = Files.newBufferedReader(this.file.toPath(), StandardCharsets.UTF_8);){
                    this.readLines(bufferedReader, arrayList);
                }
            }
            return arrayList;
        }

        private void readLines(BufferedReader bufferedReader, List<String> list) throws IOException {
            String string;
            while ((string = bufferedReader.readLine()) != null) {
                String string2;
                if (string.isEmpty()) continue;
                if (string.charAt(0) == '#') {
                    list.add(string + "\n");
                    continue;
                }
                StringBuilder stringBuilder = new StringBuilder(128);
                String[] stringArray = string.split("\t", 5);
                if (stringArray.length < 5 || !LogView.this.levelFilter.contains(string2 = stringArray[1])) continue;
                String string3 = stringArray[0];
                String string4 = stringArray[2];
                String string5 = stringArray[3];
                String string6 = stringArray[4];
                stringBuilder.append(string3);
                stringBuilder.append('\n');
                stringBuilder.append(string2);
                stringBuilder.append(": ");
                stringBuilder.append(string4);
                if (!string4.isEmpty()) {
                    stringBuilder.append(" ");
                }
                stringBuilder.append(string5);
                stringBuilder.append('\n');
                if (!string6.isEmpty()) {
                    stringBuilder.append(string6.replaceAll("\\\\n", "\n").replaceAll("\\\\t", "\t"));
                    stringBuilder.append('\n');
                }
                list.add(stringBuilder.toString());
            }
        }

        @Override
        protected void done() {
            try {
                List list = (List)this.get();
                for (String string : list) {
                    if (string.isEmpty()) continue;
                    Document document = LogView.this.textPane.getDocument();
                    SimpleAttributeSet simpleAttributeSet = string.charAt(0) == '#' ? CONFIG_ATTR : null;
                    document.insertString(document.getLength(), string, simpleAttributeSet);
                }
            }
            catch (InterruptedException | ExecutionException | BadLocationException exception) {
                LOGGER.log(Level.WARNING, "Failed to load log file.", exception);
            }
        }
    }

    private class SelectAll
    extends LoggableAction {
        public SelectAll() {
            this.putValue("Name", Messages.getString("Action.select_all"));
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(65, UIUtility.MENU_KEY_MASK));
        }

        @Override
        public void action(ActionEvent actionEvent) {
            LogView.this.textPane.selectAll();
            LogView.this.textPane.requestFocusInWindow();
        }
    }
}

