/*
 * Decompiled with CFR 0.152.
 */
package com.ef_prime.rflow.ui.base;

import com.ef_prime.rflow.Rflow;
import com.ef_prime.rflow.core.base.FileEdit;
import com.ef_prime.rflow.core.base.FileEditEvent;
import com.ef_prime.rflow.core.base.FileEditEventHandler;
import com.ef_prime.rflow.core.base.FileEditManager;
import com.ef_prime.rflow.core.base.FileResource;
import com.ef_prime.rflow.core.base.Project;
import com.ef_prime.rflow.core.base.RflowEventHandler;
import com.ef_prime.rflow.core.base.Settings;
import com.ef_prime.rflow.core.common.keyvalue.ValueChangeEvent;
import com.ef_prime.rflow.core.common.keyvalue.ValueChangeEventHandler;
import com.ef_prime.rflow.core.flow.FlowModel;
import com.ef_prime.rflow.ui.base.Bar;
import com.ef_prime.rflow.ui.base.WindowSizeSetEvent;
import com.ef_prime.rflow.ui.common.component.Flavors;
import com.ef_prime.rflow.ui.common.event.EventManager;
import com.ef_prime.rflow.ui.util.UIUtility;
import com.ef_prime.rflow.ui.view.ActiveViewEvent;
import com.ef_prime.rflow.ui.view.ActiveViewEventHandler;
import com.ef_prime.rflow.ui.view.MainView;
import com.google.common.collect.Lists;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Point;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.io.File;
import java.util.List;
import javax.swing.JFrame;
import javax.swing.JPanel;

public class MainFrame
extends JFrame
implements ComponentListener {
    private JPanel panel;
    private MainView mainView;
    private Bar bar;
    boolean sizeSet;
    private Cursor defaultCursor = this.getGlassPane().getCursor();

    public MainFrame() {
        super("R AnalyticFlow");
        int n;
        Cloneable cloneable;
        Handler handler = new Handler();
        Rflow.settings().addEventHandler(handler);
        Rflow.getInstance().addRflowEventHandler(handler);
        EventManager.getInstance().registerEventHandler(ActiveViewEvent.class, handler);
        FileEditManager.getInstance().addEventHandler(handler);
        this.setDefaultCloseOperation(0);
        this.setIconImage(FileResource.getIcon("img/desktop_16.png").getImage());
        List list = (List)((Object)Rflow.settings().getValue(Settings.WINDOW_SIZE));
        List list2 = (List)((Object)Rflow.settings().getValue(Settings.WINDOW_LOCATION));
        int n2 = Rflow.settings().getValue(Settings.WINDOW_MAXIMIZED);
        Dimension dimension = null;
        if (list.size() == 2) {
            try {
                dimension = new Dimension((Integer)list.get(0), (Integer)list.get(1));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (dimension == null) {
            cloneable = UIUtility.getScreenBounds();
            int n3 = (int)((double)cloneable.height * 0.86);
            n = (int)((double)cloneable.width * 0.86);
            dimension = new Dimension(n, n3);
        }
        this.setSize(dimension);
        cloneable = null;
        if (list2.size() == 2) {
            try {
                cloneable = new Point((Integer)list2.get(0), (Integer)list2.get(1));
                GraphicsDevice[] graphicsDeviceArray = GraphicsEnvironment.getLocalGraphicsEnvironment().getScreenDevices();
                n = 0;
                for (int i = 0; i < graphicsDeviceArray.length; ++i) {
                    GraphicsConfiguration graphicsConfiguration = graphicsDeviceArray[i].getDefaultConfiguration();
                    if (!graphicsConfiguration.getBounds().contains((Point)cloneable)) continue;
                    n = 1;
                    break;
                }
                if (n == 0) {
                    cloneable = null;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (cloneable == null) {
            this.setLocationRelativeTo(null);
        } else {
            this.setLocation((Point)cloneable);
        }
        switch (n2) {
            case 6: {
                this.setExtendedState(6);
                break;
            }
            case 2: {
                this.setExtendedState(2);
                break;
            }
            case 4: {
                this.setExtendedState(4);
            }
        }
        this.setLayout(new BorderLayout());
        this.addComponentListener(this);
        this.setDropTarget(new DropTarget(this, new DropHandler()));
        this.panel = new JPanel(new BorderLayout());
        this.mainView = new MainView();
        this.panel.add((Component)((Object)this.mainView), "Center");
        this.bar = new Bar();
        this.refreshToolbarLocation();
        this.add((Component)this.panel, "Center");
    }

    public MainView getMainView() {
        return this.mainView;
    }

    public void setWaitingCursor(boolean bl) {
        Component component = this.getGlassPane();
        if (bl) {
            component.setCursor(Cursor.getPredefinedCursor(3));
            component.setVisible(true);
        } else {
            component.setCursor(this.defaultCursor);
            component.setVisible(false);
        }
    }

    private void refreshTitle() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("R AnalyticFlow");
        stringBuilder.append("  -  ");
        Project project = Rflow.project();
        stringBuilder.append(project.getName());
        FileEdit fileEdit = Rflow.mainView().getActiveFileEdit();
        if (fileEdit != null) {
            stringBuilder.append(" > ");
            if (fileEdit.isDirty()) {
                stringBuilder.append("*");
            }
            stringBuilder.append(fileEdit.getFileEditName());
        }
        UIUtility.invokeLater(() -> this.setTitle(stringBuilder.toString()));
    }

    private void refreshToolbarLocation() {
        String string = "North";
        switch (Rflow.settings().getValue(Settings.TOOLBAR_LOCATION)) {
            case 1: {
                string = "East";
                this.bar.setOrientation(1);
                break;
            }
            case 2: {
                string = "South";
                this.bar.setOrientation(0);
                break;
            }
            case 3: {
                string = "West";
                this.bar.setOrientation(1);
                break;
            }
            default: {
                this.bar.setOrientation(0);
            }
        }
        this.panel.remove(this.bar);
        this.panel.add((Component)this.bar, string);
        this.panel.revalidate();
        this.panel.repaint();
    }

    public static boolean topLevelCanImport(Transferable transferable) {
        if (transferable.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
            List<File> list = Flavors.getFiles(transferable);
            if (list == null) {
                return false;
            }
            if (list.size() == 1) {
                return FlowModel.isRflow(list.get(0).getName());
            }
            return false;
        }
        return false;
    }

    public static boolean handleTopLevelDrop(Transferable transferable) {
        if (transferable.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
            List<File> list = Flavors.getFiles(transferable);
            if (list == null) {
                return true;
            }
            Rflow.getInstance().getActions().open(list);
            return true;
        }
        return false;
    }

    @Override
    public void componentResized(ComponentEvent componentEvent) {
        if (this.getExtendedState() == 0) {
            Dimension dimension = this.getSize();
            Rflow.settings().putValue(Settings.WINDOW_SIZE, Lists.newArrayList((Object[])new Integer[]{dimension.width, dimension.height}));
        }
        if (!this.sizeSet) {
            EventManager.getInstance().dispatchEvent(new WindowSizeSetEvent());
            this.sizeSet = true;
        }
    }

    @Override
    public void componentMoved(ComponentEvent componentEvent) {
        if (this.getExtendedState() == 0) {
            Rflow.settings().putValue(Settings.WINDOW_LOCATION, Lists.newArrayList((Object[])new Integer[]{this.getLocation().x, this.getLocation().y}));
        }
    }

    @Override
    public void componentShown(ComponentEvent componentEvent) {
    }

    @Override
    public void componentHidden(ComponentEvent componentEvent) {
    }

    private class Handler
    implements ValueChangeEventHandler,
    RflowEventHandler,
    ActiveViewEventHandler,
    FileEditEventHandler {
        private Handler() {
        }

        @Override
        public void valueChanged(ValueChangeEvent valueChangeEvent) {
            if (Settings.TOOLBAR_LOCATION.equals(valueChangeEvent.getKey())) {
                MainFrame.this.refreshToolbarLocation();
            }
        }

        @Override
        public void rflowWillShutdown() {
            this.saveSizeAndLocation();
        }

        @Override
        public void rflowProjectDidStart() {
            MainFrame.this.refreshTitle();
        }

        @Override
        public void rflowProjectWillEnd() {
            MainFrame.this.refreshTitle();
        }

        private void saveSizeAndLocation() {
            int n = 0;
            switch (MainFrame.this.getExtendedState()) {
                case 6: {
                    n = 6;
                    break;
                }
                case 2: {
                    n = 2;
                    break;
                }
                case 4: {
                    n = 4;
                }
            }
            Rflow.settings().putValue(Settings.WINDOW_MAXIMIZED, n);
        }

        @Override
        public void activeViewChanged(ActiveViewEvent activeViewEvent) {
            if (activeViewEvent.isActiveFileEditChanged()) {
                MainFrame.this.refreshTitle();
            }
        }

        @Override
        public void fileEditStateChanged(FileEditEvent fileEditEvent) {
            MainFrame.this.refreshTitle();
        }
    }

    private class DropHandler
    implements DropTargetListener {
        private DropHandler() {
        }

        @Override
        public void dragEnter(DropTargetDragEvent dropTargetDragEvent) {
        }

        @Override
        public void dragExit(DropTargetEvent dropTargetEvent) {
        }

        @Override
        public void dragOver(DropTargetDragEvent dropTargetDragEvent) {
            Transferable transferable = dropTargetDragEvent.getTransferable();
            if (MainFrame.topLevelCanImport(transferable)) {
                dropTargetDragEvent.acceptDrag(dropTargetDragEvent.getDropAction());
            } else {
                dropTargetDragEvent.rejectDrag();
            }
        }

        @Override
        public void dropActionChanged(DropTargetDragEvent dropTargetDragEvent) {
        }

        @Override
        public void drop(DropTargetDropEvent dropTargetDropEvent) {
            boolean bl = false;
            if (MainFrame.topLevelCanImport(dropTargetDropEvent.getTransferable())) {
                dropTargetDropEvent.acceptDrop(dropTargetDropEvent.getDropAction());
                bl = MainFrame.handleTopLevelDrop(dropTargetDropEvent.getTransferable());
            }
            if (!bl) {
                dropTargetDropEvent.rejectDrop();
            }
            dropTargetDropEvent.dropComplete(bl);
        }
    }
}

