/*
 * Decompiled with CFR 0.152.
 */
package com.ef_prime.rflow.ui.base;

import com.ef_prime.rflow.Rflow;
import com.ef_prime.rflow.RflowActions;
import com.ef_prime.rflow.core.base.FileResource;
import com.ef_prime.rflow.core.base.SampleEntry;
import com.ef_prime.rflow.core.base.Settings;
import com.ef_prime.rflow.core.common.keyvalue.ValueChangeEvent;
import com.ef_prime.rflow.core.common.keyvalue.ValueChangeEventHandler;
import com.ef_prime.rflow.core.flow.FlowModel;
import com.ef_prime.rflow.resource.Messages;
import com.ef_prime.rflow.ui.base.MenuActionProvider;
import com.ef_prime.rflow.ui.common.component.Actions;
import com.ef_prime.rflow.ui.common.event.EventManager;
import com.ef_prime.rflow.ui.common.view.View;
import com.ef_prime.rflow.ui.flow.FlowViewer;
import com.ef_prime.rflow.ui.util.FontSupport;
import com.ef_prime.rflow.ui.view.ActiveViewEvent;
import com.ef_prime.rflow.ui.view.ActiveViewEventHandler;
import java.awt.Component;
import java.io.File;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Action;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JPopupMenu;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class MenuBar
extends JMenuBar
implements ActiveViewEventHandler,
ValueChangeEventHandler {
    private static final Logger LOGGER = Logger.getLogger(MenuBar.class.getName());
    private RflowActions actions;
    private JMenu helpMenu;
    private JMenu tutorial;

    public MenuBar(RflowActions rflowActions, Actions actions) {
        this.actions = rflowActions;
        EventManager.getInstance().registerEventHandler(ActiveViewEvent.class, this);
        Rflow.settings().addEventHandler(this);
        JMenu jMenu = new JMenu(Messages.getString("Menu.file"));
        jMenu.add(rflowActions.get("NEW_FLOW"));
        jMenu.add(rflowActions.get("OPEN_FLOW"));
        jMenu.addSeparator();
        jMenu.add(rflowActions.get("MENU_ACTION_SAVE"));
        jMenu.add(rflowActions.get("MENU_ACTION_SAVE_AS"));
        jMenu.addSeparator();
        jMenu.add(rflowActions.get("EXIT"));
        jMenu.getPopupMenu().addPopupMenuListener(new GeneralMenuActionPopupListener("MENU_ACTION_SAVE", "MENU_ACTION_SAVE_AS"));
        JMenu jMenu2 = new JMenu(Messages.getString("Menu.edit"));
        jMenu2.add(rflowActions.get("MENU_ACTION_UNDO"));
        jMenu2.add(rflowActions.get("MENU_ACTION_REDO"));
        jMenu2.addSeparator();
        jMenu2.add(rflowActions.get("MENU_ACTION_CUT"));
        jMenu2.add(rflowActions.get("MENU_ACTION_COPY"));
        jMenu2.add(rflowActions.get("MENU_ACTION_PASTE"));
        jMenu2.addSeparator();
        jMenu2.add(rflowActions.get("MENU_ACTION_FIND"));
        jMenu2.getPopupMenu().addPopupMenuListener(new GeneralMenuActionPopupListener("MENU_ACTION_UNDO", "MENU_ACTION_REDO", "MENU_ACTION_CUT", "MENU_ACTION_COPY", "MENU_ACTION_PASTE"));
        JMenu jMenu3 = new JMenu(Messages.getString("Menu.view"));
        jMenu3.add(actions.get("ViewTabbedPane.CLOSE"));
        jMenu3.add(actions.get("OPEN_GD"));
        JMenu jMenu4 = new JMenu(Messages.getString("Menu.run"));
        jMenu4.getPopupMenu().addPopupMenuListener(new ExecPopupListener());
        JMenu jMenu5 = new JMenu(Messages.getString("Menu.project"));
        jMenu5.getPopupMenu().addPopupMenuListener(new ProjectPopupListener());
        JMenu jMenu6 = new JMenu(Messages.getString("Menu.option"));
        jMenu6.add(rflowActions.get("PREFERENCES"));
        jMenu6.add(rflowActions.get("CHANGE_DIRECTORY"));
        if (Rflow.isDevel()) {
            jMenu6.add(rflowActions.get("DEVEL_SKIN"));
            jMenu6.add(rflowActions.get("DEVEL_SETTINGS_ACTION"));
        }
        this.helpMenu = new JMenu(Messages.getString("Menu.help"));
        this.tutorial = this.createTutorialMenu();
        this.refreshHelpMenu();
        this.add(jMenu);
        this.add(jMenu2);
        this.add(jMenu3);
        this.add(jMenu4);
        this.add(jMenu5);
        this.add(jMenu6);
        this.add(this.helpMenu);
        this.refreshFontSize();
    }

    private void refreshFontSize() {
        for (Component component : this.getComponents()) {
            if (!(component instanceof JMenu)) continue;
            FontSupport.setFont(component, Settings.BASIC_FONT_SIZE);
        }
    }

    private boolean isFlowModel() {
        return this.getFlowModel() != null;
    }

    private FlowModel getFlowModel() {
        return Rflow.mainView().getActiveFlowModel();
    }

    private void refreshHelpMenu() {
        this.helpMenu.removeAll();
        if (Rflow.project() != null && this.isFlowModel() && this.getFlowModel().isSample()) {
            SampleEntry sampleEntry = this.getFlowModel().getSample().getNextSample();
            this.helpMenu.add(this.actions.createNextTutorialAction(sampleEntry));
            this.helpMenu.addSeparator();
        }
        if (this.tutorial != null) {
            this.helpMenu.add(this.tutorial);
        }
        this.helpMenu.add(this.actions.get("FIRST_GUIDE"));
        this.helpMenu.add(this.actions.get("LOG"));
        this.helpMenu.add(this.actions.get("ABOUT"));
    }

    private JMenu createTutorialMenu() {
        Document document;
        Object object;
        File file = FileResource.getSampleFolder();
        if (!file.exists() || !file.isDirectory()) {
            return null;
        }
        File file2 = new File(file.getParentFile(), "structure.xml");
        if (!file2.exists()) {
            return null;
        }
        try {
            object = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            document = ((DocumentBuilder)object).parse(file2);
        }
        catch (Exception exception) {
            LOGGER.log(Level.SEVERE, "Failed to read tutorial structure file.", exception);
            return null;
        }
        object = this.addSampleMenuItem(null, document.getDocumentElement());
        if (object == null || ((JMenu)object).getItemCount() == 0) {
            return null;
        }
        return object;
    }

    private JMenu addSampleMenuItem(JMenu jMenu, Node node) {
        if (node.getNodeType() != 1) {
            return null;
        }
        Element element = (Element)node;
        String string = node.getNodeName();
        SampleEntry sampleEntry = new SampleEntry(element);
        boolean bl = "structure".equals(string);
        if (bl || "dir".equals(string)) {
            JMenu jMenu2 = new JMenu(sampleEntry.getName());
            if (jMenu != null) {
                jMenu.add(jMenu2);
            }
            NodeList nodeList = node.getChildNodes();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                this.addSampleMenuItem(jMenu2, nodeList.item(i));
            }
            return jMenu2;
        }
        if ("file".equals(string)) {
            jMenu.add(this.actions.createTutorialSelectionAction(sampleEntry));
        }
        return null;
    }

    @Override
    public void activeViewChanged(ActiveViewEvent activeViewEvent) {
        if (activeViewEvent.isActiveFileEditChanged()) {
            this.refreshHelpMenu();
        }
    }

    @Override
    public void valueChanged(ValueChangeEvent valueChangeEvent) {
        if (Settings.BASIC_FONT_SIZE.equals(valueChangeEvent.getKey())) {
            this.refreshFontSize();
        }
    }

    private class GeneralMenuActionPopupListener
    implements PopupMenuListener {
        private String[] keys;

        public GeneralMenuActionPopupListener(String ... stringArray) {
            this.keys = stringArray;
        }

        @Override
        public void popupMenuWillBecomeVisible(PopupMenuEvent popupMenuEvent) {
            View view2 = Rflow.mainView().getActiveView();
            if (view2 instanceof MenuActionProvider) {
                MenuActionProvider menuActionProvider = (MenuActionProvider)((Object)view2);
                for (String string : this.keys) {
                    Action action = menuActionProvider.getAction(string);
                    boolean bl = action != null && action.isEnabled();
                    MenuBar.this.actions.get(string).setEnabled(bl);
                }
            } else {
                for (String string : this.keys) {
                    MenuBar.this.actions.get(string).setEnabled(false);
                }
            }
        }

        @Override
        public void popupMenuWillBecomeInvisible(PopupMenuEvent popupMenuEvent) {
        }

        @Override
        public void popupMenuCanceled(PopupMenuEvent popupMenuEvent) {
        }
    }

    private class ExecPopupListener
    implements PopupMenuListener {
        private ExecPopupListener() {
        }

        @Override
        public void popupMenuWillBecomeVisible(PopupMenuEvent popupMenuEvent) {
            JPopupMenu jPopupMenu = (JPopupMenu)popupMenuEvent.getSource();
            jPopupMenu.removeAll();
            FlowViewer flowViewer = Rflow.mainView().getActiveFlowViewer();
            if (flowViewer != null) {
                jPopupMenu.add(flowViewer.getViewerAction("RUN"));
                jPopupMenu.add(flowViewer.getViewerAction("RUN_CLEAR"));
                jPopupMenu.add(flowViewer.getViewerAction("RUN_SELECTED"));
            }
            jPopupMenu.add(MenuBar.this.actions.get("R_STOP"));
        }

        @Override
        public void popupMenuWillBecomeInvisible(PopupMenuEvent popupMenuEvent) {
        }

        @Override
        public void popupMenuCanceled(PopupMenuEvent popupMenuEvent) {
        }
    }

    private class ProjectPopupListener
    implements PopupMenuListener {
        private ProjectPopupListener() {
        }

        @Override
        public void popupMenuWillBecomeVisible(PopupMenuEvent popupMenuEvent) {
            JPopupMenu jPopupMenu = (JPopupMenu)popupMenuEvent.getSource();
            jPopupMenu.removeAll();
            jPopupMenu.add(MenuBar.this.actions.get("PROJECTS"));
            if (!Rflow.project().isNewProject()) {
                jPopupMenu.add(MenuBar.this.actions.get("BOOKMARK"));
            }
            if (Rflow.project().isNewProject()) {
                jPopupMenu.add(MenuBar.this.actions.get("SAVE_PROJECT"));
            }
            jPopupMenu.addSeparator();
            jPopupMenu.add(MenuBar.this.actions.get("IMPORT_PROJECT"));
            jPopupMenu.add(MenuBar.this.actions.get("EXPORT_PROJECT"));
            jPopupMenu.addSeparator();
            jPopupMenu.add(MenuBar.this.actions.get("PROJECT_PROPERTIES"));
        }

        @Override
        public void popupMenuWillBecomeInvisible(PopupMenuEvent popupMenuEvent) {
        }

        @Override
        public void popupMenuCanceled(PopupMenuEvent popupMenuEvent) {
        }
    }
}

