/*
 * Decompiled with CFR 0.152.
 */
package com.ef_prime.rflow.ui.base;

import com.ef_prime.rflow.Rflow;
import com.ef_prime.rflow.core.common.keyvalue.FileKey;
import com.ef_prime.rflow.core.common.keyvalue.Key;
import com.ef_prime.rflow.core.common.keyvalue.KeyWidgetNode;
import com.ef_prime.rflow.core.common.keyvalue.ValueMap;
import com.ef_prime.rflow.resource.Messages;
import com.ef_prime.rflow.ui.common.keyvalue.WidgetFactory;
import com.ef_prime.rflow.ui.common.view.View;
import com.ef_prime.rflow.ui.util.UIUtility;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import javax.swing.JLabel;
import javax.swing.JRadioButton;
import net.miginfocom.layout.CC;
import net.miginfocom.swing.MigLayout;

public class OpeningRflowFileView
extends View {
    public static final String OPEN = "open";
    public static final String OPEN_IN_NEW_PROJECT = "open_in_new_project";
    public static final String IMPORT = "import";
    private JRadioButton[] types;
    private ValueMap valueMap = new DirValueMap();
    private FileKey importDirKey = ((FileKey.Builder)((Key.Builder)((FileKey.Builder)((Key.Builder)FileKey.builder("", "").setMode(1)).setDynamicDefault(true)).setAbstractPathEnabled(false)).setFillDefaultOnFocus(true)).build();
    private Component importDir;

    public OpeningRflowFileView(boolean bl) {
        this.setLayout((LayoutManager)new MigLayout("insets 0 0 0 10, fillx"));
        if (bl) {
            this.add((Component)new JLabel(Messages.getString("View.OpenFlowFile.import")), new CC().wrap());
        } else {
            this.types = UIUtility.createRadioButtons(new String[]{Messages.getString("View.OpenFlowFile.open"), Messages.getString("View.OpenFlowFile.open_new_project"), Messages.getString("View.OpenFlowFile.import")}, 0);
            this.types[2].addItemListener(new ImportButtonItemListener());
            this.add((Component)this.types[0], new CC().wrap());
            this.add((Component)new JLabel(Messages.getString("View.OpenFlowFile.open_description")), new CC().gapLeft("20").wrap());
            this.add((Component)this.types[1], new CC().wrap());
            this.add((Component)new JLabel(Messages.getString("View.OpenFlowFile.open_new_project_description")), new CC().gapLeft("20").wrap());
            this.add((Component)this.types[2], new CC().wrap());
        }
        JLabel jLabel = new JLabel(Messages.getString("View.OpenFlowFile.import_description"));
        this.valueMap.putValue(this.importDirKey, null);
        this.importDir = WidgetFactory.getInstance().create(this.valueMap, new KeyWidgetNode(this.importDirKey));
        this.add((Component)jLabel, new CC().gapLeft("20").wrap());
        this.add(this.importDir, new CC().growX().gapLeft("20").wrap());
        if (!bl) {
            this.refreshState();
        }
    }

    private void refreshState() {
        boolean bl = this.types[2].isSelected();
        UIUtility.setEnabled(bl, this.importDir);
    }

    public String getType() {
        if (this.types[0].isSelected()) {
            return OPEN;
        }
        return this.types[1].isSelected() ? OPEN_IN_NEW_PROJECT : IMPORT;
    }

    public File getImportDestinationDir() {
        File file = new File(this.valueMap.getValueOrDefault(this.importDirKey));
        if (file.getPath().isEmpty()) {
            file = Rflow.project().getLocation();
        }
        return file;
    }

    private static class DirValueMap
    extends ValueMap {
        private DirValueMap() {
        }

        @Override
        public Object getDynamicDefaultValue(Key<?> key) {
            return Rflow.project().getLocation().getAbsolutePath();
        }
    }

    private class ImportButtonItemListener
    implements ItemListener {
        private ImportButtonItemListener() {
        }

        @Override
        public void itemStateChanged(ItemEvent itemEvent) {
            OpeningRflowFileView.this.refreshState();
        }
    }
}

