/*
 * Decompiled with CFR 0.152.
 */
package com.ef_prime.rflow.ui.base;

import com.ef_prime.rflow.core.app.file.FileUtility;
import com.ef_prime.rflow.core.base.Project;
import com.ef_prime.rflow.core.base.UserFolder;
import com.ef_prime.rflow.core.base.WorkingDirectory;
import com.ef_prime.rflow.core.common.keyvalue.BoolKey;
import com.ef_prime.rflow.core.common.keyvalue.FileKey;
import com.ef_prime.rflow.core.common.keyvalue.PanelWidgetNode;
import com.ef_prime.rflow.core.common.keyvalue.ValueMap;
import com.ef_prime.rflow.resource.Messages;
import com.ef_prime.rflow.ui.base.Icons;
import com.ef_prime.rflow.ui.common.component.AlphaIcon;
import com.ef_prime.rflow.ui.common.component.ProgressPanel;
import com.ef_prime.rflow.ui.common.component.RflowTree;
import com.ef_prime.rflow.ui.common.keyvalue.WidgetFactory;
import com.ef_prime.rflow.ui.common.tree.BasicTreeCellRenderer;
import com.ef_prime.rflow.ui.common.view.Page;
import com.ef_prime.rflow.ui.common.view.PagesView;
import com.ef_prime.rflow.ui.common.view.PagesViewFactory;
import com.ef_prime.rflow.ui.util.TreeUtils;
import com.ef_prime.rflow.ui.util.UIUtility;
import com.ef_prime.rflow.ui.view.FileNode;
import com.ef_prime.rflow.ui.view.SelectableFileNode;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.swing.Icon;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.SwingWorker;
import javax.swing.Timer;
import javax.swing.border.EmptyBorder;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.ExpandVetoException;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.apache.commons.io.FilenameUtils;

public class ProjectExportView
extends Page
implements TreeWillExpandListener {
    private static final Logger LOGGER = Logger.getLogger(ProjectExportView.class.getName());
    private static final FileKey OUTPUT_FILE = ((FileKey.Builder)((FileKey.Builder)((FileKey.Builder)FileKey.builder("output", Messages.getString("Message.export_to")).setDefaultDirectory(":user_documents")).setAbstractPathEnabled(false)).setType(1)).build();
    private static final BoolKey FLOW_FILES = ((BoolKey.Builder)BoolKey.builder("flow_files", Messages.getString("Message.include_meta_data")).setLabelPosition("none")).build();
    private Project project;
    private ValueMap options = new ValueMap();
    private JTree fileTree;
    private Executor executor = new ThreadPoolExecutor(0, 1, 1L, TimeUnit.MINUTES, new LinkedBlockingQueue<Runnable>());

    public ProjectExportView(Project project) {
        this.project = project;
        this.setTitle(Messages.getString("Action.export_project"));
        this.options.putValue(OUTPUT_FILE, new File(UserFolder.getUserDocumentsDir(), FileUtility.toLegalFileName(project.getName()) + ".zip").getAbsolutePath());
        this.add(WidgetFactory.getInstance().create(this.options, new PanelWidgetNode().addKeys(OUTPUT_FILE)), "North");
        this.add(WidgetFactory.getInstance().create(this.options, new PanelWidgetNode().addKeys(FLOW_FILES)), "South");
        SelectableFileNode selectableFileNode = new SelectableFileNode(project.getLocation(), true, new Predicate<SelectableFileNode>(){

            @Override
            public boolean test(SelectableFileNode selectableFileNode) {
                if (!selectableFileNode.isDirectory()) {
                    return true;
                }
                String string = selectableFileNode.getFile().getName();
                return !string.equals(".afp") && !string.equals(".raf");
            }
        });
        DefaultTreeModel defaultTreeModel = new DefaultTreeModel(selectableFileNode, true);
        this.fileTree = new RflowTree(defaultTreeModel);
        this.fileTree.setShowsRootHandles(true);
        this.fileTree.addTreeWillExpandListener(this);
        this.fileTree.setCellRenderer(new SelectingFileTreeRenderer());
        UIUtility.insertMouseListener(this.fileTree, new MouseHandler());
        JScrollPane jScrollPane = new JScrollPane(this.fileTree);
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add((Component)new JLabel(Messages.getString("Message.include_")), "North");
        jPanel.add((Component)jScrollPane, "Center");
        this.add((Component)jPanel, "Center");
        this.refresh(selectableFileNode);
    }

    public static void showExportDialog(Window window, Project project) {
        ProjectExportView projectExportView = new ProjectExportView(project);
        PagesView pagesView = PagesViewFactory.createOkCancelView(projectExportView, Messages.getString("Action.export"), Icons.getIcon("16/go.png"));
        pagesView.showDialog(window, projectExportView.getTitle(), true, new Dimension(600, 600));
    }

    private DefaultTreeModel getModel() {
        return (DefaultTreeModel)this.fileTree.getModel();
    }

    private List<TreePath> getExpandedPaths(FileNode fileNode) {
        ArrayList<TreePath> arrayList = new ArrayList<TreePath>();
        ArrayDeque<FileNode> arrayDeque = new ArrayDeque<FileNode>();
        arrayDeque.add((FileNode)this.fileTree.getModel().getRoot());
        TreePath treePath = TreeUtils.getPath(fileNode);
        while (arrayDeque.size() > 0) {
            Enumeration<? extends TreeNode> enumeration = ((FileNode)arrayDeque.poll()).children();
            while (enumeration.hasMoreElements()) {
                TreePath treePath2;
                FileNode fileNode2 = (FileNode)enumeration.nextElement();
                if (fileNode2.isLeaf() || !this.fileTree.isExpanded(treePath2 = TreeUtils.getPath(fileNode2)) || !treePath2.equals(treePath) && !treePath2.isDescendant(treePath) && !treePath.isDescendant(treePath2)) continue;
                arrayDeque.addLast(fileNode2);
                if (!treePath2.equals(treePath) && !treePath.isDescendant(treePath2)) continue;
                arrayList.add(treePath2);
            }
        }
        return arrayList;
    }

    private void refresh(FileNode ... fileNodeArray) {
        for (FileNode fileNode : fileNodeArray) {
            List<TreePath> list = this.getExpandedPaths(fileNode);
            if (list != null && !list.isEmpty()) {
                for (TreePath treePath : list) {
                    this.executor.execute(new RefreshWorker(treePath));
                }
                continue;
            }
            this.executor.execute(new RefreshWorker(TreeUtils.getPath(fileNode)));
        }
    }

    @Override
    public boolean viewWillClose(int n) {
        if (n == 1) {
            File file = WorkingDirectory.toAbsolutePath(new File(this.options.getValue(OUTPUT_FILE)));
            if (!UIUtility.confirmOverwrite(file, this)) {
                return false;
            }
            return ProgressPanel.runWithDialogHandleError(this, null, new ExportWorker(), true, null);
        }
        return true;
    }

    @Override
    public void treeWillExpand(TreeExpansionEvent treeExpansionEvent) throws ExpandVetoException {
        final FileNode fileNode = (FileNode)treeExpansionEvent.getPath().getLastPathComponent();
        if (fileNode.areChildrenReady()) {
            return;
        }
        final SwingWorker<List<FileNode>, Void> swingWorker = new SwingWorker<List<FileNode>, Void>(){

            @Override
            protected List<FileNode> doInBackground() throws Exception {
                return fileNode.retrieveChildren();
            }

            @Override
            protected void done() {
                try {
                    List list = (List)this.get();
                    fileNode.setChildren(list);
                    ProjectExportView.this.getModel().nodeStructureChanged(fileNode);
                    ProjectExportView.this.fileTree.setCursor(Cursor.getDefaultCursor());
                }
                catch (InterruptedException | ExecutionException exception) {
                    LOGGER.log(Level.SEVERE, "Failed to refresh file tree", exception);
                }
            }
        };
        Timer timer = new Timer(200, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (!swingWorker.isDone()) {
                    ProjectExportView.this.fileTree.setCursor(Cursor.getPredefinedCursor(3));
                }
            }
        });
        timer.setRepeats(false);
        timer.start();
        this.executor.execute(swingWorker);
    }

    @Override
    public void treeWillCollapse(TreeExpansionEvent treeExpansionEvent) throws ExpandVetoException {
    }

    private class SelectingFileTreeRenderer
    extends JPanel
    implements TreeCellRenderer {
        private final Icon uncheck = Icons.getIcon("16/check_box_uncheck.png");
        private final Icon mix = Icons.getIcon("16/check_box_mix.png");
        private final Icon check = Icons.getIcon("16/check_box.png");
        private JLabel checkBoxIcon;
        private FileTreeRenderer innerRenderer;

        public SelectingFileTreeRenderer() {
            this.setBackground(Color.WHITE);
            this.checkBoxIcon = new JLabel(this.check);
            this.checkBoxIcon.setBorder(new EmptyBorder(0, 0, 0, 2));
            this.innerRenderer = new FileTreeRenderer();
            this.setLayout(new BorderLayout());
            this.add((Component)this.checkBoxIcon, "West");
            this.add((Component)this.innerRenderer, "Center");
        }

        @Override
        public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
            SelectableFileNode selectableFileNode = (SelectableFileNode)object;
            switch (selectableFileNode.getSelection()) {
                case MIXED: {
                    this.checkBoxIcon.setIcon(this.mix);
                    break;
                }
                case NONE: {
                    this.checkBoxIcon.setIcon(this.uncheck);
                    break;
                }
                case SELECTED: {
                    this.checkBoxIcon.setIcon(this.check);
                    break;
                }
            }
            this.innerRenderer.getTreeCellRendererComponent(jTree, object, bl, bl2, bl3, n, bl4);
            this.revalidate();
            return this;
        }
    }

    private class MouseHandler
    implements MouseListener {
        private MouseHandler() {
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            TreePath treePath = ProjectExportView.this.fileTree.getPathForLocation(mouseEvent.getX(), mouseEvent.getY());
            if (treePath == null) {
                return;
            }
            Rectangle rectangle = ProjectExportView.this.fileTree.getPathBounds(treePath);
            if (mouseEvent.getX() - rectangle.x < 16) {
                Object object;
                mouseEvent.consume();
                ArrayList<SelectableFileNode> arrayList = new ArrayList<SelectableFileNode>();
                SelectableFileNode selectableFileNode = (SelectableFileNode)treePath.getLastPathComponent();
                if (ProjectExportView.this.fileTree.isPathSelected(treePath)) {
                    object = ProjectExportView.this.fileTree.getSelectionPaths();
                    if (TreeUtils.isSiblings(object)) {
                        for (TreePath treePath2 : object) {
                            arrayList.add((SelectableFileNode)treePath2.getLastPathComponent());
                        }
                    } else {
                        arrayList.add(selectableFileNode);
                        ProjectExportView.this.fileTree.setSelectionPath(treePath);
                    }
                } else {
                    arrayList.add(selectableFileNode);
                    ProjectExportView.this.fileTree.setSelectionPath(treePath);
                }
                Object object2 = object = ((SelectableFileNode)arrayList.get(0)).getSelection() == SelectableFileNode.Selection.NONE ? SelectableFileNode.Selection.SELECTED : SelectableFileNode.Selection.NONE;
                if (object == SelectableFileNode.Selection.SELECTED && arrayList.size() > 1) {
                    for (int i = 1; i < arrayList.size(); ++i) {
                        if (((SelectableFileNode)arrayList.get(i)).getSelection() == SelectableFileNode.Selection.NONE) continue;
                        object = SelectableFileNode.Selection.NONE;
                        break;
                    }
                }
                Object object3 = arrayList.iterator();
                while (object3.hasNext()) {
                    SelectableFileNode selectableFileNode2 = (SelectableFileNode)object3.next();
                    this.setSelection(selectableFileNode2, (SelectableFileNode.Selection)((Object)object));
                    ProjectExportView.this.getModel().nodeChanged(selectableFileNode2);
                }
                for (object3 = selectableFileNode.getParent(); object3 != null; object3 = ((SelectableFileNode)object3).getParent()) {
                    ((SelectableFileNode)object3).refreshSelection();
                    ProjectExportView.this.getModel().nodeChanged((TreeNode)object3);
                }
            }
        }

        private void setSelection(SelectableFileNode selectableFileNode, SelectableFileNode.Selection selection) {
            selectableFileNode.setSelection(selection);
            if (selectableFileNode.hasChildren()) {
                int[] nArray = new int[selectableFileNode.getChildCount()];
                for (int i = 0; i < selectableFileNode.getChildCount(); ++i) {
                    nArray[i] = i;
                    this.setSelection((SelectableFileNode)selectableFileNode.getChildAt(i), selection);
                }
                ProjectExportView.this.getModel().nodesChanged(selectableFileNode, nArray);
            }
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
        }
    }

    private class RefreshWorker
    extends SwingWorker<List<FileNode>, Void> {
        private TreePath path;

        public RefreshWorker(TreePath treePath) {
            this.path = treePath;
        }

        private TreePath getTreePath(TreePath treePath) {
            FileNode fileNode = (FileNode)ProjectExportView.this.fileTree.getModel().getRoot();
            if (!fileNode.equals(treePath.getPathComponent(0))) {
                return null;
            }
            for (int i = 1; i < treePath.getPathCount(); ++i) {
                FileNode fileNode2 = (FileNode)treePath.getPathComponent(i);
                int n = 0;
                Enumeration<? extends TreeNode> enumeration = fileNode.children();
                while (enumeration.hasMoreElements() && !fileNode2.equals(enumeration.nextElement())) {
                    ++n;
                }
                if (n >= fileNode.getChildCount()) {
                    return null;
                }
                fileNode = (FileNode)fileNode.getChildAt(n);
            }
            return TreeUtils.getPath(fileNode);
        }

        @Override
        protected List<FileNode> doInBackground() throws Exception {
            this.path = this.getTreePath(this.path);
            if (this.path != null) {
                return ((FileNode)this.path.getLastPathComponent()).retrieveChildren();
            }
            return null;
        }

        @Override
        protected void done() {
            if (this.path == null) {
                return;
            }
            FileNode fileNode = (FileNode)this.path.getLastPathComponent();
            try {
                List list = (List)this.get();
                fileNode.setChildren(list);
                ProjectExportView.this.getModel().nodeStructureChanged(fileNode);
                ProjectExportView.this.fileTree.removeTreeWillExpandListener(ProjectExportView.this);
                try {
                    ProjectExportView.this.fileTree.expandPath(this.path);
                }
                finally {
                    ProjectExportView.this.fileTree.addTreeWillExpandListener(ProjectExportView.this);
                }
            }
            catch (InterruptedException | ExecutionException exception) {
                LOGGER.log(Level.SEVERE, "Failed to refresh file tree", exception);
            }
        }
    }

    private class ExportWorker
    extends SwingWorker<Void, String> {
        private ExportWorker() {
        }

        @Override
        protected Void doInBackground() throws Exception {
            File file = WorkingDirectory.toAbsolutePath(new File(ProjectExportView.this.options.getValue(OUTPUT_FILE)));
            final boolean bl = ProjectExportView.this.options.getValue(FLOW_FILES);
            SelectableFileNode selectableFileNode = (SelectableFileNode)ProjectExportView.this.getModel().getRoot();
            Predicate<SelectableFileNode> predicate = new Predicate<SelectableFileNode>(){
                private File logDir;
                private File dbDir;
                {
                    this.logDir = ProjectExportView.this.project.getLogDir();
                    this.dbDir = new File(ProjectExportView.this.project.getAppDir(), "db");
                }

                @Override
                public boolean test(SelectableFileNode selectableFileNode) {
                    if (!selectableFileNode.isDirectory()) {
                        return true;
                    }
                    String string = selectableFileNode.getFile().getName();
                    if (!bl && string.equals(".raf")) {
                        return false;
                    }
                    if (selectableFileNode.getFile().equals(this.logDir)) {
                        return false;
                    }
                    return !selectableFileNode.getFile().equals(this.dbDir);
                }
            };
            try (ZipOutputStream zipOutputStream = new ZipOutputStream(new BufferedOutputStream(new FileOutputStream(file)));){
                byte[] byArray = new byte[4096];
                ArrayDeque<SelectableFileNode> arrayDeque = new ArrayDeque<SelectableFileNode>();
                arrayDeque.addLast(selectableFileNode);
                while (!arrayDeque.isEmpty()) {
                    int n;
                    Object object;
                    SelectableFileNode selectableFileNode2 = (SelectableFileNode)arrayDeque.removeLast();
                    if (selectableFileNode2.getSelection() == SelectableFileNode.Selection.NONE || !predicate.test(selectableFileNode2)) continue;
                    Object object2 = FileUtility.makeAbstractPath(selectableFileNode.getFile().getParentFile(), selectableFileNode2.getFile()).getPath();
                    object2 = FilenameUtils.separatorsToUnix((String)object2);
                    if (selectableFileNode2.isDirectory()) {
                        object2 = (String)object2 + "/";
                    }
                    this.publish(Messages.getString("Message.exporting") + ": " + (String)object2);
                    ZipEntry zipEntry = new ZipEntry((String)object2);
                    zipOutputStream.putNextEntry(zipEntry);
                    if (!selectableFileNode2.isDirectory()) {
                        object = new BufferedInputStream(new FileInputStream(selectableFileNode2.getFile()));
                        try {
                            n = 0;
                            while ((n = ((InputStream)object).read(byArray)) > 0) {
                                zipOutputStream.write(byArray, 0, n);
                                if (!Thread.interrupted()) continue;
                                zipOutputStream.closeEntry();
                                Void void_ = null;
                                return void_;
                            }
                        }
                        finally {
                            ((InputStream)object).close();
                        }
                    }
                    zipOutputStream.closeEntry();
                    if (!selectableFileNode2.isDirectory()) continue;
                    if (!selectableFileNode2.hasChildren()) {
                        selectableFileNode2.retrieveChildren();
                    }
                    object = selectableFileNode2.getAllChildren();
                    for (n = object.size() - 1; n >= 0; --n) {
                        arrayDeque.addLast((SelectableFileNode)object.get(n));
                    }
                }
            }
            return null;
        }

        @Override
        protected void process(List<String> list) {
            this.firePropertyChange("message", "", list.get(list.size() - 1));
        }
    }

    private class FileTreeRenderer
    extends BasicTreeCellRenderer {
        private JFileChooser chooser = new JFileChooser();
        private LinkedHashMap<Icon, Icon> hiddenIconCache = new LinkedHashMap();
        private static final int HIDDEN_ICON_CACHE_SIZE = 10;

        private FileTreeRenderer() {
        }

        @Override
        public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
            TreePath treePath = jTree.getPathForRow(n);
            if (treePath != null && treePath.getLastPathComponent() != object) {
                String string = jTree.convertValueToText(object, bl, bl2, bl3, n, bl4);
                this.setText(string);
                return this;
            }
            super.getTreeCellRendererComponent(jTree, object, bl, bl2, bl3, n, bl4);
            FileNode fileNode = (FileNode)object;
            File file = fileNode.getFile();
            Icon icon = fileNode.getIcon();
            if (icon == null && file != null) {
                try {
                    icon = this.chooser.getIcon(file);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (file != null && fileNode.isHidden()) {
                Icon icon2 = this.hiddenIconCache.get(icon);
                if (icon2 == null) {
                    if (icon == null) {
                        icon = this.getIcon();
                    }
                    if (icon != null) {
                        icon2 = new AlphaIcon(icon, 0.5f);
                        this.hiddenIconCache.put(icon, icon2);
                        while (this.hiddenIconCache.size() > 10) {
                            Iterator<Map.Entry<Icon, Icon>> iterator = this.hiddenIconCache.entrySet().iterator();
                            iterator.next();
                            iterator.remove();
                        }
                    }
                }
                if (icon2 != null) {
                    icon = icon2;
                }
            }
            if (!fileNode.isFileValid()) {
                if (icon == null) {
                    icon = this.getIcon();
                }
                if (icon != null) {
                    icon = Icons.getOverlaidIcon(icon, "16/cross.png");
                }
            } else if (fileNode.isLinkEntry()) {
                if (icon == null) {
                    icon = this.getIcon();
                }
                if (icon != null) {
                    icon = Icons.getOverlaidIcon(icon, "16/link.png", 10);
                }
            }
            if (icon != null) {
                this.setIcon(icon);
            }
            return this;
        }
    }
}

