/*
 * Decompiled with CFR 0.152.
 */
package com.ef_prime.rflow.ui.base;

import com.ef_prime.rflow.Rflow;
import com.ef_prime.rflow.core.app.file.FileInfo;
import com.ef_prime.rflow.core.app.file.FileInfos;
import com.ef_prime.rflow.core.app.file.FileUtility;
import com.ef_prime.rflow.core.app.file.ZipFileUtility;
import com.ef_prime.rflow.core.app.file.ZipInfo;
import com.ef_prime.rflow.core.base.Project;
import com.ef_prime.rflow.core.base.UserFolder;
import com.ef_prime.rflow.core.base.WorkingDirectory;
import com.ef_prime.rflow.core.common.keyvalue.FileKey;
import com.ef_prime.rflow.core.common.keyvalue.Key;
import com.ef_prime.rflow.core.common.keyvalue.PanelWidgetNode;
import com.ef_prime.rflow.core.common.keyvalue.ValueChangeEvent;
import com.ef_prime.rflow.core.common.keyvalue.ValueChangeEventHandler;
import com.ef_prime.rflow.core.common.keyvalue.ViewOptions;
import com.ef_prime.rflow.core.common.keyvalue.WidgetNode;
import com.ef_prime.rflow.core.util.YamlEx;
import com.ef_prime.rflow.resource.Messages;
import com.ef_prime.rflow.ui.base.Icons;
import com.ef_prime.rflow.ui.base.ProjectWizard;
import com.ef_prime.rflow.ui.util.UIUtility;
import java.awt.Component;
import java.awt.Cursor;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.zip.ZipException;
import javax.swing.Icon;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipFile;
import org.apache.commons.io.FileUtils;

public class ProjectImportView
extends ProjectWizard {
    @Override
    protected ProjectWizard.ProjectSettings createViewModel() {
        return new ImportProject();
    }

    @Override
    protected String getFinishButtonTitle() {
        return Messages.getString("Action.import");
    }

    @Override
    protected Icon getFinishButtonIcon() {
        return Icons.getIcon("16/go.png");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean viewWillClose(int n) {
        if (n == 1) {
            Cursor cursor = this.getCursor();
            this.setCursor(Cursor.getPredefinedCursor(3));
            try {
                this.importProject();
                boolean bl = true;
                return bl;
            }
            catch (Exception exception) {
                UIUtility.showErrorDialog((Component)this, exception);
                boolean bl = false;
                return bl;
            }
            finally {
                this.setCursor(cursor);
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void importProject() throws IOException, ZipException {
        String[] stringArray;
        ImportProject importProject = (ImportProject)this.projectName;
        File file = importProject.getLocation();
        if (file.exists()) {
            if (file.isFile()) {
                throw new IOException("Destination path is a file.");
            }
            stringArray = file.list();
            if (stringArray != null && stringArray.length > 0) {
                throw new IOException("Destination path is not empty.");
            }
        }
        stringArray = FileUtility.createTempDir(UserFolder.getTempDir());
        try {
            Object object;
            File file2 = importProject.getImportFile();
            if (!file2.exists()) {
                throw new IOException("The import file doen't exist.");
            }
            try (File[] fileArray = ZipInfo.get(file2).createZipFile();){
                ZipFileUtility.extract((ZipFile)fileArray, stringArray.toPath());
            }
            fileArray = stringArray.listFiles();
            if (fileArray == null || fileArray.length == 0) {
                throw new IOException("The import file is empty.");
            }
            File file3 = null;
            for (int i = 0; i < fileArray.length; ++i) {
                if (!fileArray[i].isDirectory()) continue;
                file3 = fileArray[i];
                break;
            }
            if (file3 == null) {
                throw new IOException("The import file doesn't contain top directory");
            }
            Project project = importProject.createProject();
            if (project.getLocation().exists()) {
                object = file3.listFiles();
                if (object != null) {
                    for (File file4 : object) {
                        FileUtils.moveToDirectory((File)file4, (File)project.getLocation(), (boolean)false);
                    }
                }
            } else {
                FileUtils.moveDirectory((File)file3, (File)project.getLocation());
            }
            object = project.getName();
            Rflow.getInstance().loadProject(project, true, null);
            project.putValue(Project.KEY_NAME, object);
            project.saveProjectFile();
            this.addProjectBookmark(project);
            this.succeeded = true;
        }
        finally {
            FileUtils.deleteQuietly((File)stringArray);
        }
    }

    private static class ImportProject
    extends ProjectWizard.ProjectSettings
    implements ValueChangeEventHandler {
        private static final FileKey IMPORT_FILE = ((FileKey.Builder)((FileKey.Builder)((FileKey.Builder)FileKey.builder("import_file", Messages.getString("Message.file")).setRequired(true)).setDefaultDirectory(":user_documents")).setAbstractPathEnabled(false)).build();
        protected static final FileKey IMPORT_TO = ((FileKey.Builder)((FileKey.Builder)((FileKey.Builder)((FileKey.Builder)((Key.Builder)FileKey.builder("project_location", Messages.getString("Message.import_to")).setMode(1)).setDynamicDefault(true)).setFillDefaultOnFocus(true)).setDefaultDirectory(":projects_home")).setAbstractPathEnabled(false)).build();

        public ImportProject() {
            this.registerKeys(IMPORT_FILE);
            this.registerKeys(true, IMPORT_TO);
            this.addEventHandler(this);
        }

        public File getImportFile() {
            return WorkingDirectory.toAbsolutePath(new File(this.getValue(IMPORT_FILE)));
        }

        @Override
        public boolean isReady() {
            return super.isReady() && !this.isStringEmpty(IMPORT_FILE);
        }

        @Override
        public WidgetNode getWidgetNode(ViewOptions viewOptions) {
            return new PanelWidgetNode().addElements(IMPORT_FILE, PROJECT_NAME, IMPORT_TO, ADD_TO_BOOKMARK, PanelWidgetNode.indent().addElements(BOOKMARK_NAME, this.location));
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public void valueChanged(ValueChangeEvent valueChangeEvent) {
            if (valueChangeEvent.getKey() != IMPORT_FILE) return;
            try {
                File file = this.getImportFile();
                if (!file.exists()) {
                    return;
                }
                FileInfo fileInfo = FileInfos.getInstance().getFileInfo(file);
                if (!fileInfo.isZip()) {
                    return;
                }
                try (ZipFile zipFile = ZipInfo.get(file).createZipFile();){
                    String string = "/" + Project.projectFilePath();
                    Enumeration enumeration = zipFile.getEntries();
                    while (enumeration.hasMoreElements()) {
                        ZipArchiveEntry zipArchiveEntry = (ZipArchiveEntry)enumeration.nextElement();
                        String string2 = ZipFileUtility.path(zipArchiveEntry.getName());
                        if (!string2.endsWith(string) || string2.indexOf(47) != string2.length() - string.length()) continue;
                        InputStream inputStream = zipFile.getInputStream(zipArchiveEntry);
                        try {
                            Object object = new YamlEx().load(inputStream);
                            Project project = Project.createProject(new File(""));
                            project.loadYamlValue(new YamlEx(), object);
                            String string3 = project.getName();
                            if (string3.isEmpty()) return;
                            this.putValue(PROJECT_NAME, string3);
                            return;
                        }
                        finally {
                            if (inputStream != null) {
                                inputStream.close();
                            }
                            return;
                        }
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

