/*
 * Decompiled with CFR 0.152.
 */
package com.ef_prime.rflow.ui.base;

import com.ef_prime.rflow.Rflow;
import com.ef_prime.rflow.RflowActions;
import com.ef_prime.rflow.core.app.file.FileInfo;
import com.ef_prime.rflow.core.app.file.FileInfos;
import com.ef_prime.rflow.core.app.file.FileUtility;
import com.ef_prime.rflow.core.base.Project;
import com.ef_prime.rflow.core.base.ProjectsManager;
import com.ef_prime.rflow.core.base.UserProjectFolderManager;
import com.ef_prime.rflow.core.base.WorkingDirectory;
import com.ef_prime.rflow.core.common.keyvalue.ChoiceKey;
import com.ef_prime.rflow.core.common.keyvalue.FileKey;
import com.ef_prime.rflow.core.common.keyvalue.Key;
import com.ef_prime.rflow.core.common.keyvalue.StrKey;
import com.ef_prime.rflow.core.common.keyvalue.ValueChangeEvent;
import com.ef_prime.rflow.core.common.keyvalue.ValueChangeEventHandler;
import com.ef_prime.rflow.core.common.keyvalue.ValueMap;
import com.ef_prime.rflow.core.common.tree.TreeUtility;
import com.ef_prime.rflow.resource.Messages;
import com.ef_prime.rflow.ui.app.file.FileUIUtility;
import com.ef_prime.rflow.ui.base.FileProjectNode;
import com.ef_prime.rflow.ui.base.FolderProjectNode;
import com.ef_prime.rflow.ui.base.Icons;
import com.ef_prime.rflow.ui.base.ProjectNode;
import com.ef_prime.rflow.ui.common.component.Actions;
import com.ef_prime.rflow.ui.common.component.LoggableAction;
import com.ef_prime.rflow.ui.common.component.OptionPane;
import com.ef_prime.rflow.ui.common.component.RflowTree;
import com.ef_prime.rflow.ui.common.component.SimpleTransferable;
import com.ef_prime.rflow.ui.common.component.TreeIterator;
import com.ef_prime.rflow.ui.common.keyvalue.WidgetFactory;
import com.ef_prime.rflow.ui.common.tree.BasicTreeCellRenderer;
import com.ef_prime.rflow.ui.common.tree.MutableTreeNodeFlavor;
import com.ef_prime.rflow.ui.util.PlatformUtility;
import com.ef_prime.rflow.ui.util.TreeUtils;
import com.ef_prime.rflow.ui.util.UIUtility;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.DropMode;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.SwingWorker;
import javax.swing.TransferHandler;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.ExpandVetoException;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import net.miginfocom.layout.CC;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.ArrayUtils;

public class ProjectTree
extends RflowTree {
    public static final String ACTION_OPEN_PROJECT = "ACTION_OPEN_PROJECT";
    public static final String ACTION_ADD = "ACTION_ADD";
    public static final String ACTION_REMOVE = "ACTION_REMOVE";
    private ProjectActions actions = new ProjectActions();
    private ProjectsManager projectsManager;

    public ProjectTree(ProjectsManager projectsManager) {
        this(projectsManager, new DefaultTreeModel(new FolderProjectNode("")));
    }

    public ProjectTree(ProjectsManager projectsManager, DefaultTreeModel defaultTreeModel) {
        super(defaultTreeModel);
        this.projectsManager = projectsManager;
        this.setToggleClickCount(3);
        this.setEditable(false);
        this.setRootVisible(true);
        this.setShowsRootHandles(false);
        this.setCellRenderer(new ProjectRenderer());
        this.addMouseListener(new MouseHandler());
        this.addTreeWillExpandListener(new ProjectTreeWillExpandListener());
        this.setDragEnabled(true);
        this.setTransferHandler(new ProjectTransferHandler());
        this.setDropMode(DropMode.ON_OR_INSERT);
        this.actions.refreshActionState();
    }

    @Override
    public DefaultTreeModel getModel() {
        return (DefaultTreeModel)super.getModel();
    }

    @Override
    public void setModel(TreeModel treeModel) {
        super.setModel(treeModel);
        this.refresh(new TreePath(new Object[]{this.getModel().getRoot()}));
    }

    public Action getAction(Object object) {
        return this.actions.get(object);
    }

    private ProjectNode getSelectedNode() {
        if (this.isSelectionEmpty()) {
            return (ProjectNode)this.getModel().getRoot();
        }
        if (this.getSelectionCount() != 1) {
            return null;
        }
        TreePath treePath = this.getSelectionPath();
        return (ProjectNode)treePath.getLastPathComponent();
    }

    private List<ProjectNode> getLastComponents(TreePath[] treePathArray) {
        ArrayList<ProjectNode> arrayList = new ArrayList<ProjectNode>();
        for (int i = 0; i < treePathArray.length; ++i) {
            if (treePathArray[i].getPathCount() <= 1) continue;
            arrayList.add((ProjectNode)treePathArray[i].getLastPathComponent());
        }
        return arrayList;
    }

    private void refresh(TreePath treePath) {
        final ProjectNode projectNode = (ProjectNode)treePath.getLastPathComponent();
        SwingWorker<Void, Void> swingWorker = new SwingWorker<Void, Void>(){

            @Override
            protected Void doInBackground() throws Exception {
                projectNode.refreshChildrenWork();
                return null;
            }

            @Override
            protected void done() {
                projectNode.refreshChildrenDone();
                ProjectTree.this.getModel().nodeStructureChanged(projectNode);
            }
        };
        swingWorker.execute();
    }

    @Override
    public boolean isPathEditable(TreePath treePath) {
        ProjectNode projectNode = (ProjectNode)treePath.getLastPathComponent();
        return !projectNode.isFile() || projectNode.isRoot() || !projectNode.getParent().isFile();
    }

    public boolean openSelectedProject() {
        Serializable serializable;
        ProjectNode projectNode = this.getSelectedNode();
        if (projectNode == null || !projectNode.isFile()) {
            return false;
        }
        File file = projectNode.getFile();
        FileInfo fileInfo = FileInfos.getInstance().getFileInfo(file);
        RflowActions rflowActions = Rflow.getInstance().getActions();
        boolean bl = true;
        if (fileInfo.isRflow()) {
            serializable = projectNode.getParent();
            if (!((ProjectNode)serializable).isProject()) {
                return false;
            }
            File file2 = ((ProjectNode)serializable).getFile();
            if (!Rflow.project().getLocation().equals(file2)) {
                bl = rflowActions.openProject(file2, true);
            }
            if (Rflow.project().getLocation().equals(file2)) {
                rflowActions.openFlow(file, false);
            }
        } else if (projectNode.isProject()) {
            bl = !Project.isNewProject(file) ? rflowActions.openProject(file, true) : false;
        }
        serializable = this;
        for (int i = ((JTree)serializable).getRowCount() - 1; i >= 0; --i) {
            ((JTree)serializable).collapseRow(i);
        }
        TreePath treePath = TreeUtils.getPath(projectNode, null);
        ((JTree)serializable).expandPath(treePath);
        ((JTree)serializable).setSelectionPath(treePath);
        return bl;
    }

    public void addBookmark(String string) {
        Object object;
        ProjectNode projectNode = this.actions.getNodeForAdd();
        ProjectNode projectNode2 = (ProjectNode)this.getModel().getRoot();
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<ProjectNode> arrayList2 = new ArrayList<ProjectNode>();
        String string2 = null;
        arrayList.add("0");
        arrayList.add(Messages.getString("View.Bookmark.default_location"));
        arrayList2.add(projectNode2);
        if (projectNode2 == projectNode) {
            string2 = "0";
        }
        for (int i = 0; i < projectNode2.getChildCount(); ++i) {
            object = projectNode2.getChildAt(i);
            if (!(object instanceof FolderProjectNode)) continue;
            if (object == projectNode) {
                string2 = Integer.toString(arrayList2.size());
            }
            arrayList.add(Integer.toString(arrayList2.size()));
            arrayList.add(((FolderProjectNode)object).getName());
            arrayList2.add((ProjectNode)object);
        }
        NewBookmark newBookmark = new NewBookmark(arrayList, string2);
        if (string != null) {
            newBookmark.setProjectFolder(string);
        }
        object = WidgetFactory.getInstance().create(newBookmark);
        int n = OptionPane.showOkCancelDialog(Rflow.mainFrame(), (Component)object, Messages.getString("View.Bookmark.title"), null);
        if (n != 0) {
            return;
        }
        ProjectNode projectNode3 = (ProjectNode)arrayList2.get(Integer.valueOf(newBookmark.getLocation()));
        FileProjectNode fileProjectNode = newBookmark.getProjectNode();
        if (fileProjectNode.getFile().getPath().isEmpty()) {
            return;
        }
        this.projectsManager.addNode(fileProjectNode, projectNode3);
        TreePath treePath = new TreePath(fileProjectNode.getPath());
        this.setSelectionPath(treePath);
        this.scrollPathToVisible(treePath);
    }

    protected boolean isFlowActionEnabled() {
        return true;
    }

    protected JPopupMenu createPopup() {
        JPopupMenu jPopupMenu = new JPopupMenu();
        jPopupMenu.add(this.actions.get(ACTION_OPEN_PROJECT));
        jPopupMenu.add(this.actions.get(ProjectActions.NewFolder.class));
        jPopupMenu.add(this.actions.get(ACTION_ADD));
        jPopupMenu.add(this.actions.get(ProjectActions.Rename.class));
        jPopupMenu.addSeparator();
        jPopupMenu.add(this.actions.get(ProjectActions.NewFlow.class));
        jPopupMenu.addSeparator();
        jPopupMenu.add(this.actions.get(ACTION_REMOVE));
        jPopupMenu.addSeparator();
        jPopupMenu.add(this.actions.get(ProjectActions.BookmarkProperties.class));
        jPopupMenu.addSeparator();
        jPopupMenu.add(this.actions.get(ProjectActions.Refresh.class));
        UIUtility.cleanUpPopupMenu(jPopupMenu);
        return jPopupMenu;
    }

    private class ProjectActions
    extends Actions
    implements TreeSelectionListener {
        public ProjectActions() {
            this.put(ProjectTree.ACTION_OPEN_PROJECT, new OpenProject());
            this.put(new NewFolder());
            this.put(ProjectTree.ACTION_ADD, new Add());
            this.put(ProjectTree.ACTION_REMOVE, new Remove());
            this.put(new Rename());
            this.put(new Refresh());
            this.put(new NewFlow());
            this.put(new BookmarkProperties());
            ProjectTree.this.addTreeSelectionListener(this);
            this.installActions(ProjectTree.this, false, 1);
            this.installAcceleratorKeys(ProjectTree.this, 0, Rename.class);
            this.get(ProjectTree.ACTION_REMOVE).setEnabled(false);
            this.get(ProjectTree.ACTION_OPEN_PROJECT).setEnabled(false);
        }

        private ProjectNode getNodeForAdd() {
            ProjectNode projectNode = ProjectTree.this.getSelectedNode();
            if (projectNode == null) {
                return null;
            }
            if (projectNode.isFile() && ((projectNode = projectNode.getParent()) == null || projectNode.isFile())) {
                return null;
            }
            return projectNode;
        }

        public void refreshActionState() {
            ProjectTree projectTree = ProjectTree.this;
            boolean bl = projectTree.isSelectionEmpty() || TreeUtility.isSiblings(ProjectTree.this.getSelectionPaths());
            for (Object object : this.keys()) {
                this.get(object).setEnabled(bl);
            }
            if (!ProjectTree.this.isFlowActionEnabled()) {
                this.get(NewFlow.class).setEnabled(false);
            }
            boolean bl2 = projectTree.getSelectionCount() == 1;
            ProjectNode projectNode = null;
            int n = 0;
            if (bl2 && (projectNode = (ProjectNode)projectTree.getSelectionPath().getLastPathComponent()).isFile()) {
                Object object;
                object = FileInfos.getInstance().getFileInfo(projectNode.getFile());
                n = ((FileInfo)object).isRflow() ? 1 : 0;
            }
            boolean bl3 = bl2 && projectNode.isProject();
            boolean bl4 = bl2 && projectNode.isRoot();
            boolean bl5 = this.getNodeForAdd() != null;
            this.get(ProjectTree.ACTION_OPEN_PROJECT).setEnabled(bl3 || n != 0);
            this.get(BookmarkProperties.class).setEnabled(bl3);
            this.get(NewFolder.class).setEnabled(bl5);
            this.get(ProjectTree.ACTION_ADD).setEnabled(bl5);
            this.get(ProjectTree.ACTION_REMOVE).setEnabled(!projectTree.isSelectionEmpty() && bl && !bl4);
        }

        @Override
        public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
            this.refreshActionState();
        }

        private class OpenProject
        extends LoggableAction {
            public OpenProject() {
                this.putValue("Name", Messages.getString("Action.open"));
            }

            @Override
            public void action(ActionEvent actionEvent) {
                ProjectTree.this.openSelectedProject();
            }
        }

        private class NewFolder
        extends LoggableAction {
            public NewFolder() {
                this.putValue("Name", Messages.getString("Action.new_folder"));
            }

            @Override
            public void action(ActionEvent actionEvent) {
                ProjectNode projectNode = ProjectActions.this.getNodeForAdd();
                if (projectNode == null) {
                    return;
                }
                FolderProjectNode folderProjectNode = new FolderProjectNode((String)this.getValue("Name"));
                ProjectTree.this.projectsManager.addNode(folderProjectNode, projectNode);
            }
        }

        private class Add
        extends LoggableAction {
            public Add() {
                this.putValue("Name", Messages.getStringWithDots("Action.add"));
                this.putValue("SmallIcon", Icons.getIcon("16/add.png"));
                this.putValue("ShortDescription", this.getValue("Name"));
            }

            @Override
            public void action(ActionEvent actionEvent) {
                String string = null;
                if (!Rflow.project().isNewProject()) {
                    string = Rflow.project().getLocation().getAbsolutePath();
                }
                ProjectTree.this.addBookmark(string);
            }
        }

        private class Remove
        extends LoggableAction
        implements HyperlinkListener {
            public Remove() {
                this.putValue("Name", Messages.getString("Action.remove"));
                this.putValue("AcceleratorKey", PlatformUtility.getDeleteKeyStroke());
                this.putValue("SmallIcon", Icons.getIcon("16/delete.png"));
                this.putValue("ShortDescription", this.getValue("Name"));
            }

            @Override
            public void action(ActionEvent actionEvent) {
                Object object;
                Serializable serializable;
                Object object2;
                ProjectTree projectTree = ProjectTree.this;
                TreePath[] treePathArray = projectTree.getSelectionPaths();
                List<ProjectNode> list = ProjectTree.this.getLastComponents(treePathArray);
                if (list.isEmpty()) {
                    return;
                }
                ArrayList<ProjectNode> arrayList = new ArrayList<ProjectNode>();
                for (ProjectNode object32 : list) {
                    object2 = new TreeIterator(object32);
                    while (((TreeIterator)object2).hasNext()) {
                        serializable = (ProjectNode)((TreeIterator)object2).next();
                        if (!((ProjectNode)serializable).isProject()) continue;
                        arrayList.add((ProjectNode)serializable);
                    }
                }
                Object object4 = list.size() == 1 ? "\"" + list.get(0).getName() + "\"" : Messages.format("StartPage.n_items", Integer.toString(list.size()));
                String string = Messages.format("StartPage.confirm_remove_project", object4);
                object2 = new JCheckBox(Messages.getString("StartPage.remove_project_data"));
                serializable = new StringBuilder();
                ((StringBuilder)serializable).append("<html><body>");
                for (ProjectNode projectNode : arrayList) {
                    if (!projectNode.isFile()) continue;
                    object = projectNode.getFile().getAbsolutePath();
                    ((StringBuilder)serializable).append("<a href=\"" + (String)object + "\">");
                    ((StringBuilder)serializable).append((String)object);
                    ((StringBuilder)serializable).append("</a><br>");
                }
                ((StringBuilder)serializable).append("</body></html>");
                JEditorPane jEditorPane = new JEditorPane();
                jEditorPane.setOpaque(false);
                jEditorPane.setContentType("text/html");
                jEditorPane.setEditable(false);
                jEditorPane.putClientProperty("JEditorPane.honorDisplayProperties", Boolean.TRUE);
                jEditorPane.setFont(new JLabel().getFont());
                jEditorPane.addHyperlinkListener(this);
                jEditorPane.setText(((StringBuilder)serializable).toString());
                JScrollPane jScrollPane = new JScrollPane(jEditorPane);
                jScrollPane.setHorizontalScrollBarPolicy(31);
                object = new JPanel((LayoutManager)new MigLayout());
                ((Container)object).add((Component)new JLabel(string), new CC().wrap());
                ((Container)object).add((Component)object2, new CC().gapTop("10").wrap());
                ((Container)object).add((Component)jScrollPane, new CC().width("500").height("70").growX().gapLeft("30").wrap());
                int n = JOptionPane.showConfirmDialog(Rflow.mainFrame(), object, Messages.getString("Message.confirm"), 0, 1);
                if (n != 0) {
                    return;
                }
                if (((AbstractButton)object2).isSelected() && (n = JOptionPane.showConfirmDialog(Rflow.mainFrame(), Messages.getString("Message.confirm_delete"), Messages.getString("Message.confirm"), 0, 2)) != 0) {
                    return;
                }
                ProjectTree.this.projectsManager.removeNode(list);
                for (ProjectNode projectNode : list) {
                    try {
                        ProjectTree.this.projectsManager.removeFlow(projectNode);
                    }
                    catch (Exception iOException) {
                        UIUtility.showErrorDialog((Component)Rflow.mainFrame(), Messages.getString("Error.file.delete") + ": " + String.valueOf(projectNode.getFile()), iOException);
                    }
                }
                if (((AbstractButton)object2).isSelected()) {
                    for (ProjectNode projectNode : arrayList) {
                        try {
                            FileUtility.removeFile(projectNode.getFile());
                            UserProjectFolderManager.getInstance().remove(projectNode.getFile());
                        }
                        catch (IOException iOException) {
                            UIUtility.showErrorDialog((Component)Rflow.mainFrame(), Messages.getString("Error.file.delete") + ": " + String.valueOf(projectNode.getFile()), iOException);
                        }
                    }
                }
            }

            @Override
            public void hyperlinkUpdate(HyperlinkEvent hyperlinkEvent) {
                if (hyperlinkEvent.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                    String string = hyperlinkEvent.getDescription();
                    FileUIUtility.openPath(string);
                }
            }
        }

        private class Rename
        extends LoggableAction {
            public Rename() {
                this.putValue("Name", Messages.getString("Action.rename"));
                this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(113, 0));
            }

            @Override
            public void action(ActionEvent actionEvent) {
                ProjectNode projectNode = ProjectTree.this.getSelectedNode();
                if (projectNode == null) {
                    return;
                }
                if (!projectNode.isFlowFile() && projectNode.isFile() && !projectNode.isRoot() && projectNode.getParent().isFile()) {
                    return;
                }
                String string = projectNode.isFlowFile() ? FilenameUtils.removeExtension((String)projectNode.getFile().getName()) : projectNode.getUserObject().toString();
                String string2 = UIUtility.showInputDialog(Rflow.mainFrame(), Messages.getString("Action.rename"), "", string);
                if (string2 == null) {
                    return;
                }
                try {
                    ProjectTree.this.projectsManager.rename(projectNode, string2);
                }
                catch (Exception exception) {
                    UIUtility.showErrorDialog((Component)Rflow.mainFrame(), exception);
                }
            }
        }

        private class Refresh
        extends LoggableAction {
            public Refresh() {
                this.putValue("Name", Messages.getString("Action.refresh_latest"));
                this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(116, 0));
            }

            @Override
            public void action(ActionEvent actionEvent) {
                ProjectTree projectTree = ProjectTree.this;
                Object[] objectArray = projectTree.getSelectionPaths();
                if (ArrayUtils.isEmpty((Object[])objectArray)) {
                    return;
                }
                for (int i = 0; i < objectArray.length; ++i) {
                    ProjectTree.this.refresh((TreePath)objectArray[i]);
                }
            }
        }

        private class NewFlow
        extends LoggableAction {
            public NewFlow() {
                this.putValue("Name", Messages.getString("Action.new_flow"));
            }

            @Override
            public void action(ActionEvent actionEvent) {
                Rflow.getInstance().loadEmptyFlow(false);
            }
        }

        private class BookmarkProperties
        extends LoggableAction {
            public BookmarkProperties() {
                this.putValue("Name", Messages.getStringWithDots("Action.bookmark_properties"));
            }

            @Override
            public void action(ActionEvent actionEvent) {
                ProjectNode projectNode = ProjectTree.this.getSelectedNode();
                if (projectNode == null || !projectNode.isProject()) {
                    return;
                }
                StrKey strKey = StrKey.builder("bname", Messages.getString("StartPage.bookmark_name")).build();
                StrKey strKey2 = ((StrKey.Builder)StrKey.builder("path", Messages.getString("StartPage.path")).setFixed(true)).build();
                ValueMap valueMap = new ValueMap();
                valueMap.putValueQuietly(strKey, projectNode.getUserObject().toString());
                valueMap.putValueQuietly(strKey2, projectNode.getFile().getAbsolutePath());
                Component component = WidgetFactory.getInstance().create(valueMap);
                int n = JOptionPane.showConfirmDialog(Rflow.mainFrame(), component, Messages.getString("Action.bookmark_properties"), 2, -1);
                if (n != 0) {
                    return;
                }
                try {
                    ProjectTree.this.projectsManager.rename(projectNode, valueMap.getValue(strKey));
                }
                catch (Exception exception) {
                    UIUtility.showErrorDialog((Component)Rflow.mainFrame(), exception);
                }
            }
        }
    }

    private static class ProjectRenderer
    extends BasicTreeCellRenderer {
        @Override
        public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
            super.getTreeCellRendererComponent(jTree, object, bl, bl2, bl3, n, bl4);
            ProjectNode projectNode = (ProjectNode)object;
            Icon icon = projectNode.getIcon();
            if (projectNode.isRoot()) {
                icon = Icons.getIcon("16/star.png");
            }
            if (icon == null) {
                icon = this.getIcon();
            }
            if (projectNode.isFile() && !projectNode.fileExists() && icon != null) {
                icon = Icons.getOverlaidIcon(icon, "16/cross.png");
            }
            this.setIcon(icon);
            return this;
        }
    }

    private class MouseHandler
    extends MouseAdapter {
        private MouseHandler() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            ProjectTree projectTree = (ProjectTree)mouseEvent.getSource();
            Point point = mouseEvent.getPoint();
            TreePath treePath = projectTree.getPathForLocation((int)point.getX(), (int)point.getY());
            if (UIUtility.isRightMouseButton(mouseEvent)) {
                JPopupMenu jPopupMenu;
                if (treePath != null && !projectTree.getSelectionModel().isPathSelected(treePath)) {
                    projectTree.setSelectionPath(treePath);
                }
                if ((jPopupMenu = ProjectTree.this.createPopup()).getComponentCount() > 0) {
                    jPopupMenu.show((Component)mouseEvent.getSource(), mouseEvent.getPoint().x, mouseEvent.getPoint().y);
                }
            } else if (UIUtility.isLeftMouseButton(mouseEvent) && treePath != null && mouseEvent.getClickCount() == 2) {
                Serializable serializable;
                projectTree.setSelectionPath(treePath);
                if (ProjectTree.this.actions.get(ProjectTree.ACTION_OPEN_PROJECT).isEnabled()) {
                    serializable = projectTree.getCursor();
                    projectTree.setCursor(Cursor.getPredefinedCursor(3));
                    try {
                        ProjectTree.this.openSelectedProject();
                    }
                    finally {
                        projectTree.setCursor((Cursor)serializable);
                    }
                }
                if ((serializable = ProjectTree.this.getSelectedNode()) != null && !((DefaultMutableTreeNode)serializable).isLeaf() && !((ProjectNode)serializable).isProject()) {
                    if (projectTree.isExpanded(treePath)) {
                        projectTree.collapsePath(treePath);
                    } else {
                        projectTree.expandPath(treePath);
                    }
                }
            }
        }
    }

    private class ProjectTreeWillExpandListener
    implements TreeWillExpandListener {
        private ProjectTreeWillExpandListener() {
        }

        @Override
        public void treeWillExpand(TreeExpansionEvent treeExpansionEvent) throws ExpandVetoException {
            ProjectTree projectTree = (ProjectTree)treeExpansionEvent.getSource();
            if (!projectTree.hasBeenExpanded(treeExpansionEvent.getPath())) {
                ProjectTree.this.refresh(treeExpansionEvent.getPath());
            }
        }

        @Override
        public void treeWillCollapse(TreeExpansionEvent treeExpansionEvent) throws ExpandVetoException {
        }
    }

    private class ProjectTransferHandler
    extends TransferHandler {
        private ProjectTransferHandler() {
        }

        @Override
        public int getSourceActions(JComponent jComponent) {
            return 3;
        }

        @Override
        protected Transferable createTransferable(JComponent jComponent) {
            ProjectTree projectTree = (ProjectTree)jComponent;
            TreePath[] treePathArray = projectTree.getSelectionPaths();
            List<ProjectNode> list = ProjectTree.this.getLastComponents(treePathArray);
            if (list.isEmpty()) {
                return null;
            }
            SimpleTransferable simpleTransferable = new SimpleTransferable((Object)list.toArray(new ProjectNode[0]), MutableTreeNodeFlavor.getInstance());
            return simpleTransferable;
        }

        @Override
        protected void exportDone(JComponent jComponent, Transferable transferable, int n) {
        }

        @Override
        public boolean canImport(TransferHandler.TransferSupport transferSupport) {
            if (!transferSupport.isDrop()) {
                return false;
            }
            if (!transferSupport.isDataFlavorSupported(MutableTreeNodeFlavor.getInstance())) {
                return false;
            }
            JTree.DropLocation dropLocation = (JTree.DropLocation)transferSupport.getDropLocation();
            TreePath treePath = dropLocation.getPath();
            ProjectNode projectNode = (ProjectNode)treePath.getLastPathComponent();
            if (projectNode.isFile()) {
                return false;
            }
            ProjectNode[] projectNodeArray = null;
            try {
                projectNodeArray = (ProjectNode[])transferSupport.getTransferable().getTransferData(MutableTreeNodeFlavor.getInstance());
            }
            catch (Exception exception) {
                return false;
            }
            for (ProjectNode projectNode2 : projectNodeArray) {
                if (projectNode2.isNodeDescendant(projectNode)) {
                    return false;
                }
                if (!projectNode2.isFile() || !projectNode2.getParent().isFile()) continue;
                transferSupport.setDropAction(1);
            }
            return true;
        }

        @Override
        public boolean importData(TransferHandler.TransferSupport transferSupport) {
            if (!this.canImport(transferSupport)) {
                return false;
            }
            ProjectNode[] projectNodeArray = null;
            try {
                projectNodeArray = (ProjectNode[])transferSupport.getTransferable().getTransferData(MutableTreeNodeFlavor.getInstance());
            }
            catch (Exception exception) {
                return false;
            }
            JTree.DropLocation dropLocation = (JTree.DropLocation)transferSupport.getDropLocation();
            TreePath treePath = dropLocation.getPath();
            ProjectNode projectNode = (ProjectNode)treePath.getLastPathComponent();
            int n = dropLocation.getChildIndex();
            if (n == -1) {
                n = projectNode.getChildCount();
            }
            for (int i = projectNodeArray.length - 1; i >= 0; --i) {
                ProjectTree.this.getModel().insertNodeInto(projectNodeArray[i].copy(), projectNode, n);
                if (transferSupport.getDropAction() != 2) continue;
                ProjectTree.this.getModel().removeNodeFromParent(projectNodeArray[i]);
            }
            transferSupport.getComponent().repaint();
            ProjectTree.this.projectsManager.projectNodeMoved();
            return true;
        }
    }

    private static class NewBookmark
    extends ValueMap
    implements ValueChangeEventHandler {
        private FileKey projectFolder = ((FileKey.Builder)((FileKey.Builder)((FileKey.Builder)FileKey.builder("project", Messages.getString("View.Bookmark.project_folder")).setMode(1)).setAbstractPathEnabled(false)).setDefaultDirectory(":projects_home")).build();
        private StrKey name = ((StrKey.Builder)StrKey.builder("bookmark_name", Messages.getString("View.Bookmark.bookmark_name")).setDynamicDefault(true)).build();
        private ChoiceKey location;
        private Project project;

        public NewBookmark(List<String> list, String string) {
            this.location = ((ChoiceKey.Builder)ChoiceKey.builder("location", Messages.getString("View.Bookmark.location")).setValuesAndLabels(list.toArray(new String[list.size()]))).build();
            this.registerKeys(this.projectFolder, this.name, this.location);
            if (string != null) {
                this.putValue(this.location, string);
            }
            this.addEventHandler(this);
        }

        public void setProjectFolder(String string) {
            this.putValue(this.projectFolder, string);
        }

        public FileProjectNode getProjectNode() {
            FileProjectNode fileProjectNode = new FileProjectNode(WorkingDirectory.toAbsolutePath(new File(this.getValue(this.projectFolder))));
            fileProjectNode.setName(this.getValueOrDefault(this.name));
            return fileProjectNode;
        }

        public String getLocation() {
            return this.getValue(this.location);
        }

        @Override
        public Object getDynamicDefaultValue(Key<?> key) {
            if (key == this.name) {
                String string;
                if (this.project != null && !(string = this.project.getName()).isEmpty()) {
                    return string;
                }
                return FilenameUtils.getName((String)this.getValue(this.projectFolder));
            }
            return super.getDynamicDefaultValue(key);
        }

        @Override
        public void valueChanged(ValueChangeEvent valueChangeEvent) {
            if (valueChangeEvent.getKey() == this.projectFolder) {
                File file = WorkingDirectory.toAbsolutePath(new File(this.getValue(this.projectFolder)));
                this.project = null;
                if (Project.isProject(file)) {
                    File file2;
                    this.project = Project.createProject(file);
                    if (!this.project.isNewProject() && (file2 = this.project.getProjectFile()).exists() && file2.length() > 0L) {
                        try {
                            this.project.loadProjectFile();
                        }
                        catch (IOException iOException) {
                            this.project = null;
                        }
                    }
                }
            }
        }
    }
}

