/*
 * Decompiled with CFR 0.152.
 */
package com.ef_prime.rflow.ui.base;

import com.ef_prime.rflow.Rflow;
import com.ef_prime.rflow.core.base.FileEditEvent;
import com.ef_prime.rflow.core.base.FileEditEventHandler;
import com.ef_prime.rflow.core.base.FileEditManager;
import com.ef_prime.rflow.core.base.ProjectsManager;
import com.ef_prime.rflow.core.base.RflowEventHandler;
import com.ef_prime.rflow.core.flow.FlowModel;
import com.ef_prime.rflow.resource.Messages;
import com.ef_prime.rflow.ui.base.Icons;
import com.ef_prime.rflow.ui.base.ProjectTree;
import com.ef_prime.rflow.ui.base.ProjectsView;
import com.ef_prime.rflow.ui.common.component.Actions;
import com.ef_prime.rflow.ui.common.component.LoggableAction;
import com.ef_prime.rflow.ui.common.view.View;
import java.awt.Component;
import java.awt.event.ActionEvent;
import javax.swing.JDialog;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.tree.DefaultTreeModel;

public class ProjectView
extends View
implements RflowEventHandler,
FileEditEventHandler {
    private ProjectsManager projectsManager;
    private ProjectTree tree;
    private SingleProjectActions actions;

    public ProjectView(ProjectsManager projectsManager) {
        this.projectsManager = projectsManager;
        this.actions = new SingleProjectActions();
        this.setIconOnly(true);
        this.setIconToolTip(Messages.getString("Menu.project"));
        this.setIcon(Icons.getIcon("16/package.png"));
        this.tree = new SingleProjectTree(projectsManager);
        JScrollPane jScrollPane = new JScrollPane(this.tree);
        jScrollPane.setBorder(null);
        JToolBar jToolBar = new JToolBar();
        jToolBar.setFloatable(false);
        jToolBar.setBorder(null);
        jToolBar.add(this.actions.get(SingleProjectActions.OpenProjects.class));
        this.add((Component)jScrollPane, "Center");
        this.add((Component)jToolBar, "South");
    }

    @Override
    protected void viewDidBecomeDisplayable() {
        Rflow.getInstance().addRflowEventHandler(this);
        FileEditManager.getInstance().addEventHandler(this);
    }

    @Override
    protected void viewDidBecomeUndisplayable() {
        Rflow.getInstance().removeRflowEventHandler(this);
        FileEditManager.getInstance().removeEventHandler(this);
    }

    @Override
    protected void refreshWorkDone(Object object) {
        DefaultTreeModel defaultTreeModel = this.projectsManager.createCurrentProjectTreeModel();
        this.tree.setModel(defaultTreeModel);
    }

    @Override
    public void rflowWillShutdown() {
    }

    @Override
    public void rflowProjectDidStart() {
        this.refresh();
    }

    @Override
    public void rflowProjectWillEnd() {
    }

    @Override
    public void fileEditStateChanged(FileEditEvent fileEditEvent) {
        if (!(fileEditEvent.getResource() instanceof FlowModel)) {
            return;
        }
        if (fileEditEvent.isResourceChanged()) {
            this.refresh();
        }
    }

    private class SingleProjectActions
    extends Actions {
        public SingleProjectActions() {
            this.put(new OpenProjects());
        }

        private class OpenProjects
        extends LoggableAction {
            public OpenProjects() {
                this.putValue("Name", Messages.getStringWithDots("Action.start_page"));
            }

            @Override
            public void action(ActionEvent actionEvent) {
                JDialog jDialog = ProjectsView.createDialog(Rflow.mainFrame(), ProjectView.this.projectsManager);
                jDialog.setVisible(true);
            }
        }
    }

    private class SingleProjectTree
    extends ProjectTree {
        public SingleProjectTree(ProjectsManager projectsManager) {
            super(projectsManager);
            this.setRootVisible(true);
            this.setShowsRootHandles(false);
        }
    }
}

