/*
 * Decompiled with CFR 0.152.
 */
package com.ef_prime.rflow.ui.base;

import com.ef_prime.rflow.Rflow;
import com.ef_prime.rflow.core.app.file.FileUtility;
import com.ef_prime.rflow.core.base.FileManager;
import com.ef_prime.rflow.core.base.Project;
import com.ef_prime.rflow.core.base.ProjectsManager;
import com.ef_prime.rflow.core.base.Settings;
import com.ef_prime.rflow.core.common.keyvalue.BoolKey;
import com.ef_prime.rflow.core.common.keyvalue.ChoiceKey;
import com.ef_prime.rflow.core.common.keyvalue.FileKey;
import com.ef_prime.rflow.core.common.keyvalue.Key;
import com.ef_prime.rflow.core.common.keyvalue.PanelWidgetNode;
import com.ef_prime.rflow.core.common.keyvalue.StrKey;
import com.ef_prime.rflow.core.common.keyvalue.ValueChangeEvent;
import com.ef_prime.rflow.core.common.keyvalue.ValueChangeEventHandler;
import com.ef_prime.rflow.core.common.keyvalue.ValueMap;
import com.ef_prime.rflow.core.common.keyvalue.ViewOptions;
import com.ef_prime.rflow.core.common.keyvalue.WidgetNode;
import com.ef_prime.rflow.resource.Messages;
import com.ef_prime.rflow.ui.base.FileProjectNode;
import com.ef_prime.rflow.ui.base.FolderProjectNode;
import com.ef_prime.rflow.ui.base.ProjectNode;
import com.ef_prime.rflow.ui.common.keyvalue.WidgetFactory;
import com.ef_prime.rflow.ui.common.view.Page;
import com.ef_prime.rflow.ui.common.view.PagesView;
import com.ef_prime.rflow.ui.common.view.PagesViewEvent;
import com.ef_prime.rflow.ui.common.view.PagesViewEventHandler;
import com.ef_prime.rflow.ui.util.UIUtility;
import com.ef_prime.rflow.ui.view.BasicFileNode;
import com.ef_prime.rflow.ui.view.ProjectHomeFileNode;
import java.awt.Component;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.tree.TreeNode;
import org.apache.commons.lang3.StringUtils;

public class ProjectWizard
extends PagesView
implements PagesViewEventHandler {
    private static final Logger LOGGER = Logger.getLogger(ProjectWizard.class.getName());
    protected ProjectSettings projectName;
    protected boolean succeeded;

    public ProjectWizard() {
        this.addPagesViewEventHandler(this);
    }

    protected ProjectSettings createViewModel() {
        return new ProjectSettings();
    }

    @Override
    protected Page buildInitialPage() {
        this.projectName = this.createViewModel();
        return new ProjectSettingsView(this.projectName);
    }

    public boolean isSucceeded() {
        return this.succeeded;
    }

    protected void setSucceeded(boolean bl) {
        this.succeeded = bl;
    }

    @Override
    protected boolean viewWillClose(int n) {
        if (n != 1) {
            return true;
        }
        try {
            Project project = this.projectName.createProject();
            if (!project.getLocation().isAbsolute()) {
                throw new Exception(Messages.getString("Error.abs_path") + ": " + String.valueOf(project.getLocation()));
            }
            try {
                project.createLocation();
            }
            catch (IOException iOException) {
                throw new IOException(Messages.getString("Error.file.create_folder") + ": " + String.valueOf(project.getLocation()), iOException);
            }
            Rflow.getInstance().loadProject(project, true, true);
            Rflow.getInstance().loadEmptyFlow(false);
            try {
                this.createDefaultFileConfig(project);
            }
            catch (IOException iOException) {
                LOGGER.log(Level.WARNING, "Failed to save project's file config.", iOException);
            }
            this.addProjectBookmark(project);
            this.succeeded = true;
            return true;
        }
        catch (Exception exception) {
            UIUtility.showErrorDialog((Component)this, exception);
            this.succeeded = false;
            return false;
        }
    }

    @Override
    public void pagesViewDone(PagesViewEvent pagesViewEvent) {
    }

    protected void createDefaultFileConfig(Project project) throws IOException {
        NewProjectFileManager newProjectFileManager = new NewProjectFileManager();
        Boolean bl = Rflow.settings().getValue(Settings.SHOW_HIDDEN_FILES);
        newProjectFileManager.add(new ProjectHomeFileNode(project.getLocation(), bl), 0);
        if (!FileUtility.isChild(project.getLocation(), project.getWorkspaceDir())) {
            newProjectFileManager.add(new BasicFileNode(project.getWorkspaceDir(), bl), 1);
        }
        newProjectFileManager.storeYaml(new File(project.getConfDir(), "file.yaml"));
        FileManager.getInstance().load();
    }

    protected void addProjectBookmark(Project project) {
        if (this.projectName.addToBookmark()) {
            FileProjectNode fileProjectNode = new FileProjectNode(project.getLocation());
            fileProjectNode.setName(this.projectName.getBookmarkName());
            ProjectsManager.getInstance().addNode(fileProjectNode, this.projectName.getBookmarkLocation());
        }
    }

    protected static class ProjectSettings
    extends ValueMap {
        protected static final StrKey PROJECT_NAME = ((StrKey.Builder)StrKey.builder("project_name", Messages.getString("Project.project_name")).setFrequentUpdate(true)).build();
        protected static final FileKey LOCATION = ((FileKey.Builder)((FileKey.Builder)((FileKey.Builder)((FileKey.Builder)((Key.Builder)FileKey.builder("project_location", Messages.getString("Project.location")).setMode(1)).setDynamicDefault(true)).setFillDefaultOnFocus(true)).setDefaultDirectory(":projects_home")).setAbstractPathEnabled(false)).build();
        protected static final FileKey WORKING_DIRECTORY = ((FileKey.Builder)((FileKey.Builder)((FileKey.Builder)((Key.Builder)FileKey.builder("working_directory", "").setMode(1)).setDynamicDefault(true)).setDefaultDirectory(":projects_home")).setAbstractPathEnabled(false)).build();
        protected static final BoolKey ADD_TO_BOOKMARK = ((BoolKey.Builder)((BoolKey.Builder)BoolKey.builder("add_to_bookmark", Messages.getString("Project.add_to_bookmark")).noLabel()).setDefaultValue(Boolean.TRUE)).build();
        protected static final StrKey BOOKMARK_NAME = ((StrKey.Builder)((StrKey.Builder)((StrKey.Builder)StrKey.builder("bookmark_name", Messages.getString("Message.name")).setDynamicDefault(true)).addEnabledKeyLink(ADD_TO_BOOKMARK, true)).setFillDefaultOnFocus(true)).build();
        protected ChoiceKey location;
        protected List<ProjectNode> nodes;

        public ProjectSettings() {
            ProjectsManager projectsManager = ProjectsManager.getInstance();
            ProjectNode projectNode = (ProjectNode)projectsManager.getProjectsTreeModel().getRoot();
            ArrayList<String> arrayList = new ArrayList<String>();
            this.nodes = new ArrayList<ProjectNode>();
            String string = null;
            arrayList.add("0");
            arrayList.add(Messages.getString("View.Bookmark.default_location"));
            this.nodes.add(projectNode);
            string = "0";
            for (int i = 0; i < projectNode.getChildCount(); ++i) {
                TreeNode treeNode = projectNode.getChildAt(i);
                if (!(treeNode instanceof FolderProjectNode)) continue;
                arrayList.add(Integer.toString(this.nodes.size()));
                arrayList.add(((FolderProjectNode)treeNode).getName());
                this.nodes.add((ProjectNode)treeNode);
            }
            this.location = ((ChoiceKey.Builder)((ChoiceKey.Builder)((Key.Builder)ChoiceKey.builder("location", Messages.getString("View.Bookmark.location")).setValuesAndLabels(arrayList.toArray(new String[arrayList.size()]))).setDefaultValue(string)).addEnabledKeyLink(ADD_TO_BOOKMARK, true)).build();
            this.registerKeys(PROJECT_NAME, LOCATION, WORKING_DIRECTORY, ADD_TO_BOOKMARK, BOOKMARK_NAME, this.location, Project.ENCODING, Project.NEWLINE);
        }

        public File getLocation() {
            return new File(this.getValueOrDefault(LOCATION));
        }

        public Project createProject() {
            return Project.createProject(this.getLocation(), this.getValue(PROJECT_NAME), this.getValue(WORKING_DIRECTORY), this.getValue(Project.ENCODING), this.getValue(Project.NEWLINE));
        }

        public boolean addToBookmark() {
            return this.getValue(ADD_TO_BOOKMARK);
        }

        public String getBookmarkName() {
            return this.getValueOrDefault(BOOKMARK_NAME);
        }

        public ProjectNode getBookmarkLocation() {
            return this.nodes.get(Integer.valueOf(this.getValue(this.location)));
        }

        @Override
        public Object getDynamicDefaultValue(Key<?> key) {
            try {
                if (key.equals(LOCATION) && !this.isStringEmpty(PROJECT_NAME)) {
                    String string = this.getValue(PROJECT_NAME);
                    string = FileUtility.toLegalFileName(string);
                    return new File(Rflow.settings().getDefaultWorkingDir(), string).getAbsolutePath();
                }
                if (key == WORKING_DIRECTORY) {
                    String string = this.getValue(LOCATION);
                    if (string.isEmpty()) {
                        string = (String)this.getDynamicDefaultValue(LOCATION);
                    }
                    if (StringUtils.isEmpty((CharSequence)string)) {
                        return super.getDynamicDefaultValue(key);
                    }
                    File file = new File(string);
                    if (!file.isAbsolute()) {
                        return super.getDynamicDefaultValue(key);
                    }
                    Project project = Project.createProject(file);
                    return project.getDefaultWorkspaceDir().getAbsolutePath();
                }
                if (key == BOOKMARK_NAME) {
                    return this.getValue(PROJECT_NAME);
                }
            }
            catch (Exception exception) {
                LOGGER.log(Level.SEVERE, "Failed get default value of key " + key.getTitle(), exception);
            }
            return super.getDynamicDefaultValue(key);
        }

        @Override
        public WidgetNode getWidgetNode(ViewOptions viewOptions) {
            return new PanelWidgetNode().addElements(PROJECT_NAME, LOCATION, Project.ENCODING, Project.NEWLINE, ADD_TO_BOOKMARK, PanelWidgetNode.indent().addElements(BOOKMARK_NAME, this.location));
        }

        public boolean isReady() {
            return !this.isStringEmpty(PROJECT_NAME);
        }
    }

    protected static class ProjectSettingsView
    extends Page
    implements ValueChangeEventHandler {
        private ProjectSettings projectName;

        public ProjectSettingsView(ProjectSettings projectSettings) {
            this.projectName = projectSettings;
            projectSettings.addEventHandler(this);
            this.add(WidgetFactory.getInstance().create(projectSettings));
        }

        @Override
        public Page getNextPage() throws Exception {
            return null;
        }

        @Override
        public boolean hasNextPage() {
            return false;
        }

        @Override
        public boolean canGoNext() {
            return this.projectName.isReady();
        }

        @Override
        public void valueChanged(ValueChangeEvent valueChangeEvent) {
            this.dispatchPageEvent(0);
        }
    }

    protected static class NewProjectFileManager
    extends FileManager {
        protected NewProjectFileManager() {
        }

        @Override
        protected void installEventHandlers() {
        }

        @Override
        protected void autoStore() {
        }
    }
}

