/*
 * Decompiled with CFR 0.152.
 */
package com.ef_prime.rflow.ui.base;

import com.ef_prime.rflow.Rflow;
import com.ef_prime.rflow.RflowActions;
import com.ef_prime.rflow.core.base.Project;
import com.ef_prime.rflow.core.base.ProjectsManager;
import com.ef_prime.rflow.core.base.Settings;
import com.ef_prime.rflow.core.common.keyvalue.PanelWidgetNode;
import com.ef_prime.rflow.core.common.keyvalue.StrKey;
import com.ef_prime.rflow.core.common.keyvalue.WidgetNode;
import com.ef_prime.rflow.core.common.util.Utility;
import com.ef_prime.rflow.resource.Messages;
import com.ef_prime.rflow.ui.base.Icons;
import com.ef_prime.rflow.ui.base.ProjectNode;
import com.ef_prime.rflow.ui.base.ProjectTree;
import com.ef_prime.rflow.ui.base.SubstanceUI;
import com.ef_prime.rflow.ui.common.component.Actions;
import com.ef_prime.rflow.ui.common.component.LockFile;
import com.ef_prime.rflow.ui.common.component.LoggableAction;
import com.ef_prime.rflow.ui.common.component.SideBorder;
import com.ef_prime.rflow.ui.common.component.SwitchPanel;
import com.ef_prime.rflow.ui.common.keyvalue.WidgetFactory;
import com.ef_prime.rflow.ui.common.view.View;
import com.ef_prime.rflow.ui.util.UIUtility;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.function.Supplier;
import javax.swing.Action;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JToolBar;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.SwingUtilities;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreePath;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.io.FileUtils;
import org.pushingpixels.substance.api.renderers.SubstanceDefaultListCellRenderer;

public class ProjectsView
extends View
implements ItemListener {
    private ProjectTree tree;
    private ProjectsActions actions;

    public ProjectsView(ProjectsManager projectsManager) {
        this.setIconOnly(true);
        this.setIcon(Icons.getIcon("16/package.png"));
        this.tree = new ProjectTree(projectsManager, projectsManager.getProjectsTreeModel()){

            @Override
            public boolean openSelectedProject() {
                return ProjectsView.this.projectAction(() -> super.openSelectedProject());
            }

            @Override
            protected boolean isFlowActionEnabled() {
                return false;
            }
        };
        this.actions = new ProjectsActions();
        JCheckBox jCheckBox = new JCheckBox(Messages.getString("StartPage.restore_session"), (boolean)Rflow.settings().getValue(Settings.RESTORE_SESSION));
        jCheckBox.addItemListener(this);
        JPanel jPanel = this.createQuickStartList();
        this.setLayout((LayoutManager)new MigLayout("insets 10, fill, gapy 10", "[]15[grow]"));
        this.layoutTitleAndAction(this.actions.get(ProjectsActions.QuickStart.class));
        if (jPanel != null) {
            this.add((Component)jPanel, "span 2, gapleft 20, growx, wrap");
        }
        this.layoutTitleAndAction(this.actions.get(ProjectsActions.NewProject.class));
        this.layoutTitle(Messages.getString("StartPage.bookmark"));
        this.add((Component)new JLabel(Messages.getString("StartPage.bookmark_description")), "span 2, gapleft 20, growx, wrap");
        this.add(this.createOpenTree(), "span 2, gapleft 20, grow, wrap");
        this.add((Component)jCheckBox, "span 2, gapleft 20+30, growx, wrap");
        this.layoutTitleAndAction(Messages.getString("StartPage.other_projects"), this.actions.get(ProjectsActions.SelectFolder.class));
        this.layoutAction(this.actions.get(ProjectsActions.Import.class));
    }

    private JPanel createQuickStartList() {
        Object object;
        Serializable serializable;
        List<File> list = Project.getAndCleanUpNewProjects();
        Object object3 = list.iterator();
        while (object3.hasNext()) {
            serializable = object3.next();
            LockFile object22 = LockFile.createLockFile((File)serializable);
            if (object22.canObtainLock()) continue;
            object3.remove();
        }
        if (list.isEmpty()) {
            return null;
        }
        object3 = new ArrayList();
        for (File file : list) {
            object3.add(new QuickProjectEntry(file));
        }
        Collections.sort(object3);
        serializable = new DefaultListModel<QuickProjectEntry>();
        Iterator iterator = object3.iterator();
        while (iterator.hasNext()) {
            object = (QuickProjectEntry)iterator.next();
            serializable.addElement(object);
        }
        JList<QuickProjectEntry> jList = new JList<QuickProjectEntry>((ListModel<QuickProjectEntry>)((Object)serializable));
        jList.setCellRenderer((ListCellRenderer<QuickProjectEntry>)((Object)new QuickProjectRenderer()));
        jList.addMouseListener(new ListMouseHandler());
        object = new QuickProjectRenderer();
        object.setText("DUMMY");
        int n = object.getPreferredSize().height * 3;
        JScrollPane jScrollPane = new JScrollPane(jList);
        jScrollPane.setMinimumSize(new Dimension(jScrollPane.getPreferredSize().width, n));
        ListActions listActions = new ListActions(jList);
        JToolBar jToolBar = new JToolBar(1);
        jToolBar.setFloatable(false);
        jToolBar.add(listActions.get(ListActions.Open.class));
        jToolBar.add(listActions.get(ListActions.Remove.class));
        jList.addListSelectionListener(listActions);
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add((Component)new JLabel(Messages.getString("StartPage.quick_start_crashed")), "North");
        jPanel.add((Component)jScrollPane, "Center");
        jPanel.add((Component)jToolBar, "West");
        return jPanel;
    }

    private Component createOpenTree() {
        JScrollPane jScrollPane = new JScrollPane(this.tree);
        PreviewPanel previewPanel = new PreviewPanel();
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add((Component)jScrollPane, "Center");
        jPanel.add((Component)previewPanel, "South");
        JToolBar jToolBar = new JToolBar(1);
        jToolBar.setFloatable(false);
        jToolBar.add(this.actions.get(ProjectsActions.OpenProject.class));
        jToolBar.add(this.tree.getAction("ACTION_ADD"));
        jToolBar.add(this.tree.getAction("ACTION_REMOVE"));
        JPanel jPanel2 = new JPanel(new BorderLayout());
        jPanel2.add((Component)jPanel, "Center");
        jPanel2.add((Component)jToolBar, "West");
        return jPanel2;
    }

    private void layoutTitleAndAction(Action action) {
        this.layoutTitleAndAction((String)action.getValue("Name"), action);
    }

    private void layoutTitleAndAction(String string, Action action) {
        this.layoutTitle(string);
        this.layoutAction(action);
    }

    private void layoutAction(Action action) {
        String string = (String)action.getValue("ShortDescription");
        this.add((Component)new JButton(action), "gapleft 20");
        this.add((Component)new JLabel(string), "growx, wrap");
    }

    private void layoutTitle(String string) {
        if (string.endsWith("...")) {
            string = string.substring(0, string.length() - "...".length());
        }
        JLabel jLabel = new JLabel(string);
        jLabel.setForeground(Color.BLUE);
        this.add((Component)jLabel, "span 2, split 2");
        this.add((Component)new JSeparator(), "growx, wrap");
    }

    public static JDialog createDialog(Window window, ProjectsManager projectsManager) {
        final ProjectsView projectsView = new ProjectsView(projectsManager);
        JDialog jDialog = new JDialog(window, Messages.getString("StartPage.title"));
        jDialog.setDefaultCloseOperation(2);
        jDialog.setModal(true);
        jDialog.add(projectsView);
        jDialog.setSize(600, 600);
        jDialog.setLocationRelativeTo(window);
        jDialog.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent windowEvent) {
                if (Rflow.project().isDummyProject()) {
                    projectsView.actions.doAction(ProjectsActions.QuickStart.class);
                }
            }
        });
        return jDialog;
    }

    public void addBookmark(String string) {
        this.tree.addBookmark(string);
    }

    private void setWindowVisible(boolean bl) {
        Window window = SwingUtilities.windowForComponent(this);
        if (window != null) {
            window.setVisible(bl);
        }
    }

    private void close() {
        Window window = SwingUtilities.windowForComponent(this);
        if (window != null) {
            window.dispose();
        }
    }

    public boolean projectAction(Supplier<Boolean> supplier) {
        this.setWindowVisible(false);
        Rflow.mainFrame().setWaitingCursor(true);
        try {
            if (!supplier.get().booleanValue()) {
                SwingUtilities.invokeLater(() -> this.setWindowVisible(true));
                boolean bl = false;
                return bl;
            }
            this.close();
            boolean bl = true;
            return bl;
        }
        finally {
            Rflow.mainFrame().setWaitingCursor(false);
        }
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        JCheckBox jCheckBox = (JCheckBox)itemEvent.getSource();
        Rflow.settings().putValue(Settings.RESTORE_SESSION, jCheckBox.isSelected());
    }

    private class ProjectsActions
    extends Actions
    implements PropertyChangeListener {
        public ProjectsActions() {
            this.put(new NewProject());
            this.put(new QuickStart());
            this.put(new OpenProject());
            this.put(new Close());
            this.put(new SelectFolder());
            this.put(new Import());
            ProjectsView.this.tree.getAction("ACTION_OPEN_PROJECT").addPropertyChangeListener(this);
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if ("enabled".equals(propertyChangeEvent.getPropertyName())) {
                this.get(OpenProject.class).setEnabled((Boolean)propertyChangeEvent.getNewValue());
            }
        }

        private class NewProject
        extends LoggableAction {
            public NewProject() {
                Action action = Rflow.getInstance().getActions().get("NEW_PROJECT");
                this.putValue("Name", action.getValue("Name"));
                this.putValue("SmallIcon", action.getValue("SmallIcon"));
                this.putValue("ShortDescription", Messages.getString("StartPage.new_project_description"));
            }

            @Override
            public void action(ActionEvent actionEvent) {
                ProjectsView.this.projectAction(() -> Rflow.getInstance().getActions().newProject());
            }
        }

        private class QuickStart
        extends LoggableAction {
            public QuickStart() {
                this.putValue("Name", Messages.getString("StartPage.quick_start"));
                this.putValue("SmallIcon", Icons.getIcon("16/lightning.png"));
                this.putValue("ShortDescription", Messages.getString("StartPage.quick_start_description"));
            }

            @Override
            public void action(ActionEvent actionEvent) {
                ProjectsView.this.projectAction(() -> {
                    if (!Rflow.getInstance().getActions().askSave()) {
                        return false;
                    }
                    Rflow.getInstance().loadEmptyProject(true);
                    return true;
                });
            }
        }

        private class OpenProject
        extends LoggableAction {
            public OpenProject() {
                this.putValue("Name", Messages.getString("Action.open"));
                this.putValue("SmallIcon", Icons.getIcon("16/folder.png"));
                this.putValue("ShortDescription", this.getValue("Name"));
                this.setEnabled(false);
            }

            @Override
            public void action(ActionEvent actionEvent) {
                ProjectsView.this.tree.openSelectedProject();
            }
        }

        private class Close
        extends LoggableAction {
            public Close() {
                this.putValue("Name", Messages.getString("Button.close"));
            }

            @Override
            public void action(ActionEvent actionEvent) {
                ProjectsView.this.close();
            }
        }

        private class SelectFolder
        extends LoggableAction {
            public SelectFolder() {
                this.putValue("Name", Messages.getStringWithDots("StartPage.select_folder"));
                this.putValue("SmallIcon", Icons.getIcon("16/folder.png"));
                this.putValue("ShortDescription", Messages.getString("StartPage.select_folder_description"));
            }

            @Override
            public void action(ActionEvent actionEvent) {
                ProjectsView.this.projectAction(() -> {
                    RflowActions rflowActions = Rflow.getInstance().getActions();
                    if (!rflowActions.askSave()) {
                        return false;
                    }
                    File file = UIUtility.chooseDirFx(SwingUtilities.windowForComponent(ProjectsView.this), Rflow.settings().getDefaultWorkingDir());
                    if (file == null) {
                        return false;
                    }
                    if (!Project.isProject(file)) {
                        UIUtility.showErrorDialog((Component)ProjectsView.this, "Selected Directory doesn't contain a project information.");
                        return false;
                    }
                    return Rflow.getInstance().getActions().openProject(file, true);
                });
            }
        }

        private class Import
        extends LoggableAction {
            public Import() {
                this.putValue("Name", Messages.getStringWithDots("Action.import"));
                this.putValue("SmallIcon", Icons.getIcon("16/saved_imports.png"));
                this.putValue("ShortDescription", Messages.getString("StartPage.import_description"));
            }

            @Override
            public void action(ActionEvent actionEvent) {
                ProjectsView.this.projectAction(() -> {
                    RflowActions rflowActions = Rflow.getInstance().getActions();
                    return rflowActions.askSave() && rflowActions.importProject();
                });
            }
        }
    }

    private static class QuickProjectEntry
    implements Comparable<QuickProjectEntry> {
        private File location;
        private long lastModified;
        String lastModeifedDate;

        public QuickProjectEntry(File file) {
            this.location = file;
            this.lastModified = file.lastModified();
            this.lastModeifedDate = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date(this.lastModified));
        }

        @Override
        public int compareTo(QuickProjectEntry quickProjectEntry) {
            if (this.lastModified > quickProjectEntry.lastModified) {
                return -1;
            }
            if (this.lastModified < quickProjectEntry.lastModified) {
                return 1;
            }
            return 0;
        }
    }

    private static class QuickProjectRenderer
    extends SubstanceDefaultListCellRenderer {
        private QuickProjectRenderer() {
        }

        public Component getListCellRendererComponent(JList<?> jList, Object object, int n, boolean bl, boolean bl2) {
            super.getListCellRendererComponent(jList, object, n, bl, bl2);
            QuickProjectEntry quickProjectEntry = (QuickProjectEntry)object;
            this.setText(quickProjectEntry.location.getName() + " (" + quickProjectEntry.lastModeifedDate + ")");
            return this;
        }
    }

    private class ListMouseHandler
    extends MouseAdapter {
        private ListMouseHandler() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            if (UIUtility.isLeftMouseButton(mouseEvent) && mouseEvent.getClickCount() == 2) {
                JList jList = (JList)Utility.cast(mouseEvent.getSource());
                List list = jList.getSelectedValuesList();
                if (list == null || list.size() != 1) {
                    return;
                }
                if (Rflow.project().isDummyProject() || !Rflow.project().getLocation().equals(((QuickProjectEntry)list.get((int)0)).location)) {
                    Cursor cursor = jList.getCursor();
                    jList.setCursor(Cursor.getPredefinedCursor(3));
                    try {
                        Rflow.getInstance().getActions().openSavedQuickStartProject(((QuickProjectEntry)list.get((int)0)).location);
                    }
                    finally {
                        jList.setCursor(cursor);
                    }
                    ProjectsView.this.close();
                }
            }
        }
    }

    private class ListActions
    extends Actions
    implements ListSelectionListener {
        private JList<QuickProjectEntry> list;

        public ListActions(JList<QuickProjectEntry> jList) {
            this.list = jList;
            this.put(new Open());
            this.put(new Remove());
            this.refreshEnabled();
        }

        private void refreshEnabled() {
            int[] nArray = this.list.getSelectedIndices();
            this.get(Open.class).setEnabled(nArray.length == 1);
            this.get(Remove.class).setEnabled(nArray.length > 0);
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            if (listSelectionEvent.getValueIsAdjusting()) {
                return;
            }
            this.refreshEnabled();
        }

        private class Open
        extends LoggableAction {
            public Open() {
                this.putValue("SmallIcon", Icons.getIcon("16/folder.png"));
                this.putValue("ShortDescription", Messages.getString("Action.open"));
            }

            @Override
            public void action(ActionEvent actionEvent) {
                List<QuickProjectEntry> list = ListActions.this.list.getSelectedValuesList();
                if (list == null || list.size() != 1) {
                    return;
                }
                if (Rflow.project().isDummyProject() || !Rflow.project().getLocation().equals(list.get((int)0).location)) {
                    Rflow.getInstance().getActions().openProject(list.get((int)0).location, true);
                    ProjectsView.this.close();
                }
            }
        }

        private class Remove
        extends LoggableAction {
            public Remove() {
                this.putValue("SmallIcon", Icons.getIcon("16/delete.png"));
                this.putValue("ShortDescription", Messages.getString("Action.remove"));
            }

            @Override
            public void action(ActionEvent actionEvent) {
                DefaultListModel defaultListModel = (DefaultListModel)ListActions.this.list.getModel();
                int[] nArray = ListActions.this.list.getSelectedIndices();
                for (int i = nArray.length - 1; i >= 0; --i) {
                    int n = nArray[i];
                    QuickProjectEntry quickProjectEntry = (QuickProjectEntry)defaultListModel.remove(n);
                    FileUtils.deleteQuietly((File)quickProjectEntry.location);
                }
            }
        }
    }

    private class PreviewPanel
    extends SwitchPanel
    implements TreeSelectionListener {
        private StrKey pathKey;
        private WidgetNode widgetNode;

        public PreviewPanel() {
            StrKey strKey = ((StrKey.Builder)StrKey.builder(Project.KEY_NAME.getId(), Messages.getString("StartPage.name")).setFixed(true)).build();
            this.pathKey = ((StrKey.Builder)StrKey.builder("path", Messages.getString("StartPage.path")).setFixed(true)).build();
            this.widgetNode = new PanelWidgetNode().addKeys(strKey).addKeys(this.pathKey);
            ProjectsView.this.tree.addTreeSelectionListener(this);
            this.setBorder(new CompoundBorder(new SideBorder(14, SubstanceUI.COLOR_BORDER), new EmptyBorder(2, 2, 2, 2)));
            Component component = WidgetFactory.getInstance().create(Project.createEmptyProject(), this.widgetNode);
            this.setPreferredSize(new Dimension(component.getPreferredSize().width, component.getPreferredSize().height + 4));
            this.setProject(null);
        }

        private void setProject(Project project) {
            Component component = null;
            if (project != null) {
                component = WidgetFactory.getInstance().create(project, this.widgetNode);
            }
            this.set(component);
        }

        @Override
        public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
            TreePath treePath;
            ProjectNode projectNode;
            Project project = null;
            if (ProjectsView.this.tree.getSelectionCount() == 1 && (projectNode = (ProjectNode)(treePath = ProjectsView.this.tree.getSelectionPath()).getLastPathComponent()).isProject()) {
                File file = projectNode.getFile();
                project = Project.createProject(file);
                try {
                    project.loadProjectFile();
                    project.putValue(this.pathKey, file.getAbsolutePath());
                }
                catch (IOException iOException) {
                    project = null;
                }
            }
            this.setProject(project);
        }
    }
}

