/*
 * Decompiled with CFR 0.152.
 */
package com.ef_prime.rflow.ui.base;

import com.apple.eawt.AppEvent;
import com.apple.eawt.Application;
import com.apple.eawt.QuitHandler;
import com.apple.eawt.QuitResponse;
import com.ef_prime.rflow.Rflow;
import com.ef_prime.rflow.RflowActions;
import java.awt.Window;
import java.lang.reflect.Method;
import java.util.logging.Level;
import java.util.logging.Logger;

public class RflowMac
implements QuitHandler {
    private static final Logger LOGGER = Logger.getLogger(RflowMac.class.getName());

    public static void install() {
        RflowMac rflowMac = new RflowMac();
        Application application = Application.getApplication();
        application.setQuitHandler((QuitHandler)rflowMac);
        RflowMac.enableFullScreen();
    }

    private static void enableFullScreen() {
        try {
            Class<?> clazz = Class.forName("com.apple.eawt.FullScreenUtilities");
            Class[] classArray = new Class[]{Window.class, Boolean.TYPE};
            Method method = clazz.getMethod("setWindowCanFullScreen", classArray);
            method.invoke(clazz, Rflow.mainFrame(), true);
        }
        catch (Exception exception) {
            LOGGER.log(Level.WARNING, "OS X Fullscreen Failed.", exception);
        }
    }

    public void handleQuitRequestWith(AppEvent.QuitEvent quitEvent, QuitResponse quitResponse) {
        RflowActions rflowActions = Rflow.getInstance().getActions();
        if (!rflowActions.askSave()) {
            quitResponse.cancelQuit();
        } else {
            rflowActions.exit(0);
            quitResponse.performQuit();
        }
    }
}

