/*
 * Decompiled with CFR 0.152.
 */
package com.ef_prime.rflow.ui.base;

import com.ef_prime.rflow.SettingsDialog;
import com.ef_prime.rflow.core.base.Settings;
import com.ef_prime.rflow.core.base.UserFolder;
import com.ef_prime.rflow.resource.Messages;
import com.ef_prime.rflow.ui.base.SubstanceUI;
import java.awt.Insets;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.application.Platform;
import javafx.embed.swing.JFXPanel;
import javax.swing.JPanel;
import javax.swing.UIManager;
import net.miginfocom.layout.PlatformDefaults;
import net.miginfocom.layout.UnitValue;

public class RflowUI {
    private static final Logger LOGGER = Logger.getLogger(RflowUI.class.getName());
    private static boolean lafSet = false;
    private static boolean fxInitialized;

    public static void initLookAndFeel() {
        if (lafSet) {
            return;
        }
        RflowUI.initResource();
        try {
            if (System.getProperty("swing.defaultlaf") == null) {
                new JPanel();
                SubstanceUI.getInstance().init();
                UIManager.put("ComboBox.noActionOnKeyNavigation", true);
                UIManager.put("TabbedPane.tabAreaInsets", new Insets(0, 0, 0, 0));
                UnitValue unitValue = new UnitValue(5.0f);
                PlatformDefaults.setPanelInsets((UnitValue)unitValue, (UnitValue)unitValue, (UnitValue)unitValue, (UnitValue)unitValue);
                PlatformDefaults.setDialogInsets((UnitValue)unitValue, (UnitValue)unitValue, (UnitValue)unitValue, (UnitValue)unitValue);
            }
        }
        catch (Exception exception) {
            LOGGER.log(Level.SEVERE, "Exception while initializing LAF.", exception);
        }
        lafSet = true;
    }

    public static boolean checkFx() {
        try {
            Class.forName("javafx.application.Platform");
            return true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return false;
        }
    }

    public static void initFx() {
        if (fxInitialized) {
            return;
        }
        fxInitialized = true;
        new JFXPanel();
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                Platform.setImplicitExit((boolean)false);
            }
        });
    }

    public static void exitFx() {
        if (fxInitialized) {
            Platform.runLater((Runnable)new Runnable(){

                @Override
                public void run() {
                    Platform.exit();
                    fxInitialized = false;
                }
            });
        }
    }

    private static void initResource() {
        UIManager.put("AbstractUndoableEdit.undoText", Messages.getString("Action.undo"));
        UIManager.put("AbstractUndoableEdit.redoText", Messages.getString("Action.redo"));
        UIManager.put("OptionPane.cancelButtonText", Messages.getString("Button.cancel"));
        UIManager.put("OptionPane.okButtonText", Messages.getString("Button.ok"));
        UIManager.put("FileChooser.cancelButtonText", Messages.getString("Button.cancel"));
    }

    public static Settings prepareSetting(Settings settings) {
        if (settings.getValue(Settings.IS_FIRST).booleanValue()) {
            settings.setUpDefaults();
            settings = SettingsDialog.showSettingsDialog(settings, true);
            if (settings == null || !UserFolder.getUserSettings().exists() || settings.getValue(Settings.IS_FIRST).booleanValue()) {
                return null;
            }
        }
        return settings;
    }
}

