/*
 * Decompiled with CFR 0.152.
 */
package com.ef_prime.rflow.ui.base;

import com.ef_prime.rflow.Rflow;
import com.ef_prime.rflow.core.base.Project;
import com.ef_prime.rflow.resource.Messages;
import com.ef_prime.rflow.ui.base.ProjectWizard;
import com.ef_prime.rflow.ui.util.UIUtility;
import java.awt.Component;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;

public class SaveProjectWizard
extends ProjectWizard {
    private static final Logger LOGGER = Logger.getLogger(SaveProjectWizard.class.getName());
    private Project originalProject;

    public SaveProjectWizard(Project project) {
        this.originalProject = project;
    }

    @Override
    protected boolean viewWillClose(int n) {
        if (n != 1) {
            return true;
        }
        boolean bl = false;
        try {
            Project project = this.projectName.createProject();
            if (!project.getLocation().isAbsolute()) {
                throw new Exception(Messages.getString("Error.abs_path") + ": " + String.valueOf(project.getLocation()));
            }
            try {
                project.createLocation();
            }
            catch (IOException iOException) {
                throw new IOException(Messages.getString("Error.file.create_folder") + ": " + String.valueOf(project.getLocation()), iOException);
            }
            this.originalProject.setNewProjectSaveMode(true);
            Rflow.getInstance().unloadProject();
            bl = true;
            try {
                project.importProject(this.originalProject);
            }
            catch (IOException iOException) {
                throw new IOException("Failed to move files to new project location.", iOException);
            }
            this.originalProject.setNewProjectSaveMode(false);
            this.originalProject.unload();
            Rflow.getInstance().loadProject(project, false, true);
            try {
                this.createDefaultFileConfig(project);
            }
            catch (IOException iOException) {
                LOGGER.log(Level.WARNING, "Failed to save project's file config.", iOException);
            }
            this.addProjectBookmark(project);
            this.setSucceeded(true);
            return true;
        }
        catch (Exception exception) {
            UIUtility.showErrorDialog((Component)this, exception);
            if (bl) {
                Rflow.getInstance().loadProject(this.originalProject, false, true);
            }
            this.setSucceeded(false);
            return false;
        }
    }
}

