/*
 * Decompiled with CFR 0.152.
 */
package com.ef_prime.rflow.ui.base;

import java.awt.Color;
import org.pushingpixels.substance.api.ColorSchemeAssociationKind;
import org.pushingpixels.substance.api.ComponentState;
import org.pushingpixels.substance.api.DecorationAreaType;
import org.pushingpixels.substance.api.SchemeDerivedColorsResolver;
import org.pushingpixels.substance.api.SubstanceColorScheme;
import org.pushingpixels.substance.api.SubstanceColorSchemeBundle;
import org.pushingpixels.substance.api.SubstanceSkin;
import org.pushingpixels.substance.api.colorscheme.EbonyColorScheme;
import org.pushingpixels.substance.api.colorscheme.LightGrayColorScheme;
import org.pushingpixels.substance.api.colorscheme.MetallicColorScheme;
import org.pushingpixels.substance.api.colorscheme.SteelBlueColorScheme;
import org.pushingpixels.substance.api.painter.border.ClassicBorderPainter;
import org.pushingpixels.substance.api.painter.decoration.ArcDecorationPainter;
import org.pushingpixels.substance.api.painter.decoration.BrushedMetalDecorationPainter;
import org.pushingpixels.substance.api.painter.decoration.SubstanceDecorationPainter;
import org.pushingpixels.substance.api.painter.fill.ClassicFillPainter;
import org.pushingpixels.substance.api.painter.highlight.ClassicHighlightPainter;
import org.pushingpixels.substance.api.shaper.ClassicButtonShaper;
import org.pushingpixels.substance.internal.utils.SubstanceColorUtilities;

public class Skin
extends SubstanceSkin {
    public Skin() {
        SubstanceColorScheme substanceColorScheme = new ActiveColorScheme().tint(0.15).named("Business Black Steel Active");
        SubstanceColorScheme substanceColorScheme2 = new EnabledColorScheme().tint(0.05).named("Business Black Steel Enabled");
        SubstanceColorScheme substanceColorScheme3 = new LightGrayColorScheme().tint(0.05).named("Business Black Steel Disabled");
        SubstanceColorSchemeBundle substanceColorSchemeBundle = new SubstanceColorSchemeBundle(substanceColorScheme, substanceColorScheme2, substanceColorScheme3);
        substanceColorSchemeBundle.registerHighlightColorScheme(substanceColorScheme, 0.6f, new ComponentState[]{ComponentState.ROLLOVER_UNSELECTED});
        substanceColorSchemeBundle.registerHighlightColorScheme(substanceColorScheme, 0.8f, new ComponentState[]{ComponentState.SELECTED});
        substanceColorSchemeBundle.registerHighlightColorScheme(substanceColorScheme, 0.95f, new ComponentState[]{ComponentState.ROLLOVER_SELECTED});
        substanceColorSchemeBundle.registerHighlightColorScheme(substanceColorScheme, 0.8f, new ComponentState[]{ComponentState.ARMED, ComponentState.ROLLOVER_ARMED});
        this.registerDecorationAreaSchemeBundle(substanceColorSchemeBundle, new DecorationAreaType[]{DecorationAreaType.NONE});
        SubstanceColorScheme substanceColorScheme4 = new EbonyColorScheme().shiftBackground(Color.black, 0.3).tint(0.05).named("Business Black Steel Active Header");
        SubstanceColorScheme substanceColorScheme5 = new EbonyColorScheme().tint(0.05).named("Business Black Steel Enabled Header");
        SubstanceColorSchemeBundle substanceColorSchemeBundle2 = new SubstanceColorSchemeBundle(substanceColorScheme4, substanceColorScheme5, substanceColorScheme3);
        substanceColorSchemeBundle2.registerColorScheme(substanceColorScheme5, 0.5f, new ComponentState[]{ComponentState.DISABLED_UNSELECTED, ComponentState.DISABLED_SELECTED});
        substanceColorSchemeBundle2.registerHighlightColorScheme(substanceColorScheme, 0.6f, new ComponentState[]{ComponentState.ROLLOVER_UNSELECTED});
        substanceColorSchemeBundle2.registerHighlightColorScheme(substanceColorScheme, 0.8f, new ComponentState[]{ComponentState.SELECTED});
        substanceColorSchemeBundle2.registerHighlightColorScheme(substanceColorScheme, 0.95f, new ComponentState[]{ComponentState.ROLLOVER_SELECTED});
        substanceColorSchemeBundle2.registerHighlightColorScheme(substanceColorScheme, 0.8f, new ComponentState[]{ComponentState.ARMED, ComponentState.ROLLOVER_ARMED});
        this.registerDecorationAreaSchemeBundle(substanceColorSchemeBundle2, substanceColorScheme4, new DecorationAreaType[]{DecorationAreaType.PRIMARY_TITLE_PANE, DecorationAreaType.SECONDARY_TITLE_PANE, DecorationAreaType.HEADER});
        SubstanceColorScheme substanceColorScheme6 = substanceColorScheme.shade(0.1).saturate(-0.5).named("Business Black Steel Active General");
        SubstanceColorScheme substanceColorScheme7 = substanceColorScheme.tint(0.3).saturate(-0.7).named("Business Black Steel Enabled General");
        SubstanceColorSchemeBundle substanceColorSchemeBundle3 = new SubstanceColorSchemeBundle(substanceColorScheme6, substanceColorScheme7, substanceColorScheme3);
        substanceColorSchemeBundle3.registerColorScheme(substanceColorScheme3, 0.5f, new ComponentState[]{ComponentState.DISABLED_UNSELECTED});
        this.registerDecorationAreaSchemeBundle(substanceColorSchemeBundle3, new DecorationAreaType[]{DecorationAreaType.FOOTER, DecorationAreaType.GENERAL});
        this.buttonShaper = new ClassicButtonShaper();
        this.fillPainter = new ClassicFillPainter();
        this.borderPainter = new ClassicBorderPainter();
        BrushedMetalDecorationPainter brushedMetalDecorationPainter = new BrushedMetalDecorationPainter();
        brushedMetalDecorationPainter.setBaseDecorationPainter((SubstanceDecorationPainter)new ArcDecorationPainter());
        brushedMetalDecorationPainter.setTextureAlpha(0.02f);
        this.decorationPainter = brushedMetalDecorationPainter;
        this.highlightPainter = new ClassicHighlightPainter();
        ((SubstanceColorSchemeBundle)this.colorSchemeBundleMap.get(DecorationAreaType.NONE)).registerColorScheme((SubstanceColorScheme)new LightGrayColorScheme(), ColorSchemeAssociationKind.BORDER, new ComponentState[]{ComponentState.ENABLED});
    }

    public String getDisplayName() {
        return "Rflow Skin";
    }

    private static class ActiveColorScheme
    extends SteelBlueColorScheme {
        public ActiveColorScheme() {
            this.derivedColorsResolver = DerivedColorResolverEx.INSTANCE;
        }
    }

    private static class EnabledColorScheme
    extends MetallicColorScheme {
        public EnabledColorScheme() {
            this.derivedColorsResolver = DerivedColorResolverEx.INSTANCE;
        }
    }

    private static class DerivedColorResolverEx
    implements SchemeDerivedColorsResolver {
        static final DerivedColorResolverEx INSTANCE = new DerivedColorResolverEx();

        private DerivedColorResolverEx() {
        }

        public boolean isDark() {
            return false;
        }

        public SchemeDerivedColorsResolver invert() {
            return this;
        }

        public Color getWatermarkStampColor(SubstanceColorScheme substanceColorScheme) {
            return SubstanceColorUtilities.getAlphaColor((Color)substanceColorScheme.getMidColor(), (int)50);
        }

        public Color getWatermarkLightColor(SubstanceColorScheme substanceColorScheme) {
            return substanceColorScheme.getLightColor();
        }

        public Color getWatermarkDarkColor(SubstanceColorScheme substanceColorScheme) {
            return SubstanceColorUtilities.getAlphaColor((Color)substanceColorScheme.getDarkColor(), (int)15);
        }

        public Color getLineColor(SubstanceColorScheme substanceColorScheme) {
            return SubstanceColorUtilities.getInterpolatedColor((Color)substanceColorScheme.getMidColor(), (Color)substanceColorScheme.getDarkColor(), (double)0.7);
        }

        public Color getSelectionForegroundColor(SubstanceColorScheme substanceColorScheme) {
            return substanceColorScheme.getUltraDarkColor().darker().darker();
        }

        public Color getSelectionBackgroundColor(SubstanceColorScheme substanceColorScheme) {
            return substanceColorScheme.getExtraLightColor();
        }

        public Color getBackgroundFillColor(SubstanceColorScheme substanceColorScheme) {
            return substanceColorScheme.getExtraLightColor();
        }

        public Color getFocusRingColor(SubstanceColorScheme substanceColorScheme) {
            return substanceColorScheme.getDarkColor();
        }

        public Color getTextBackgroundFillColor(SubstanceColorScheme substanceColorScheme) {
            return Color.WHITE;
        }
    }
}

