/*
 * Decompiled with CFR 0.152.
 */
package com.ef_prime.rflow.ui.base;

import com.ef_prime.rflow.Rflow;
import com.ef_prime.rflow.core.common.keyvalue.ValueChangeEvent;
import com.ef_prime.rflow.core.common.keyvalue.ValueChangeEventHandler;
import com.ef_prime.rflow.ui.base.Icons;
import com.ef_prime.rflow.ui.base.Skin;
import com.ef_prime.rflow.ui.base.SkinOptions;
import com.ef_prime.rflow.ui.common.keyvalue.WidgetFactory;
import java.awt.Color;
import java.awt.Component;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.plaf.FontUIResource;
import org.pushingpixels.lafwidget.animation.AnimationConfigurationManager;
import org.pushingpixels.lafwidget.animation.AnimationFacet;
import org.pushingpixels.substance.api.SubstanceConstants;
import org.pushingpixels.substance.api.SubstanceLookAndFeel;
import org.pushingpixels.substance.api.SubstanceSkin;
import org.pushingpixels.substance.api.fonts.FontPolicy;
import org.pushingpixels.substance.api.fonts.FontSet;
import org.pushingpixels.substance.internal.fonts.FontPolicies;

public class SubstanceUI
implements ValueChangeEventHandler {
    public static final Color COLOR_TOOLTIP = new Color(255, 255, 230);
    public static final Color COLOR_BORDER = new Color(210, 214, 218);
    private static final SubstanceUI instance = new SubstanceUI();
    private SkinOptions skinOptions = new SkinOptions();

    private SubstanceUI() {
        this.skinOptions.addEventHandler(this);
    }

    public static SubstanceUI getInstance() {
        return instance;
    }

    public void init() throws UnsupportedLookAndFeelException {
        UIManager.put("Tree.leafIcon", Icons.getIcon("16/bullet_black.png"));
        UIManager.put("Tree.openIcon", Icons.getIcon("16/folder.png"));
        UIManager.put("Tree.closedIcon", Icons.getIcon("16/folder.png"));
        SubstanceLookAndFeel.setSkin((SubstanceSkin)new Skin());
        UIManager.put("substancelaf.tabbedPaneContentBorderKind", SubstanceConstants.TabContentPaneBorderKind.SINGLE_FULL);
        this.skinOptions.putValue(SkinOptions.FONT_SIZE, 12);
        AnimationConfigurationManager.getInstance().disallowAnimations(AnimationFacet.ROLLOVER, JTable.class);
        AnimationConfigurationManager.getInstance().disallowAnimations(AnimationFacet.SELECTION, JTable.class);
    }

    public void showSkinOptionsDialog() {
        Component component = WidgetFactory.getInstance().create(this.skinOptions);
        JOptionPane jOptionPane = new JOptionPane(component, -1);
        JDialog jDialog = jOptionPane.createDialog(Rflow.getInstance().getMainFrame(), "Skin");
        jDialog.setModal(false);
        jDialog.setResizable(true);
        jDialog.setVisible(true);
    }

    @Override
    public void valueChanged(ValueChangeEvent valueChangeEvent) {
        if (valueChangeEvent.getKey() == SkinOptions.FONT_SIZE) {
            Integer n = (Integer)valueChangeEvent.getValue();
            FontUIResource fontUIResource = SubstanceLookAndFeel.getFontPolicy().getFontSet("", null).getControlFont();
            SubstanceLookAndFeel.setFontPolicy((FontPolicy)FontPolicies.createFixedPolicy((FontSet)new FixedFontSet(new FontUIResource(fontUIResource.deriveFont(n.floatValue())))));
        } else if (valueChangeEvent.getKey() == SkinOptions.SKIN) {
            String string = (String)valueChangeEvent.getValue();
            SubstanceLookAndFeel.setSkin((String)string);
        }
    }

    private static class FixedFontSet
    implements FontSet {
        private FontUIResource font;

        public FixedFontSet(FontUIResource fontUIResource) {
            this.font = fontUIResource;
        }

        public FontUIResource getControlFont() {
            return this.font;
        }

        public FontUIResource getMenuFont() {
            return this.font;
        }

        public FontUIResource getTitleFont() {
            return this.font;
        }

        public FontUIResource getWindowTitleFont() {
            return this.font;
        }

        public FontUIResource getSmallFont() {
            return this.font;
        }

        public FontUIResource getMessageFont() {
            return this.font;
        }
    }
}

