/*
 * Decompiled with CFR 0.152.
 */
package com.ef_prime.rflow.ui.common.component;

import java.awt.event.ActionEvent;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.KeyStroke;

public class Actions
extends ActionMap {
    private ActionEvent event = new ActionEvent(this, 0, "");

    public void put(Action action) {
        this.put(action.getClass(), action);
    }

    public void doAction(Object object) {
        Action action = this.get(object);
        if (action != null) {
            action.actionPerformed(this.event);
        }
    }

    public void installActions(JComponent jComponent, boolean bl) {
        this.installActions(jComponent, bl, 1);
    }

    public void installActions(JComponent jComponent, boolean bl, int n) {
        if (bl) {
            jComponent.setActionMap(this);
            jComponent.setInputMap(n, this.createInputMap());
        } else {
            this.installActions(jComponent.getActionMap());
            this.installToInputMap(jComponent.getInputMap(n));
        }
    }

    public void installAction(Object object, JComponent jComponent, int n) {
        Action action = this.get(object);
        jComponent.getActionMap().put(object, action);
        KeyStroke keyStroke = (KeyStroke)action.getValue("AcceleratorKey");
        if (keyStroke != null) {
            jComponent.getInputMap(n).put(keyStroke, object);
        }
    }

    public void installActions(ActionMap actionMap) {
        for (Object object : this.keys()) {
            actionMap.put(object, this.get(object));
        }
    }

    public void installAcceleratorKeys(JComponent jComponent, int n, Object ... objectArray) {
        InputMap inputMap = jComponent.getInputMap(n);
        for (Object object : objectArray) {
            Action action = this.get(object);
            KeyStroke keyStroke = (KeyStroke)action.getValue("AcceleratorKey");
            if (keyStroke == null) continue;
            inputMap.put(keyStroke, object);
        }
    }

    public void uninstallActions(JComponent jComponent) {
        ActionMap actionMap = jComponent.getActionMap();
        for (Object object : this.keys()) {
            actionMap.remove(object);
        }
        InputMap inputMap = jComponent.getInputMap();
        InputMap inputMap2 = this.createInputMap();
        for (KeyStroke keyStroke : inputMap2.keys()) {
            inputMap.remove(keyStroke);
        }
    }

    public InputMap createInputMap() {
        InputMap inputMap = new InputMap();
        for (Object object : this.allKeys()) {
            Action action = this.get(object);
            KeyStroke keyStroke = (KeyStroke)action.getValue("AcceleratorKey");
            if (keyStroke == null) continue;
            inputMap.put(keyStroke, object);
        }
        return inputMap;
    }

    public void installToInputMap(InputMap inputMap) {
        InputMap inputMap2 = this.createInputMap();
        KeyStroke[] keyStrokeArray = inputMap2.keys();
        if (keyStrokeArray != null) {
            for (KeyStroke keyStroke : keyStrokeArray) {
                inputMap.put(keyStroke, inputMap2.get(keyStroke));
            }
        }
    }
}

