/*
 * Decompiled with CFR 0.152.
 */
package com.ef_prime.rflow.ui.common.component;

import com.ef_prime.rflow.core.common.util.ThreadUtility;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import javax.swing.JComponent;
import javax.swing.JLayer;
import javax.swing.Timer;
import javax.swing.plaf.LayerUI;

public class BusyLayerUI<V extends Component>
extends LayerUI<V>
implements ActionListener {
    private int rotateCount = 0;
    private boolean running = false;
    private boolean waiting = false;
    private Timer timer;
    private int radius = 20;
    private int point = 8;
    private Color background = new Color(0, 0, 0, 12);
    private boolean viewHidden;

    public void setBackground(Color color) {
        this.background = color;
    }

    public void start() {
        this.start(0);
    }

    public synchronized void start(int n) {
        if (this.running) {
            return;
        }
        this.waiting = true;
        if (this.timer == null) {
            this.timer = new Timer(83, this);
        }
        if (n > 0) {
            ThreadUtility.execute(() -> {
                try {
                    Thread.sleep(n);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                BusyLayerUI busyLayerUI = this;
                synchronized (busyLayerUI) {
                    if (this.waiting) {
                        this.running = true;
                        this.timer.start();
                    }
                }
            });
        } else {
            this.running = true;
            this.timer.start();
        }
    }

    public synchronized void stop() {
        this.running = false;
        this.waiting = false;
        if (this.timer != null && this.timer.isRunning()) {
            this.timer.stop();
            this.firePropertyChange("repaint", 0, 1);
        }
    }

    public void setViewHidden(boolean bl) {
        this.viewHidden = bl;
    }

    public boolean isViweHidden() {
        return this.viewHidden;
    }

    @Override
    public void paint(Graphics graphics, JComponent jComponent) {
        if (!this.running || !this.viewHidden) {
            super.paint(graphics, jComponent);
        }
        if (!this.running) {
            return;
        }
        Graphics2D graphics2D = (Graphics2D)graphics.create();
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        Dimension dimension = jComponent.getSize();
        if (this.background != null) {
            graphics2D.setColor(this.background);
            graphics2D.fillRect(0, 0, dimension.width, dimension.height);
        }
        for (int i = 0; i < 12; ++i) {
            double d = Math.PI * 2 * (double)(i + this.rotateCount) / 12.0;
            int n = (int)(Math.cos(d) * (double)this.radius + 0.5) + dimension.width / 2;
            int n2 = (int)(Math.sin(d) * (double)this.radius + 0.5) + dimension.height / 2;
            int n3 = 128 * i / 12;
            graphics2D.setColor(new Color(0, 0, 0, n3));
            graphics2D.fillOval(n - this.point / 2, n2 - this.point / 2, this.point, this.point);
        }
        graphics2D.dispose();
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (this.running) {
            ++this.rotateCount;
            if (this.rotateCount > 11) {
                this.rotateCount = 0;
            }
            this.firePropertyChange("repaint", 0, 1);
        }
    }

    @Override
    public void applyPropertyChange(PropertyChangeEvent propertyChangeEvent, JLayer<? extends V> jLayer) {
        jLayer.repaint();
    }

    public static BusyLayerUI<?> get(JLayer<?> jLayer) {
        return (BusyLayerUI)jLayer.getUI();
    }
}

