/*
 * Decompiled with CFR 0.152.
 */
package com.ef_prime.rflow.ui.common.component;

import com.ef_prime.rflow.resource.Messages;
import com.ef_prime.rflow.ui.base.Prefs;
import java.awt.Dimension;
import java.awt.event.ActionListener;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JPanel;

public class ButtonPanel
extends JPanel {
    private JButton[] buttons;

    public ButtonPanel(ActionListener actionListener, ActionListener actionListener2) {
        this(actionListener, actionListener2, Prefs.BUTTON_SIZE);
    }

    public ButtonPanel(ActionListener actionListener, ActionListener actionListener2, Dimension dimension) {
        this(new ActionListener[]{actionListener, actionListener2}, new String[]{Messages.getString("Button.ok"), Messages.getString("Button.cancel")}, dimension, 50);
    }

    public ButtonPanel(ActionListener actionListener, ActionListener actionListener2, int n) {
        this(new ActionListener[]{actionListener, actionListener2}, new String[]{Messages.getString("Button.ok"), Messages.getString("Button.cancel")}, Prefs.BUTTON_SIZE, n);
    }

    public ButtonPanel(ActionListener[] actionListenerArray, String[] stringArray, Dimension dimension, int n) {
        if (actionListenerArray.length != stringArray.length) {
            throw new RuntimeException("listeners.length != labels.length");
        }
        this.setLayout(new BoxLayout(this, 0));
        this.buttons = new JButton[actionListenerArray.length];
        for (int i = 0; i < this.buttons.length; ++i) {
            JButton jButton = this.createButton(stringArray[i], dimension);
            jButton.addActionListener(actionListenerArray[i]);
            this.add(jButton);
            this.buttons[i] = jButton;
            if (i == this.buttons.length - 1) continue;
            this.add(Box.createHorizontalStrut(n));
        }
    }

    public JButton[] getButtons() {
        return this.buttons;
    }

    public JButton getFirstButton() {
        return this.buttons[0];
    }

    JButton createButton(String string, Dimension dimension) {
        JButton jButton = new JButton(string);
        jButton.setPreferredSize(dimension);
        jButton.setMaximumSize(dimension);
        return jButton;
    }
}

