/*
 * Decompiled with CFR 0.152.
 */
package com.ef_prime.rflow.ui.common.component;

import com.ef_prime.rflow.ui.common.component.CardLayoutPanel;
import com.ef_prime.rflow.ui.util.UIUtility;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ButtonGroup;
import javax.swing.JPanel;
import javax.swing.JRadioButton;

public class CardSwitchPanel
extends JPanel
implements ItemListener {
    private JPanel buttonPanel = new JPanel(new FlowLayout(0, 5, 0));
    private CardLayoutPanel cardPanel = new CardLayoutPanel();
    private ButtonGroup buttonGroup = new ButtonGroup();
    private List<String> titles = new ArrayList<String>();

    public CardSwitchPanel() {
        this.setLayout(new BorderLayout());
        this.add((Component)this.cardPanel, "Center");
        this.add((Component)this.buttonPanel, "North");
    }

    public void addPanel(Component component, String string) {
        this.titles.add(string);
        this.cardPanel.add(component, string);
        JRadioButton jRadioButton = new JRadioButton(string);
        jRadioButton.setSelected(this.buttonGroup.getButtonCount() == 0);
        jRadioButton.addItemListener(this);
        this.buttonPanel.add(jRadioButton);
        this.buttonGroup.add(jRadioButton);
    }

    public String getSelectedTitle() {
        int n = UIUtility.getSelectedButtonIndex(this.buttonGroup);
        if (n < 0 || n >= this.titles.size()) {
            return null;
        }
        return this.titles.get(n);
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getStateChange() == 1) {
            if (this.titles.size() == 0) {
                return;
            }
            String string = this.getSelectedTitle();
            if (string == null) {
                string = this.titles.get(0);
            }
            this.cardPanel.show(string);
        }
    }
}

