/*
 * Decompiled with CFR 0.152.
 */
package com.ef_prime.rflow.ui.common.component;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;

public class ChangeSupport {
    private Queue<ChangeListener> listeners;

    public void addChangeListener(ChangeListener changeListener) {
        if (this.listeners == null) {
            this.listeners = new ConcurrentLinkedQueue<ChangeListener>();
        }
        this.listeners.add(changeListener);
    }

    public void removeChangeListener(ChangeListener changeListener) {
        if (this.listeners == null) {
            return;
        }
        this.listeners.remove(changeListener);
        if (this.listeners.size() == 0) {
            this.listeners = null;
        }
    }

    public void fireStateChanged(Object object) {
        if (this.listeners == null) {
            return;
        }
        ChangeEvent changeEvent = new ChangeEvent(object);
        for (ChangeListener changeListener : this.listeners) {
            changeListener.stateChanged(changeEvent);
        }
    }

    public DocumentListener getDocumentListener(final Object object) {
        return new DocumentListener(){

            @Override
            public void removeUpdate(DocumentEvent documentEvent) {
                ChangeSupport.this.fireStateChanged(object);
            }

            @Override
            public void insertUpdate(DocumentEvent documentEvent) {
                ChangeSupport.this.fireStateChanged(object);
            }

            @Override
            public void changedUpdate(DocumentEvent documentEvent) {
                ChangeSupport.this.fireStateChanged(object);
            }
        };
    }

    public UndoableEditListener getUndoableEditListener(final Object object) {
        return new UndoableEditListener(){

            @Override
            public void undoableEditHappened(UndoableEditEvent undoableEditEvent) {
                ChangeSupport.this.fireStateChanged(object);
            }
        };
    }

    public ItemListener getItemListener(final Object object) {
        return new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                ChangeSupport.this.fireStateChanged(object);
            }
        };
    }

    public ActionListener getActionListener(final Object object) {
        return new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ChangeSupport.this.fireStateChanged(object);
            }
        };
    }

    public ChangeListener getChangeListener(final Object object) {
        return new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                ChangeSupport.this.fireStateChanged(object);
            }
        };
    }
}

