/*
 * Decompiled with CFR 0.152.
 */
package com.ef_prime.rflow.ui.common.component;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import javax.swing.JButton;

public class CloseButton
extends JButton {
    private int size;
    private Color color;
    private Color rollOverColor;

    public CloseButton(int n) {
        this(n, Color.LIGHT_GRAY, Color.GRAY);
    }

    public CloseButton(int n, Color color, Color color2) {
        this.size = n;
        this.color = color;
        this.rollOverColor = color2;
        this.setContentAreaFilled(false);
        Dimension dimension = new Dimension(n, n);
        this.setPreferredSize(dimension);
        this.setMaximumSize(dimension);
        this.setMinimumSize(dimension);
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        int n = 4;
        Graphics2D graphics2D = (Graphics2D)graphics.create();
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.setStroke(new BasicStroke(2.0f));
        graphics2D.setColor(this.getModel().isRollover() ? this.rollOverColor : this.color);
        graphics2D.drawLine(n, n, this.size - n, this.size - n);
        graphics2D.drawLine(n, this.size - n, this.size - n, n);
        graphics2D.dispose();
    }
}

