/*
 * Decompiled with CFR 0.152.
 */
package com.ef_prime.rflow.ui.common.component;

import com.ef_prime.rflow.core.feature.search.SearchContext;
import com.ef_prime.rflow.core.feature.search.SearchUtility;
import com.ef_prime.rflow.core.feature.search.TextSearchResult;
import com.ef_prime.rflow.resource.Messages;
import com.ef_prime.rflow.ui.base.Icons;
import com.ef_prime.rflow.ui.base.UIColor;
import com.ef_prime.rflow.ui.common.component.Actions;
import com.ef_prime.rflow.ui.common.component.CloseButton;
import com.ef_prime.rflow.ui.common.component.CodingTextArea;
import com.ef_prime.rflow.ui.common.component.DelayedExecutor;
import com.ef_prime.rflow.ui.common.component.DisplayableListener;
import com.ef_prime.rflow.ui.common.component.DocumentAdapter;
import com.ef_prime.rflow.ui.common.component.FloatLayout;
import com.ef_prime.rflow.ui.common.component.JTextFieldEx;
import com.ef_prime.rflow.ui.common.component.LoggableAction;
import com.ef_prime.rflow.ui.feature.search.RegexHelp;
import com.ef_prime.rflow.ui.util.UIUtility;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.HierarchyEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.apache.commons.collections.CollectionUtils;
import org.fife.ui.rsyntaxtextarea.DocumentRange;

public class CodingSearchBar
extends JPanel
implements ItemListener,
DocumentListener,
CaretListener {
    public static final String FIND_ACTION = "CodingSearchBar.FIND_ACTION";
    private CodingTextArea textArea;
    private JTextFieldEx searchField;
    private JTextFieldEx replaceField;
    private JCheckBox wholeWord;
    private JCheckBox matchCase;
    private JCheckBox regex;
    private DelayedExecutor highlightRefresher;
    private CodingActions actions = new CodingActions();
    private SearchContext context;
    private List<TextSearchResult> searchResults;
    private boolean adjusting;
    private boolean needRefresh;

    public CodingSearchBar(CodingTextArea codingTextArea) {
        this.textArea = codingTextArea;
        codingTextArea.setMarkAllHighlightColor(UIColor.MARK_ALL);
        this.searchField = new JTextFieldEx();
        this.searchField.setPreferredSize(new Dimension(200, this.searchField.getPreferredSize().height));
        this.searchField.setMaximumSize(this.searchField.getPreferredSize());
        this.searchField.getDocument().addDocumentListener(new SearchDocumentListener());
        this.searchField.setEmptyMessage(Messages.getString("View.FindReplace.find_prompt"));
        this.searchField.setClearButtonEnabled(true);
        new FindFieldActions().installActions(this.searchField, false, 0);
        this.actions.installActions(this.searchField, false, 0);
        if (codingTextArea.isEditable()) {
            this.replaceField = new JTextFieldEx();
            this.replaceField.setPreferredSize(new Dimension(200, this.searchField.getPreferredSize().height));
            this.replaceField.setMaximumSize(this.replaceField.getPreferredSize());
            this.replaceField.setEmptyMessage(Messages.getString("Action.replace"));
            this.replaceField.setClearButtonEnabled(true);
            new FindFieldActions().installActions(this.replaceField, false, 0);
            this.actions.installActions(this.replaceField, false, 0);
        }
        this.wholeWord = new JCheckBox(Messages.getString("View.FindReplace.whole_word"));
        this.wholeWord.addItemListener(this);
        this.matchCase = new JCheckBox(Messages.getString("View.FindReplace.match_case"));
        this.matchCase.addItemListener(this);
        this.regex = new JCheckBox(Messages.getString("View.FindReplace.regex"));
        this.regex.addItemListener(this);
        CloseButton closeButton = new CloseButton(14, Color.LIGHT_GRAY, Color.GRAY);
        closeButton.setFocusable(false);
        closeButton.addActionListener(this.actions.get(CodingActions.CloseFind.class));
        closeButton.setToolTipText(Messages.getString("Action.close"));
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add(closeButton);
        jPanel.setBorder(new EmptyBorder(4, 4, 4, 4));
        JToolBar jToolBar = new JToolBar();
        jToolBar.setLayout(new FloatLayout(0, 2));
        jToolBar.setFloatable(false);
        jToolBar.add(this.searchField);
        if (codingTextArea.isEditable()) {
            jToolBar.add(this.replaceField);
        }
        jToolBar.add(this.actions.get(CodingActions.FirstMatch.class)).setFocusable(false);
        jToolBar.add(this.actions.get(CodingActions.Previous.class)).setFocusable(false);
        jToolBar.add(this.actions.get(CodingActions.Next.class)).setFocusable(false);
        if (codingTextArea.isEditable()) {
            jToolBar.add(this.actions.get(CodingActions.ReplaceAndFind.class)).setFocusable(false);
            jToolBar.add(this.actions.get(CodingActions.ReplaceAll.class)).setFocusable(false);
        }
        jToolBar.add(this.wholeWord);
        jToolBar.add(this.matchCase);
        jToolBar.add(this.regex);
        jToolBar.add(new RegexHelp());
        this.setLayout(new BorderLayout());
        this.add((Component)jToolBar, "Center");
        this.add((Component)jPanel, "East");
        this.setVisible(false);
        this.actions.installActions((JComponent)((Object)codingTextArea), false, 0);
        this.highlightRefresher = new DelayedExecutor(new RefreshHighlight(), 250L);
        codingTextArea.addHierarchyListener(new TextAreaDisplayableListener());
    }

    private void refreshHighlight() {
        this.needRefresh = false;
        this.textArea.getDocument().removeDocumentListener((DocumentListener)this);
        this.textArea.removeCaretListener(this);
        ArrayList<DocumentRange> arrayList = new ArrayList<DocumentRange>();
        if (this.searchResults != null) {
            for (TextSearchResult textSearchResult : this.searchResults) {
                if (!textSearchResult.isEnabled()) continue;
                int n = textSearchResult.getOffset();
                int n2 = n + textSearchResult.getLength();
                arrayList.add(new DocumentRange(n, n2));
            }
        }
        this.textArea.clearMarkAllHighlights();
        this.textArea.markAll(arrayList);
        this.actions.refreshState();
        if (!arrayList.isEmpty()) {
            this.textArea.getDocument().addDocumentListener((DocumentListener)this);
            this.textArea.addCaretListener(this);
        }
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        this.highlightRefresher.requestAction();
    }

    @Override
    public void insertUpdate(DocumentEvent documentEvent) {
        this.documentChanged();
    }

    @Override
    public void removeUpdate(DocumentEvent documentEvent) {
        this.documentChanged();
    }

    @Override
    public void changedUpdate(DocumentEvent documentEvent) {
        this.documentChanged();
    }

    private void documentChanged() {
        if (!this.adjusting) {
            this.needRefresh = true;
        }
    }

    @Override
    public void caretUpdate(CaretEvent caretEvent) {
        this.actions.refreshState();
    }

    private class CodingActions
    extends Actions {
        public CodingActions() {
            this.put(CodingSearchBar.FIND_ACTION, new Find());
            this.put(new CloseFind());
            this.put(new Next());
            this.put(new Previous());
            this.put(new FirstMatch());
            this.put(new ReplaceAndFind());
            this.put(new ReplaceAll());
        }

        private void refreshState() {
            boolean bl = !CollectionUtils.isEmpty(CodingSearchBar.this.searchResults);
            this.get(Next.class).setEnabled(bl && SearchUtility.isNext((JTextArea)((Object)CodingSearchBar.this.textArea), CodingSearchBar.this.context, true, CodingSearchBar.this.searchResults));
            this.get(Previous.class).setEnabled(bl && SearchUtility.isNext((JTextArea)((Object)CodingSearchBar.this.textArea), CodingSearchBar.this.context, false, CodingSearchBar.this.searchResults));
            this.get(FirstMatch.class).setEnabled(bl);
            boolean bl2 = bl && SearchUtility.canReplace(CodingSearchBar.this.textArea, CodingSearchBar.this.context, CodingSearchBar.this.searchResults);
            this.get(ReplaceAndFind.class).setEnabled(bl2);
            this.get(ReplaceAll.class).setEnabled(bl);
        }

        private class Find
        extends LoggableAction {
            public Find() {
                this.putValue("Name", Messages.getString("Action.find"));
                this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(70, UIUtility.MENU_KEY_MASK));
                UIUtility.setShortDescription(this);
            }

            @Override
            public void action(ActionEvent actionEvent) {
                CodingSearchBar.this.setVisible(true);
                CodingSearchBar.this.searchField.requestFocusInWindow();
                String string = CodingSearchBar.this.textArea.getSelectedText();
                if (string != null && !string.isEmpty()) {
                    CodingSearchBar.this.searchField.setText(string);
                }
            }
        }

        private class CloseFind
        extends LoggableAction {
            public CloseFind() {
                this.putValue("Name", Messages.getString("Action.close"));
            }

            @Override
            public void action(ActionEvent actionEvent) {
                CodingSearchBar.this.setVisible(false);
                CodingSearchBar.this.textArea.requestFocusInWindow();
                CodingSearchBar.this.textArea.clearMarkAllHighlights();
                CodingSearchBar.this.textArea.getDocument().removeDocumentListener((DocumentListener)CodingSearchBar.this);
                CodingSearchBar.this.textArea.removeCaretListener(CodingSearchBar.this);
                CodingSearchBar.this.searchField.setText("");
                if (CodingSearchBar.this.replaceField != null) {
                    CodingSearchBar.this.replaceField.setText("");
                }
            }
        }

        private class Next
        extends FindAction {
            public Next() {
                this.putValue("Name", Messages.getString("Action.next_match"));
                this.putValue("SmallIcon", Icons.getIcon("16/resultset_next.png"));
                this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(114, 0));
                UIUtility.setShortDescription(this);
            }

            @Override
            protected void find(SearchContext searchContext) {
                SearchUtility.find((JTextArea)((Object)CodingSearchBar.this.textArea), searchContext, true, CodingSearchBar.this.searchResults);
            }
        }

        private class Previous
        extends FindAction {
            public Previous() {
                this.putValue("Name", Messages.getString("Action.previous_match"));
                this.putValue("SmallIcon", Icons.getIcon("16/resultset_previous.png"));
                this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(114, 64));
                UIUtility.setShortDescription(this);
            }

            @Override
            protected void find(SearchContext searchContext) {
                SearchUtility.find((JTextArea)((Object)CodingSearchBar.this.textArea), searchContext, false, CodingSearchBar.this.searchResults);
            }
        }

        private class FirstMatch
        extends FindAction {
            public FirstMatch() {
                this.putValue("Name", Messages.getString("Action.first_match"));
                this.putValue("SmallIcon", Icons.getIcon("16/resultset_first.png"));
                UIUtility.setShortDescription(this);
            }

            @Override
            protected void find(SearchContext searchContext) {
                SearchUtility.find((JTextArea)((Object)CodingSearchBar.this.textArea), searchContext, true, CodingSearchBar.this.searchResults, -1);
            }
        }

        private class ReplaceAndFind
        extends FindAction {
            public ReplaceAndFind() {
                this.putValue("Name", Messages.getString("Action.replace_and_find"));
                UIUtility.setShortDescription(this);
            }

            @Override
            protected void find(SearchContext searchContext) {
                boolean bl = SearchUtility.replace(CodingSearchBar.this.textArea, searchContext, CodingSearchBar.this.replaceField.getText(), CodingSearchBar.this.searchResults);
                if (bl) {
                    SearchUtility.find((JTextArea)((Object)CodingSearchBar.this.textArea), searchContext, true, CodingSearchBar.this.searchResults);
                }
                CodingSearchBar.this.refreshHighlight();
            }
        }

        private class ReplaceAll
        extends FindAction {
            public ReplaceAll() {
                this.putValue("Name", Messages.getString("Action.replace_all"));
                UIUtility.setShortDescription(this);
            }

            @Override
            protected void find(SearchContext searchContext) {
                SearchUtility.replaceAll(CodingSearchBar.this.textArea, searchContext, CodingSearchBar.this.replaceField.getText(), CodingSearchBar.this.searchResults);
                CodingSearchBar.this.refreshHighlight();
            }
        }

        private abstract class FindAction
        extends LoggableAction {
            private FindAction() {
            }

            @Override
            public void action(ActionEvent actionEvent) {
                if (CodingSearchBar.this.searchResults == null || CodingSearchBar.this.searchResults.isEmpty() || CodingSearchBar.this.context == null) {
                    return;
                }
                this.find(CodingSearchBar.this.context);
            }

            protected abstract void find(SearchContext var1);
        }
    }

    private class SearchDocumentListener
    extends DocumentAdapter {
        private SearchDocumentListener() {
        }

        @Override
        public void documentUpdate(DocumentEvent documentEvent) {
            CodingSearchBar.this.highlightRefresher.requestAction();
        }
    }

    private class FindFieldActions
    extends Actions {
        public FindFieldActions() {
            this.put(new Enter());
            this.put(new CloseFind());
        }

        private class Enter
        extends LoggableAction {
            public Enter() {
                this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(10, 0));
            }

            @Override
            public void action(ActionEvent actionEvent) {
                if (CodingSearchBar.this.needRefresh) {
                    CodingSearchBar.this.highlightRefresher.requestAction();
                } else {
                    CodingSearchBar.this.actions.doAction(CodingActions.Next.class);
                }
            }
        }

        private class CloseFind
        extends LoggableAction {
            public CloseFind() {
                this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(27, 0));
            }

            @Override
            public void action(ActionEvent actionEvent) {
                CodingSearchBar.this.actions.doAction(CodingActions.CloseFind.class);
            }
        }
    }

    private class RefreshHighlight
    implements Runnable {
        private RefreshHighlight() {
        }

        @Override
        public void run() {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    CodingSearchBar.this.context = null;
                    CodingSearchBar.this.searchResults = null;
                    String string = CodingSearchBar.this.searchField.getText();
                    if (string.isEmpty()) {
                        CodingSearchBar.this.refreshHighlight();
                        return;
                    }
                    CodingSearchBar.this.context = new SearchContext(string, CodingSearchBar.this.wholeWord.isSelected(), CodingSearchBar.this.matchCase.isSelected(), CodingSearchBar.this.regex.isSelected());
                    CodingSearchBar.this.searchResults = SearchUtility.searchRScript(CodingSearchBar.this.context, CodingSearchBar.this.textArea.getDocument());
                    CodingSearchBar.this.refreshHighlight();
                }
            });
        }
    }

    private class TextAreaDisplayableListener
    extends DisplayableListener {
        private TextAreaDisplayableListener() {
        }

        @Override
        protected void didBecomeUndisplayable(HierarchyEvent hierarchyEvent) {
            CodingSearchBar.this.textArea.clearMarkAllHighlights();
            CodingSearchBar.this.textArea.getDocument().removeDocumentListener((DocumentListener)CodingSearchBar.this);
            CodingSearchBar.this.textArea.removeHierarchyListener(this);
            CodingSearchBar.this.textArea.removeCaretListener(CodingSearchBar.this);
        }
    }
}

