/*
 * Decompiled with CFR 0.152.
 */
package com.ef_prime.rflow.ui.common.component;

import com.ef_prime.rflow.Rflow;
import com.ef_prime.rflow.core.base.Settings;
import com.ef_prime.rflow.core.common.keyvalue.Key;
import com.ef_prime.rflow.core.common.keyvalue.ValueChangeEvent;
import com.ef_prime.rflow.core.common.keyvalue.ValueChangeEventHandler;
import com.ef_prime.rflow.resource.Messages;
import com.ef_prime.rflow.ui.common.component.CodingTextArea;
import com.ef_prime.rflow.ui.common.component.CodingUtility;
import com.ef_prime.rflow.ui.common.component.DisplayableListener;
import com.ef_prime.rflow.ui.util.FontSupport;
import com.ef_prime.rflow.ui.util.UIUtility;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.FontMetrics;
import java.awt.LayoutManager;
import java.awt.event.HierarchyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;
import net.miginfocom.swing.MigLayout;

public class CodingStatusBar
extends JPanel
implements CaretListener {
    private static final Logger LOGGER = Logger.getLogger(CodingStatusBar.class.getName());
    private CodingTextArea textArea;
    private FontMetrics fontMetrics;
    private JLabel position;
    private JLabel lineWrap;
    private JLabel overwrite;
    private boolean isLineWrap;

    public CodingStatusBar(CodingTextArea codingTextArea) {
        this.textArea = codingTextArea;
        this.fontMetrics = codingTextArea.getFontMetrics(codingTextArea.getFont());
        this.position = new JLabel();
        this.lineWrap = new JLabel();
        this.lineWrap.addMouseListener(new LineWrapMouseHandler());
        this.lineWrap.setCursor(Cursor.getPredefinedCursor(12));
        this.overwrite = new JLabel();
        this.overwrite.addMouseListener(new OverwriteMouseHandler());
        this.overwrite.setCursor(Cursor.getPredefinedCursor(12));
        this.setLayout((LayoutManager)new MigLayout("insets 4, alignx right"));
        this.add((Component)this.position, "wmin 50");
        this.add((Component)new JSeparator(1), "growy");
        this.add(this.lineWrap);
        this.add((Component)new JSeparator(1), "growy");
        this.add(this.overwrite);
        codingTextArea.addCaretListener(this);
        this.addHierarchyListener(new DisplayableHandler());
        this.setLineWrap(Rflow.settings().getValue(codingTextArea.getLineWrapKey()));
        this.refreshOverwrite();
        this.refreshFont();
    }

    @Override
    public void caretUpdate(CaretEvent caretEvent) {
        int n = this.textArea.getCaretPosition();
        try {
            int[] nArray = CodingUtility.getRowAndColumn((PlainDocument)this.textArea.getDocument(), this.fontMetrics, n);
            this.position.setText(nArray[0] + 1 + ":" + (nArray[1] + 1));
        }
        catch (BadLocationException badLocationException) {
            LOGGER.log(Level.SEVERE, "Failed to set position text.", badLocationException);
        }
    }

    private void refreshFont() {
        this.position.setFont(FontSupport.getFont("SansSerif", (Key<Double>)Settings.BASIC_FONT_SIZE));
        this.lineWrap.setFont(FontSupport.getFont("SansSerif", (Key<Double>)Settings.BASIC_FONT_SIZE));
        this.overwrite.setFont(FontSupport.getFont("SansSerif", (Key<Double>)Settings.BASIC_FONT_SIZE));
    }

    private void setLineWrap(boolean bl) {
        this.isLineWrap = bl;
        this.lineWrap.setText(bl ? Messages.getString("CodingTextArea.line_wrap_on") : Messages.getString("CodingTextArea.line_wrap_off"));
        this.textArea.setLineWrap(bl);
        Rflow.settings().putValue(this.textArea.getLineWrapKey(), bl);
    }

    private void refreshOverwrite() {
        this.overwrite.setText(this.textArea.getTextMode() == 1 ? Messages.getString("CodingTextArea.overtype") : Messages.getString("CodingTextArea.insert"));
    }

    private class LineWrapMouseHandler
    extends MouseAdapter {
        private LineWrapMouseHandler() {
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            if (UIUtility.isLeftMouseButton(mouseEvent)) {
                CodingStatusBar.this.setLineWrap(!CodingStatusBar.this.isLineWrap);
            }
        }
    }

    private class OverwriteMouseHandler
    extends MouseAdapter {
        private OverwriteMouseHandler() {
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            if (UIUtility.isLeftMouseButton(mouseEvent)) {
                CodingStatusBar.this.textArea.setTextMode(CodingStatusBar.this.textArea.getTextMode() == 1 ? 0 : 1);
            }
        }
    }

    private class DisplayableHandler
    extends DisplayableListener {
        private SettingsListener settingsListener;
        private TextAreaPropertyListener textAreaPropertyListener;

        private DisplayableHandler() {
        }

        @Override
        protected void didBecomeDisplayable(HierarchyEvent hierarchyEvent) {
            if (this.settingsListener == null) {
                this.settingsListener = new SettingsListener();
                Rflow.settings().addEventHandler(this.settingsListener);
            }
            if (this.textAreaPropertyListener == null) {
                this.textAreaPropertyListener = new TextAreaPropertyListener();
                CodingStatusBar.this.textArea.addPropertyChangeListener("PROPERTY_TEXTMODE", this.textAreaPropertyListener);
            }
        }

        @Override
        protected void didBecomeUndisplayable(HierarchyEvent hierarchyEvent) {
            if (this.settingsListener != null) {
                Rflow.settings().removeEventHandler(this.settingsListener);
            }
            if (this.textAreaPropertyListener != null) {
                CodingStatusBar.this.textArea.removePropertyChangeListener(this.textAreaPropertyListener);
            }
        }
    }

    private class TextAreaPropertyListener
    implements PropertyChangeListener {
        private TextAreaPropertyListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            if (string.equals("PROPERTY_TEXTMODE")) {
                CodingStatusBar.this.refreshOverwrite();
            }
        }
    }

    private class SettingsListener
    implements ValueChangeEventHandler {
        private SettingsListener() {
        }

        @Override
        public void valueChanged(ValueChangeEvent valueChangeEvent) {
            if (Settings.BASIC_FONT_SIZE.equals(valueChangeEvent.getKey())) {
                CodingStatusBar.this.refreshFont();
            }
        }
    }
}

