/*
 * Decompiled with CFR 0.152.
 */
package com.ef_prime.rflow.ui.common.component;

import com.ef_prime.rflow.core.base.Settings;
import com.ef_prime.rflow.core.base.WorkingDirectory;
import com.ef_prime.rflow.core.common.keyvalue.Key;
import com.ef_prime.rflow.core.feature.history.FlowNodeFlavor;
import com.ef_prime.rflow.ui.app.r.object.RObjectFlavor;
import com.ef_prime.rflow.ui.base.MenuActionProvider;
import com.ef_prime.rflow.ui.base.UIColor;
import com.ef_prime.rflow.ui.common.component.Actions;
import com.ef_prime.rflow.ui.common.component.CodingTextAreaUI;
import com.ef_prime.rflow.ui.common.component.Flavors;
import com.ef_prime.rflow.ui.common.component.Highlight;
import com.ef_prime.rflow.ui.util.UIUtility;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.io.File;
import java.util.Deque;
import java.util.List;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.KeyStroke;
import javax.swing.TransferHandler;
import javax.swing.UIManager;
import javax.swing.plaf.TextUI;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.JTextComponent;
import javax.swing.text.Position;
import org.apache.commons.lang3.StringUtils;
import org.fife.ui.rsyntaxtextarea.RSyntaxDocument;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextArea;
import org.fife.ui.rsyntaxtextarea.RSyntaxUtilities;
import org.fife.ui.rsyntaxtextarea.Token;
import org.fife.ui.rtextarea.ConfigurableCaret;
import org.fife.ui.rtextarea.RTATextTransferHandler;
import org.fife.ui.rtextarea.RTextArea;
import org.fife.ui.rtextarea.RTextAreaBase;
import org.fife.ui.rtextarea.RTextAreaUI;
import org.fife.ui.rtextarea.RecordableTextAction;

public class CodingTextArea
extends RSyntaxTextArea
implements MenuActionProvider {
    private static final Logger LOGGER = Logger.getLogger(CodingTextArea.class.getName());
    public static final String PROPERTY_TEXTMODE = "PROPERTY_TEXTMODE";
    private static final Color CARET_TRACE_COLOR = new Color(50, 50, 50, 100);
    private boolean caretTrace;
    private boolean stopCaretScroll;
    private Color constantColor;
    private Deque<Highlight> highlights;
    private String emptyMessage;
    private Color emptyMessageColor = Color.GRAY;
    private String description;
    private Color descriptionColor = Color.GRAY;
    private FocusHandler focusHandler;
    private boolean keepEditingInTable;

    public CodingTextArea() {
        this(null);
    }

    public CodingTextArea(String string) {
        this.setMinimumSize(new Dimension(0, 0));
        this.setMargin(new Insets(0, 2, 0, 0));
        if (string != null && !string.isEmpty()) {
            this.setText(string);
            this.setCaretPosition(0);
            this.discardAllEdits();
        }
        this.focusHandler = new FocusHandler();
        this.addFocusListener(this.focusHandler);
        this.setTransferHandler((TransferHandler)this.createTransferHandler());
        this.setClearWhitespaceLinesEnabled(false);
        new CodingActions().installActions((JComponent)((Object)this), false, 0);
        this.getInputMap().put(KeyStroke.getKeyStroke(67, UIUtility.MENU_AND_SHIFT_KEY_MASK), "RSTA.ToggleCommentAction");
    }

    protected RTATextTransferHandler createTransferHandler() {
        return new CodingTransferHandler();
    }

    public RSyntaxDocument getDocument() {
        return (RSyntaxDocument)super.getDocument();
    }

    protected RTextAreaUI createRTextAreaUI() {
        return new CodingTextAreaUI((JComponent)((Object)this));
    }

    protected RTextAreaBase.RTAMouseListener createMouseListener() {
        return new CodingTextAreaMutableCaretEvent((RTextArea)this);
    }

    public void setCaret(Caret caret) {
        if (caret instanceof ConfigurableCaret) {
            super.setCaret(caret);
        }
    }

    public void setTextMode(int n) {
        int n2 = this.getTextMode();
        super.setTextMode(n);
        if (n != n2) {
            this.firePropertyChange(PROPERTY_TEXTMODE, n2, n);
        }
    }

    protected void processMouseEvent(MouseEvent mouseEvent) {
        mouseEvent = UIUtility.setPopupTrigger(mouseEvent);
        super.processMouseEvent(mouseEvent);
    }

    public boolean processKeyBinding(KeyStroke keyStroke, KeyEvent keyEvent, int n, boolean bl) {
        return super.processKeyBinding(keyStroke, keyEvent, n, bl);
    }

    public Color getForegroundForToken(Token token) {
        if (!this.isEnabled()) {
            return this.getDisabledTextColor();
        }
        if (this.getConstantColor() != null) {
            return this.getConstantColor();
        }
        return super.getForegroundForToken(token);
    }

    protected void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        this.paintEmptyMessage(graphics);
        this.paintDescription(graphics);
    }

    private void paintEmptyMessage(Graphics graphics) {
        Rectangle rectangle;
        if (this.getDocument().getLength() > 0 || StringUtils.isEmpty((CharSequence)this.emptyMessage)) {
            return;
        }
        TextUI textUI = this.getUI();
        try {
            rectangle = textUI.modelToView((JTextComponent)((Object)this), 0, Position.Bias.Backward);
        }
        catch (BadLocationException badLocationException) {
            LOGGER.log(Level.SEVERE, "Failed to get view bounds.", badLocationException);
            return;
        }
        FontMetrics fontMetrics = graphics.getFontMetrics();
        Color color = graphics.getColor();
        graphics.setColor(this.isEnabled() ? this.emptyMessageColor : this.getDisabledTextColor());
        UIUtility.drawString(graphics, this.emptyMessage, rectangle.x, rectangle.y + fontMetrics.getHeight() - fontMetrics.getDescent());
        graphics.setColor(color);
    }

    private void paintDescription(Graphics graphics) {
        Rectangle rectangle;
        if (this.description == null || this.description.isEmpty()) {
            return;
        }
        int n = this.getDocument().getLength();
        TextUI textUI = this.getUI();
        try {
            rectangle = textUI.modelToView((JTextComponent)((Object)this), n, Position.Bias.Backward);
        }
        catch (BadLocationException badLocationException) {
            LOGGER.log(Level.SEVERE, "Unexpected BadLocationException.", badLocationException);
            return;
        }
        int n2 = n == 0 ? 0 : 5;
        Color color = graphics.getColor();
        graphics.setColor(this.isEnabled() ? this.descriptionColor : this.getDisabledTextColor());
        UIUtility.drawStringCenterY(graphics, (Component)((Object)this), this.description, rectangle.x + rectangle.width + n2);
        graphics.setColor(color);
    }

    public void setCaretTrace(boolean bl) {
        this.caretTrace = bl;
    }

    public boolean isCaretTrace() {
        return this.caretTrace;
    }

    public void setStopCaretScroll(boolean bl) {
        this.stopCaretScroll = bl;
    }

    public boolean isStopCaretScroll() {
        return this.stopCaretScroll;
    }

    public void setConstantColor(Color color) {
        this.constantColor = color;
    }

    public Color getConstantColor() {
        return this.constantColor;
    }

    public void setUneditableBackgroundColor() {
        this.setBackground(UIColor.UNEDITABLE_BACKGROUND);
    }

    public void setEmptyMessage(String string) {
        this.emptyMessage = string;
        this.repaint();
    }

    public String getEmptyMessage() {
        return this.emptyMessage;
    }

    public void setEmptyMessageColor(Color color) {
        if (color == null) {
            color = Color.GRAY;
        }
        this.emptyMessageColor = color;
        this.repaint();
    }

    public Color getEmptyMessageColor() {
        return this.emptyMessageColor;
    }

    public void setDescription(String string) {
        this.description = string;
        this.revalidate();
        this.repaint();
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescriptionColor(Color color) {
        this.descriptionColor = color;
    }

    public Color getDescriptionColor() {
        return this.descriptionColor;
    }

    public void setWhitespacesVisible(boolean bl, String string) {
        this.setWhitespaceVisible(bl);
        this.setEOLMarkersVisible(bl);
        this.setNewline(string);
    }

    public void setKeepEditingInTable(boolean bl) {
        this.keepEditingInTable = bl;
    }

    public boolean isKeepEditingInTable() {
        return this.keepEditingInTable;
    }

    public void configureActiveCaret(Caret caret) {
        if (this.isEditable()) {
            caret.setBlinkRate(500);
            this.setCaretColor(Color.BLACK);
        } else {
            this.configureInactiveCaret(caret);
        }
    }

    public void configureInactiveCaret(Caret caret) {
        caret.setBlinkRate(0);
        this.setCaretColor(CARET_TRACE_COLOR);
    }

    public void setMarkOccurrenceAfterFocus(boolean bl) {
        this.focusHandler.markOccurrenceAfterFocus = bl;
    }

    public void setBracketMatchingOnFocus(boolean bl) {
        this.focusHandler.bracketMatching = bl;
    }

    public void setHighlightCurrentLineOnFocus(boolean bl) {
        this.focusHandler.highlightCurrentLine = bl;
    }

    public void clearHighlights() {
        if (this.highlights != null) {
            this.highlights.clear();
        }
    }

    public void addHighlight(Highlight highlight) {
        if (this.highlights == null) {
            this.highlights = new ConcurrentLinkedDeque<Highlight>();
        }
        this.highlights.add(highlight);
    }

    public Deque<Highlight> getHighlights() {
        return this.highlights;
    }

    public boolean isSelection() {
        return this.getSelectionStart() != this.getSelectionEnd();
    }

    protected Object getFindActionKey() {
        return null;
    }

    public Action getFindAction() {
        Action action = this.getActionMap().get("CodingSearchBar.FIND_ACTION");
        if (action != null) {
            return action;
        }
        if (this.getFindActionKey() != null) {
            return this.getActionMap().get(this.getFindActionKey());
        }
        return null;
    }

    public Key<Boolean> getLineWrapKey() {
        return Settings.EDITOR_LINE_WRAP;
    }

    protected void fileDropped(List<File> list) {
        if (list == null || list.isEmpty()) {
            return;
        }
        String string = list.stream().map(file -> {
            if ((file = WorkingDirectory.toAbstractPath(file)).getPath().isEmpty()) {
                file = WorkingDirectory.getWorkingDirectory();
            }
            return file.getPath();
        }).collect(Collectors.joining("\n"));
        try {
            this.getDocument().insertString(this.getCaretPosition(), string, null);
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
        this.requestFocusInWindow();
    }

    @Override
    public Action getAction(String string) {
        switch (string) {
            case "MENU_ACTION_COPY": {
                if (!this.isSelection()) break;
                return this.getActionMap().get("copy-to-clipboard");
            }
            case "MENU_ACTION_CUT": {
                if (!this.isSelection() || !this.isEditable()) break;
                return this.getActionMap().get("cut-to-clipboard");
            }
            case "MENU_ACTION_PASTE": {
                if (!this.isEditable()) break;
                return this.getActionMap().get("paste-from-clipboard");
            }
            case "MENU_ACTION_UNDO": {
                if (!this.canUndo()) break;
                return this.getActionMap().get("RTA.UndoAction");
            }
            case "MENU_ACTION_REDO": {
                if (!this.canRedo()) break;
                return this.getActionMap().get("RTA.RedoAction");
            }
            case "MENU_ACTION_FIND": {
                return this.getFindAction();
            }
        }
        return null;
    }

    private class FocusHandler
    implements FocusListener {
        private boolean markOccurrenceAfterFocus;
        private boolean bracketMatching;
        private boolean highlightCurrentLine;

        private FocusHandler() {
        }

        @Override
        public void focusGained(FocusEvent focusEvent) {
            if (this.markOccurrenceAfterFocus) {
                CodingTextArea.this.setMarkOccurrences(true);
            }
            if (this.bracketMatching) {
                CodingTextArea.this.setBracketMatchingEnabled(true);
            }
            if (this.highlightCurrentLine) {
                CodingTextArea.this.setHighlightCurrentLine(true);
            }
        }

        @Override
        public void focusLost(FocusEvent focusEvent) {
            if (this.bracketMatching) {
                CodingTextArea.this.setBracketMatchingEnabled(false);
            }
            if (this.highlightCurrentLine) {
                CodingTextArea.this.setHighlightCurrentLine(false);
            }
        }
    }

    private class CodingActions
    extends Actions {
        public CodingActions() {
            this.put("RSTA.ToggleCommentAction", (Action)((Object)new ToggleComment()));
        }

        private class ToggleComment
        extends RecordableTextAction {
            public ToggleComment() {
                super("RSTA.ToggleCommentAction");
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void actionPerformedImpl(ActionEvent actionEvent, RTextArea rTextArea) {
                if (!rTextArea.isEditable() || !rTextArea.isEnabled()) {
                    UIManager.getLookAndFeel().provideErrorFeedback((Component)rTextArea);
                    return;
                }
                RSyntaxDocument rSyntaxDocument = (RSyntaxDocument)rTextArea.getDocument();
                Element element = rSyntaxDocument.getDefaultRootElement();
                Caret caret = rTextArea.getCaret();
                int n = caret.getDot();
                int n2 = caret.getMark();
                int n3 = element.getElementIndex(n);
                int n4 = element.getElementIndex(n2);
                int n5 = Math.min(n3, n4);
                int n6 = Math.max(n3, n4);
                Token token = rSyntaxDocument.getTokenListForLine(n5);
                int n7 = token != null ? token.getLanguageIndex() : 0;
                String[] stringArray = rSyntaxDocument.getLineCommentStartAndEnd(n7);
                if (stringArray == null) {
                    UIManager.getLookAndFeel().provideErrorFeedback((Component)rTextArea);
                    return;
                }
                if (n5 != n6) {
                    Element element2 = element.getElement(n6);
                    if (Math.max(n, n2) == element2.getStartOffset()) {
                        --n6;
                    }
                }
                rTextArea.beginAtomicEdit();
                try {
                    Element element3;
                    int n8;
                    int n9 = 0;
                    for (n8 = n5; n8 <= n6; ++n8) {
                        element3 = element.getElement(n8);
                        int n10 = element3.getStartOffset();
                        String string = rSyntaxDocument.getText(n10, element3.getEndOffset() - n10 - 1);
                        String string2 = RSyntaxUtilities.getLeadingWhitespace((String)string);
                        n9 = n8 == n5 ? string2.length() : Math.min(n9, string2.length());
                    }
                    n8 = this.getDoAdd((Document)rSyntaxDocument, element, n5, n6, stringArray, n9) ? 1 : 0;
                    for (n3 = n5; n3 <= n6; ++n3) {
                        element3 = element.getElement(n3);
                        this.handleToggleComment(element3, (Document)rSyntaxDocument, stringArray, n8 != 0, n9);
                    }
                }
                catch (BadLocationException badLocationException) {
                    LOGGER.log(Level.WARNING, "Failed to toggle comment.", badLocationException);
                    UIManager.getLookAndFeel().provideErrorFeedback((Component)rTextArea);
                }
                finally {
                    rTextArea.endAtomicEdit();
                }
            }

            private boolean getDoAdd(Document document, Element element, int n, int n2, String[] stringArray, int n3) throws BadLocationException {
                String string = stringArray[0];
                String string2 = stringArray[1];
                for (int i = n; i <= n2; ++i) {
                    Element element2 = element.getElement(i);
                    int n4 = element2.getStartOffset();
                    String string3 = document.getText(n4, element2.getEndOffset() - n4 - 1);
                    if (string3.length() < n3 || (string3 = string3.substring(n3)).startsWith(string) && (string2 == null || string3.endsWith(string2))) continue;
                    return true;
                }
                return false;
            }

            private void handleToggleComment(Element element, Document document, String[] stringArray, boolean bl, int n) throws BadLocationException {
                int n2 = element.getStartOffset();
                int n3 = element.getEndOffset() - 1;
                String string = document.getText(n2, n3 - n2);
                if (bl) {
                    String string2 = stringArray[0] + " ";
                    document.insertString(n2 + n, string2, null);
                    if (stringArray[1] != null) {
                        document.insertString(n3 + string2.length(), stringArray[1], null);
                    }
                } else {
                    int n4 = stringArray[0].length();
                    if (string.charAt(n + 1) == ' ') {
                        ++n4;
                    }
                    document.remove(n2 + n, n4);
                    if (stringArray[1] != null) {
                        int n5 = stringArray[1].length();
                        document.remove(n3 - n4 - n5, n5);
                    }
                }
            }

            public String getMacroID() {
                return "RSTA.ToggleCommentAction";
            }
        }
    }

    protected class CodingTransferHandler
    extends RTATextTransferHandler {
        protected CodingTransferHandler() {
        }

        public boolean canImport(TransferHandler.TransferSupport transferSupport) {
            if (transferSupport.isDataFlavorSupported(FlowNodeFlavor.getInstance()) || transferSupport.isDataFlavorSupported(DataFlavor.javaFileListFlavor) || transferSupport.isDataFlavorSupported(RObjectFlavor.getInstance())) {
                transferSupport.setDropAction(1);
            }
            return super.canImport(transferSupport);
        }

        protected DataFlavor getImportFlavor(DataFlavor[] dataFlavorArray, JTextComponent jTextComponent) {
            DataFlavor dataFlavor = super.getImportFlavor(dataFlavorArray, jTextComponent);
            if (dataFlavor == null) {
                for (DataFlavor dataFlavor2 : dataFlavorArray) {
                    if (!dataFlavor2.equals(DataFlavor.javaFileListFlavor)) continue;
                    return dataFlavor2;
                }
            }
            return dataFlavor;
        }

        public boolean importData(JComponent jComponent, Transferable transferable) {
            if (transferable.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
                List<File> list = Flavors.getFiles(transferable);
                if (list == null) {
                    return true;
                }
                CodingTextArea.this.fileDropped(list);
                return true;
            }
            return super.importData(jComponent, transferable);
        }
    }

    protected class CodingTextAreaMutableCaretEvent
    extends RSyntaxTextArea.RSyntaxTextAreaMutableCaretEvent {
        protected CodingTextAreaMutableCaretEvent(RTextArea rTextArea) {
            super((RSyntaxTextArea)CodingTextArea.this, rTextArea);
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            if (UIUtility.isRightMouseButton(mouseEvent)) {
                this.showPopup(mouseEvent);
            }
        }
    }
}

