/*
 * Decompiled with CFR 0.152.
 */
package com.ef_prime.rflow.ui.common.component;

import com.ef_prime.rflow.ui.app.r.script.RCodingTextField;
import com.ef_prime.rflow.ui.app.r.script.RSyntaxFieldView;
import com.ef_prime.rflow.ui.common.component.CodingSyntaxView;
import com.ef_prime.rflow.ui.common.component.CodingTextArea;
import com.ef_prime.rflow.ui.common.component.CodingWrappedSyntaxView;
import com.ef_prime.rflow.ui.common.component.Highlight;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.util.Deque;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.KeyStroke;
import javax.swing.text.Caret;
import javax.swing.text.Element;
import javax.swing.text.View;
import org.fife.ui.rsyntaxtextarea.RSyntaxDocument;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextArea;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextAreaUI;
import org.fife.ui.rtextarea.ConfigurableCaret;
import org.fife.ui.rtextarea.RTextArea;

public class CodingTextAreaUI
extends RSyntaxTextAreaUI {
    public CodingTextAreaUI(JComponent jComponent) {
        super(jComponent);
    }

    public View create(Element element) {
        RTextArea rTextArea = this.getRTextArea();
        if (rTextArea instanceof RSyntaxTextArea) {
            RSyntaxTextArea rSyntaxTextArea = (RSyntaxTextArea)rTextArea;
            Object object = rSyntaxTextArea.getLineWrap() ? new CodingWrappedSyntaxView(element) : (rTextArea instanceof RCodingTextField ? new RSyntaxFieldView(element) : new CodingSyntaxView(element));
            return object;
        }
        return null;
    }

    protected Caret createCaret() {
        ConfigurableCaret configurableCaret = new ConfigurableCaret(){

            protected void adjustVisibility(Rectangle rectangle) {
                CodingTextArea codingTextArea;
                if (CodingTextAreaUI.this.textArea instanceof CodingTextArea && (codingTextArea = (CodingTextArea)CodingTextAreaUI.this.textArea).isStopCaretScroll()) {
                    return;
                }
                super.adjustVisibility(rectangle);
            }

            public void focusGained(FocusEvent focusEvent) {
                CodingTextArea codingTextArea;
                if (CodingTextAreaUI.this.textArea.isEnabled() && CodingTextAreaUI.this.textArea instanceof CodingTextArea && (codingTextArea = (CodingTextArea)CodingTextAreaUI.this.textArea).isCaretTrace()) {
                    codingTextArea.configureActiveCaret((Caret)((Object)this));
                    this.setVisible(true);
                }
                super.focusGained(focusEvent);
            }

            public void focusLost(FocusEvent focusEvent) {
                CodingTextArea codingTextArea;
                super.focusLost(focusEvent);
                if (CodingTextAreaUI.this.textArea.isEnabled() && CodingTextAreaUI.this.textArea instanceof CodingTextArea && (codingTextArea = (CodingTextArea)CodingTextAreaUI.this.textArea).isCaretTrace()) {
                    codingTextArea.configureInactiveCaret((Caret)((Object)this));
                    this.setVisible(true);
                }
            }
        };
        configurableCaret.setBlinkRate(500);
        return configurableCaret;
    }

    protected void paintLineHighlights(Graphics graphics) {
        Deque<Highlight> deque;
        if (this.textArea instanceof CodingTextArea && (deque = ((CodingTextArea)this.textArea).getHighlights()) != null) {
            Rectangle rectangle = this.textArea.getVisibleRect();
            for (Highlight highlight : deque) {
                highlight.paint(graphics, (CodingTextArea)this.textArea, rectangle);
            }
        }
        super.paintLineHighlights(graphics);
    }

    protected ActionMap createRTextAreaActionMap() {
        ActionMap actionMap = super.createRTextAreaActionMap();
        actionMap.put("CodingTextArea.Up", new Up(false));
        actionMap.put("CodingTextArea.UpSelection", new Up(true));
        actionMap.put("CodingTextArea.Down", new Down(false));
        actionMap.put("CodingTextArea.DownSelection", new Down(true));
        return actionMap;
    }

    protected InputMap getRTextAreaInputMap() {
        InputMap inputMap = super.getRTextAreaInputMap();
        inputMap.put(KeyStroke.getKeyStroke(38, 0), "CodingTextArea.Up");
        inputMap.put(KeyStroke.getKeyStroke(38, 64), "CodingTextArea.UpSelection");
        inputMap.put(KeyStroke.getKeyStroke(40, 0), "CodingTextArea.Down");
        inputMap.put(KeyStroke.getKeyStroke(40, 64), "CodingTextArea.DownSelection");
        return inputMap;
    }

    private static class Up
    extends AbstractAction {
        private boolean select;

        public Up(boolean bl) {
            this.select = bl;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            RSyntaxDocument rSyntaxDocument;
            Element element;
            Element element2;
            CodingTextArea codingTextArea = (CodingTextArea)actionEvent.getSource();
            int n = codingTextArea.getCaretPosition();
            String string = n >= (element2 = (element = (rSyntaxDocument = codingTextArea.getDocument()).getDefaultRootElement()).getElement(0)).getStartOffset() && n < element2.getEndOffset() ? (this.select ? "selection-begin-line" : "caret-begin-line") : (this.select ? "selection-up" : "caret-up");
            codingTextArea.getActionMap().get(string).actionPerformed(actionEvent);
        }
    }

    private static class Down
    extends AbstractAction {
        private boolean select;

        public Down(boolean bl) {
            this.select = bl;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            RSyntaxDocument rSyntaxDocument;
            Element element;
            Element element2;
            CodingTextArea codingTextArea = (CodingTextArea)actionEvent.getSource();
            int n = codingTextArea.getCaretPosition();
            String string = n >= (element2 = (element = (rSyntaxDocument = codingTextArea.getDocument()).getDefaultRootElement()).getElement(element.getElementCount() - 1)).getStartOffset() && n < element2.getEndOffset() ? (this.select ? "selection-end-line" : "caret-end-line") : (this.select ? "selection-down" : "caret-down");
            codingTextArea.getActionMap().get(string).actionPerformed(actionEvent);
        }
    }
}

