/*
 * Decompiled with CFR 0.152.
 */
package com.ef_prime.rflow.ui.common.component;

import com.ef_prime.rflow.ui.app.r.script.RCodingTextAreaUI;
import com.ef_prime.rflow.ui.common.component.ActionSupport;
import com.ef_prime.rflow.ui.common.component.CodingTextArea;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.util.Deque;
import java.util.concurrent.ConcurrentLinkedDeque;
import javax.swing.AbstractAction;
import javax.swing.BoundedRangeModel;
import javax.swing.DefaultBoundedRangeModel;
import javax.swing.JComponent;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.commons.lang3.StringUtils;
import org.fife.ui.rtextarea.RTextAreaUI;

public class CodingTextField
extends CodingTextArea
implements FocusListener,
ActionSupport {
    private Deque<ActionListener> listeners = new ConcurrentLinkedDeque<ActionListener>();
    private int maxRowCount = -1;
    private BoundedRangeModel visibility;

    public CodingTextField() {
        this("");
    }

    public CodingTextField(String string) {
        super(string);
        this.setFont(new Font("Monospaced", 0, 12));
        this.addFocusListener(this);
        this.getActionMap().put("enterPressed", new Enter());
        this.getActionMap().put("shiftTabPressed", new ShiftTab());
        this.getInputMap(0).put(KeyStroke.getKeyStroke(10, 0), "enterPressed");
        this.getInputMap(0).put(KeyStroke.getKeyStroke(9, 1), "shiftTabPressed");
        this.getInputMap(0).put(KeyStroke.getKeyStroke(40, 0), "none");
        this.getInputMap(0).put(KeyStroke.getKeyStroke(38, 0), "none");
        if (!this.allowTabCompletion()) {
            this.getActionMap().put("tabPressed", new Tab());
            this.getInputMap(0).put(KeyStroke.getKeyStroke(9, 0), "tabPressed");
        }
        this.setLineWrap(false);
        this.setMarkOccurrences(false);
        this.setHyperlinksEnabled(false);
        this.setHighlightCurrentLine(false);
        this.setUseFocusableTips(false);
    }

    protected boolean allowTabCompletion() {
        return false;
    }

    public void setMaxRowCount(int n) {
        this.maxRowCount = n;
    }

    public int getMaxRowCount() {
        return this.maxRowCount;
    }

    public BoundedRangeModel getVisibility() {
        if (this.visibility == null) {
            this.visibility = new DefaultBoundedRangeModel();
            this.visibility.addChangeListener(new ScrollRepainter());
        }
        return this.visibility;
    }

    public void scrollRectToVisible(Rectangle rectangle) {
        Insets insets = this.getInsets();
        int n = rectangle.x + this.getVisibility().getValue() - insets.left;
        int n2 = n + rectangle.width;
        if (n < this.visibility.getValue()) {
            this.visibility.setValue(n);
        } else if (n2 > this.visibility.getValue() + this.visibility.getExtent()) {
            this.visibility.setValue(n2 - this.visibility.getExtent());
        }
    }

    @Override
    public void addActionListener(ActionListener actionListener) {
        this.listeners.addFirst(actionListener);
    }

    @Override
    public void removeActionListener(ActionListener actionListener) {
        this.listeners.remove(actionListener);
    }

    public ActionListener[] getActionListeners() {
        return this.listeners.toArray(new ActionListener[0]);
    }

    public void fireActionPerformed() {
        ActionEvent actionEvent = new ActionEvent(this, 1001, "");
        for (ActionListener actionListener : this.listeners) {
            actionListener.actionPerformed(actionEvent);
        }
    }

    @Override
    public boolean processKeyBinding(KeyStroke keyStroke, KeyEvent keyEvent, int n, boolean bl) {
        return super.processKeyBinding(keyStroke, keyEvent, n, bl);
    }

    public Dimension getPreferredSize() {
        FontMetrics fontMetrics;
        Dimension dimension = super.getPreferredSize();
        dimension.width += 10;
        if (this.getDocument().getLength() <= 0 && !StringUtils.isEmpty((CharSequence)this.getEmptyMessage())) {
            fontMetrics = this.getFontMetrics(this.getFont());
            dimension.width += SwingUtilities.computeStringWidth(fontMetrics, this.getEmptyMessage());
        }
        if (this.getDescription() != null) {
            fontMetrics = this.getFontMetrics(this.getFont());
            dimension.width += SwingUtilities.computeStringWidth(fontMetrics, this.getDescription());
        }
        return dimension;
    }

    public Dimension getPreferredScrollableViewportSize() {
        if (this.maxRowCount <= 0) {
            return super.getPreferredScrollableViewportSize();
        }
        Insets insets = this.getInsets();
        int n = Math.max(1, this.maxRowCount);
        int n2 = Math.min(this.getPreferredSize().height, n * this.getRowHeight() + insets.top + insets.bottom);
        return new Dimension(this.getPreferredSize().width, n2);
    }

    protected void tabPressed() {
        this.transferFocus();
    }

    protected void shiftTabPressed() {
        this.transferFocusBackward();
    }

    @Override
    protected RTextAreaUI createRTextAreaUI() {
        return new RCodingTextAreaUI((JComponent)((Object)this));
    }

    @Override
    public void focusGained(FocusEvent focusEvent) {
        this.setBracketMatchingEnabled(true);
    }

    @Override
    public void focusLost(FocusEvent focusEvent) {
        this.setBracketMatchingEnabled(false);
    }

    private class Enter
    extends AbstractAction {
        private Enter() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            CodingTextField.this.fireActionPerformed();
        }
    }

    private class ShiftTab
    extends AbstractAction {
        private ShiftTab() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            CodingTextField.this.shiftTabPressed();
        }
    }

    private class Tab
    extends AbstractAction {
        private Tab() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            CodingTextField.this.tabPressed();
        }
    }

    private class ScrollRepainter
    implements ChangeListener {
        private ScrollRepainter() {
        }

        @Override
        public void stateChanged(ChangeEvent changeEvent) {
            CodingTextField.this.repaint();
        }
    }
}

