/*
 * Decompiled with CFR 0.152.
 */
package com.ef_prime.rflow.ui.common.component;

import java.awt.FontMetrics;
import java.util.ArrayDeque;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Element;
import javax.swing.text.PlainDocument;
import javax.swing.text.Segment;
import javax.swing.text.StyleConstants;
import org.fife.ui.rsyntaxtextarea.Token;
import org.fife.ui.rsyntaxtextarea.TokenImpl;

public class CodingUtility {
    public static Token copyTokenList(Token token) {
        TokenImpl tokenImpl;
        if (token == null) {
            return null;
        }
        TokenImpl tokenImpl2 = tokenImpl = new TokenImpl(token);
        for (Token token2 = token.getNextToken(); token2 != null; token2 = token2.getNextToken()) {
            TokenImpl tokenImpl3 = new TokenImpl(token2);
            tokenImpl2.setNextToken((Token)tokenImpl3);
            tokenImpl2 = tokenImpl3;
        }
        return tokenImpl;
    }

    public static Element findComposedText(Element element) {
        ArrayDeque<Element> arrayDeque = new ArrayDeque<Element>();
        arrayDeque.add(element);
        Element element2 = null;
        while (arrayDeque.size() > 0) {
            Element element3 = (Element)arrayDeque.pop();
            if (element3.isLeaf()) {
                AttributeSet attributeSet = element3.getAttributes();
                if (attributeSet == null || !attributeSet.isDefined(StyleConstants.ComposedTextAttribute)) continue;
                element2 = element3;
                break;
            }
            for (int i = element3.getElementCount() - 1; i >= 0; --i) {
                arrayDeque.addFirst(element3.getElement(i));
            }
        }
        return element2;
    }

    public static Token rebuildToken(Element element, Token token) {
        Token token2 = null;
        for (Token token3 = token; token3 != null; token3 = (TokenImpl)token3.getNextToken()) {
            if (token3.containsPosition(element.getStartOffset())) {
                int n;
                Token token4 = token3.getNextToken();
                for (n = token3.length(); token4 != null && token4.getType() != 0 && n < element.getEndOffset() - element.getStartOffset(); n += token4.length(), token4 = token4.getNextToken()) {
                }
                TokenImpl tokenImpl = new TokenImpl(token3);
                tokenImpl.textCount = element.getStartOffset() - tokenImpl.getOffset();
                TokenImpl tokenImpl2 = new TokenImpl(token3);
                tokenImpl2.setOffset(element.getStartOffset());
                tokenImpl2.textOffset = tokenImpl.getTextOffset() + tokenImpl.length();
                tokenImpl2.textCount = element.getEndOffset() - element.getStartOffset();
                tokenImpl2.setType(39);
                TokenImpl tokenImpl3 = new TokenImpl(token3);
                tokenImpl3.setOffset(tokenImpl2.getOffset() + tokenImpl2.length());
                tokenImpl3.textOffset = tokenImpl2.getTextOffset() + tokenImpl2.length();
                tokenImpl3.textCount = n - tokenImpl2.length() - tokenImpl.length();
                if (token2 != null) {
                    token2.setNextToken((Token)(tokenImpl.length() == 0 ? tokenImpl2 : tokenImpl));
                } else {
                    token = tokenImpl.length() == 0 ? tokenImpl2 : tokenImpl;
                }
                tokenImpl.setNextToken((Token)tokenImpl2);
                tokenImpl2.setNextToken((Token)(tokenImpl3.length() == 0 ? token4 : tokenImpl3));
                tokenImpl3.setNextToken(token4);
                break;
            }
            token2 = token3;
        }
        return token;
    }

    public static int[] getRowAndColumn(PlainDocument plainDocument, FontMetrics fontMetrics, int n) throws BadLocationException {
        Element element = plainDocument.getDefaultRootElement();
        int n2 = element.getElementIndex(n);
        Element element2 = element.getElement(n2);
        int n3 = element2.getStartOffset();
        Segment segment = new Segment();
        plainDocument.getText(n3, n - n3, segment);
        int n4 = CodingUtility.getTabSize(plainDocument);
        int n5 = fontMetrics.charWidth('a');
        int n6 = 0;
        for (int i = 0; i < segment.length(); ++i) {
            char c = segment.charAt(i);
            n6 = CodingUtility.getColumn(fontMetrics, n4, n6, n5, c);
        }
        return new int[]{n2, n6};
    }

    public static int columnToOffset(PlainDocument plainDocument, FontMetrics fontMetrics, int n, int n2) throws BadLocationException {
        if (n + n2 > plainDocument.getLength()) {
            return 0;
        }
        Segment segment = new Segment();
        plainDocument.getText(n, n2, segment);
        int n3 = CodingUtility.getTabSize(plainDocument);
        int n4 = 0;
        int n5 = fontMetrics.charWidth('a');
        for (int i = 0; i < segment.length(); ++i) {
            char c = segment.charAt(i);
            if ((n4 = CodingUtility.getColumn(fontMetrics, n3, n4, n5, c)) < n2) continue;
            return i;
        }
        return n2;
    }

    private static int getTabSize(PlainDocument plainDocument) {
        int n = 0;
        Object object = plainDocument.getProperty("tabSize");
        if (object instanceof Integer) {
            n = (Integer)object;
        }
        return n;
    }

    private static int getColumn(FontMetrics fontMetrics, int n, int n2, int n3, char c) {
        if (c == '\t') {
            n2 += n;
            n2 -= n2 % n;
        } else if (c < '\u0080') {
            ++n2;
        } else {
            int n4 = (int)Math.round((double)fontMetrics.charWidth(c) / (double)n3);
            n2 += n4;
        }
        return n2;
    }
}

