/*
 * Decompiled with CFR 0.152.
 */
package com.ef_prime.rflow.ui.common.component;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JLabel;

public class ColorMaskedIcon
extends ImageIcon {
    int width;
    int height;

    public ColorMaskedIcon(Icon icon, Color color, float f) {
        this.width = icon.getIconWidth();
        this.height = icon.getIconHeight();
        this.createMask(icon, color, f);
    }

    private void createMask(Icon icon, Color color, float f) {
        BufferedImage bufferedImage = new BufferedImage(this.getIconWidth(), this.getIconHeight(), 2);
        Graphics2D graphics2D = (Graphics2D)bufferedImage.getGraphics();
        icon.paintIcon(new JLabel(), graphics2D, 0, 0);
        graphics2D.setComposite(AlphaComposite.getInstance(10, f));
        graphics2D.setColor(color);
        graphics2D.fillRect(0, 0, bufferedImage.getWidth(), bufferedImage.getHeight());
        this.setImage(bufferedImage);
    }

    @Override
    public int getIconHeight() {
        return this.height;
    }

    @Override
    public int getIconWidth() {
        return this.width;
    }

    @Override
    public void paintIcon(Component component, Graphics graphics, int n, int n2) {
        graphics.drawImage(this.getImage(), n, n2, component);
    }
}

