/*
 * Decompiled with CFR 0.152.
 */
package com.ef_prime.rflow.ui.common.component;

import com.ef_prime.rflow.resource.Messages;
import com.ef_prime.rflow.ui.common.component.Actions;
import com.ef_prime.rflow.ui.common.component.LoggableAction;
import com.ef_prime.rflow.ui.common.component.ProgressPanel;
import com.ef_prime.rflow.ui.common.component.RowHeaderResizer;
import com.ef_prime.rflow.ui.common.table.TableDataTransferable;
import com.ef_prime.rflow.ui.util.UIUtility;
import java.awt.Color;
import java.awt.Component;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import javax.swing.BoundedRangeModel;
import javax.swing.DefaultBoundedRangeModel;
import javax.swing.JMenu;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JViewport;
import javax.swing.KeyStroke;
import javax.swing.ListSelectionModel;
import javax.swing.SwingWorker;
import javax.swing.ToolTipManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import org.apache.commons.lang3.ArrayUtils;
import org.pushingpixels.substance.api.ColorSchemeAssociationKind;
import org.pushingpixels.substance.api.ComponentState;
import org.pushingpixels.substance.api.SubstanceColorScheme;
import org.pushingpixels.substance.api.SubstanceLookAndFeel;
import org.pushingpixels.substance.api.renderers.SubstanceDefaultTableCellRenderer;
import org.pushingpixels.substance.internal.utils.SubstanceColorSchemeUtilities;
import org.pushingpixels.substance.internal.utils.SubstanceColorUtilities;

public class DataTable
extends JScrollPane {
    private static final String ACTION_COPY = "COPY";
    private static final String ACTION_COPY_WITH_COLNAME = "COPY_WITH_COLNAME";
    private static final String ACTION_COPY_WITH_ROWNAME = "COPY_WITH_ROWNAME";
    private static final String ACTION_COPY_WITH_COL_AND_ROW_NAMES = "COPY_WITH_COL_AND_ROW_NAMES";
    private static final String ACTION_SELECT_ALL = "SELECT_ALL";
    private static final String ACTION_COPY_COLUMN_NAMES = "COPY_COLUMN_NAMES";
    private static final String ACTION_COPY_ROW_NAMES = "COPY_ROW_NAMES";
    private JTable table = this.createTable();
    private JTable rowHeaderTable;
    private DataTableActions actions;

    public DataTable() {
        ListSelectionModel listSelectionModel;
        ListSelectionModel listSelectionModel2 = this.createListSelectionModel(true);
        if (listSelectionModel2 != null) {
            this.table.setSelectionModel(listSelectionModel2);
        }
        if ((listSelectionModel = this.createListSelectionModel(false)) != null) {
            this.table.getColumnModel().setSelectionModel(listSelectionModel);
        }
        ToolTipManager.sharedInstance().registerComponent(this.table);
        this.table.setAutoResizeMode(0);
        this.table.setCellSelectionEnabled(true);
        this.table.addMouseListener(new TableMouseHandler());
        this.table.setTableHeader(new DataTableHeader(this.table.getColumnModel()));
        this.table.getTableHeader().setReorderingAllowed(false);
        this.table.getTableHeader().addMouseListener(new HeaderMouseHandler());
        if (SubstanceLookAndFeel.isCurrentLookAndFeel()) {
            this.table.setDefaultRenderer(Timestamp.class, (TableCellRenderer)new SubstanceDefaultTableCellRenderer());
            this.table.setDefaultRenderer(Time.class, (TableCellRenderer)new SubstanceDefaultTableCellRenderer());
            this.table.putClientProperty("substancelaf.tableLeadingVerticalLine", Boolean.FALSE);
        } else {
            this.table.setDefaultRenderer(Timestamp.class, new DefaultTableCellRenderer());
            this.table.setDefaultRenderer(Time.class, new DefaultTableCellRenderer());
        }
        UIUtility.setAutoResizeSupport(this.table);
        this.rowHeaderTable = this.createRowHeaderTable();
        if (SubstanceLookAndFeel.isCurrentLookAndFeel()) {
            this.rowHeaderTable.putClientProperty("substancelaf.tableLeadingVerticalLine", Boolean.FALSE);
        }
        this.setViewportView(this.table);
        this.setRowHeaderView(this.rowHeaderTable);
        this.setCorner("UPPER_LEFT_CORNER", this.rowHeaderTable.getTableHeader());
        RowHeaderResizer.install(this);
        this.getRowHeader().addChangeListener(new RowHeaderChangeListener());
        this.addMouseListener(new ScrollPaneMouseHandler());
        this.actions = new DataTableActions();
        this.actions.installActions(this.table, false, 1);
        this.actions.installActions(this.rowHeaderTable, false, 1);
    }

    public JTable getTable() {
        return this.table;
    }

    public JTable getRowHeaderTable() {
        return this.rowHeaderTable;
    }

    public Actions getActions() {
        return this.actions;
    }

    private void copy(boolean bl, boolean bl2, boolean bl3) {
        int n;
        CopyWorker copyWorker = new CopyWorker(this.getTableModelForCopy(), bl, bl2, bl3);
        if (copyWorker.getElementCount() > 1000000L && (n = JOptionPane.showConfirmDialog(this, Messages.getString("Message.confirm_large_copy"), Messages.getString("Error.title.warning"), 2, 2)) != 0) {
            return;
        }
        ProgressPanel.runWithDialogHandleError(this, null, copyWorker, true, copyWorker.getRangeModel());
    }

    protected CopyTableModel getTableModelForCopy() {
        return new DefaultRowHeaderTableModel(this.table, this.rowHeaderTable);
    }

    public JMenu getCopyMenu() {
        JMenu jMenu = new JMenu(Messages.getString("Action.copy"));
        jMenu.add(this.actions.get(ACTION_COPY));
        jMenu.add(this.getCopyWithNameMenu());
        return jMenu;
    }

    public JMenu getCopyWithNameMenu() {
        JMenu jMenu = new JMenu(Messages.getString("Action.copy_with_names"));
        jMenu.add(this.actions.get(ACTION_COPY_WITH_COLNAME));
        jMenu.add(this.actions.get(ACTION_COPY_WITH_ROWNAME));
        jMenu.add(this.actions.get(ACTION_COPY_WITH_COL_AND_ROW_NAMES));
        return jMenu;
    }

    private static int getColumn(MouseEvent mouseEvent) {
        JTable jTable = (JTable)mouseEvent.getSource();
        return jTable.convertColumnIndexToModel(jTable.columnAtPoint(mouseEvent.getPoint()));
    }

    private static int getRow(MouseEvent mouseEvent) {
        JTable jTable = (JTable)mouseEvent.getSource();
        return jTable.convertRowIndexToModel(jTable.rowAtPoint(mouseEvent.getPoint()));
    }

    private static boolean isInsideTable(MouseEvent mouseEvent) {
        return DataTable.getColumn(mouseEvent) >= 0 && DataTable.getRow(mouseEvent) >= 0;
    }

    protected JTable createTable() {
        return new TableImpl();
    }

    protected RowHeaderTable createRowHeaderTable() {
        return new RowHeaderTable();
    }

    protected JPopupMenu createDefaultPopupMenu() {
        JPopupMenu jPopupMenu = new JPopupMenu();
        jPopupMenu.add(this.actions.get(ACTION_COPY));
        jPopupMenu.add(this.getCopyWithNameMenu());
        jPopupMenu.add(this.actions.get(ACTION_COPY_COLUMN_NAMES));
        jPopupMenu.add(this.actions.get(ACTION_COPY_ROW_NAMES));
        jPopupMenu.addSeparator();
        jPopupMenu.add(this.actions.get(ACTION_SELECT_ALL));
        return jPopupMenu;
    }

    protected JPopupMenu createTablePopupMenu() {
        return this.createDefaultPopupMenu();
    }

    protected JPopupMenu createBackgroundPopupMenu() {
        return null;
    }

    protected JPopupMenu createColumnHeaderPopupMenu() {
        return this.createDefaultPopupMenu();
    }

    protected JPopupMenu createRowHeaderPopupMenu() {
        return this.createDefaultPopupMenu();
    }

    protected boolean columnSelectionEnabled() {
        return true;
    }

    protected ListSelectionModel createListSelectionModel(boolean bl) {
        return null;
    }

    protected void selectAll() {
        this.getRowHeaderTable().clearSelection();
        this.getTable().requestFocusInWindow();
        this.getTable().setRowSelectionAllowed(true);
        this.getTable().setColumnSelectionAllowed(true);
        this.getTable().selectAll();
    }

    private class TableMouseHandler
    extends MouseAdapter {
        private TableMouseHandler() {
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            if (UIUtility.isLeftMouseButton(mouseEvent)) {
                if (DataTable.isInsideTable(mouseEvent)) {
                    DataTable.this.table.setColumnSelectionAllowed(true);
                    DataTable.this.table.setRowSelectionAllowed(true);
                    DataTable.this.rowHeaderTable.clearSelection();
                }
            } else if (UIUtility.isRightMouseButton(mouseEvent) && DataTable.isInsideTable(mouseEvent)) {
                JPopupMenu jPopupMenu;
                boolean bl = ArrayUtils.contains((int[])DataTable.this.table.getSelectedColumns(), (int)DataTable.getColumn(mouseEvent));
                boolean bl2 = ArrayUtils.contains((int[])DataTable.this.table.getSelectedRows(), (int)DataTable.getRow(mouseEvent));
                if (!bl && !bl2) {
                    DataTable.this.table.setColumnSelectionAllowed(true);
                    DataTable.this.table.setRowSelectionAllowed(true);
                    DataTable.this.rowHeaderTable.clearSelection();
                    DataTable.this.table.changeSelection(DataTable.getRow(mouseEvent), DataTable.getColumn(mouseEvent), false, false);
                }
                if ((jPopupMenu = DataTable.this.createTablePopupMenu()) != null) {
                    jPopupMenu.show(DataTable.this.table, mouseEvent.getPoint().x, mouseEvent.getPoint().y);
                }
            }
        }
    }

    private static class DataTableHeader
    extends JTableHeader {
        public DataTableHeader(TableColumnModel tableColumnModel) {
            super(tableColumnModel);
        }

        @Override
        public String getToolTipText(MouseEvent mouseEvent) {
            return UIUtility.getTableHeaderToolTip(mouseEvent);
        }
    }

    private class HeaderMouseHandler
    extends MouseAdapter {
        private HeaderMouseHandler() {
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            JPopupMenu jPopupMenu;
            if (mouseEvent.isConsumed()) {
                return;
            }
            JTableHeader jTableHeader = (JTableHeader)mouseEvent.getSource();
            int n = DataTable.this.table.convertColumnIndexToModel(jTableHeader.columnAtPoint(mouseEvent.getPoint()));
            if (n >= 0 && DataTable.this.columnSelectionEnabled()) {
                DataTable.this.table.setColumnSelectionAllowed(true);
                DataTable.this.table.setRowSelectionAllowed(false);
                int n2 = DataTable.this.table.getSelectedRow();
                if (n2 < 0) {
                    n2 = 0;
                }
                DataTable.this.rowHeaderTable.clearSelection();
                DataTable.this.table.requestFocusInWindow();
                if (!UIUtility.isRightMouseButton(mouseEvent) || !ArrayUtils.contains((int[])DataTable.this.table.getSelectedColumns(), (int)n)) {
                    DataTable.this.table.setAutoscrolls(false);
                    DataTable.this.table.changeSelection(n2, n, mouseEvent.isControlDown(), mouseEvent.isShiftDown());
                    DataTable.this.table.setAutoscrolls(true);
                }
            }
            if (UIUtility.isRightMouseButton(mouseEvent) && (jPopupMenu = DataTable.this.createColumnHeaderPopupMenu()) != null) {
                jPopupMenu.show(jTableHeader, mouseEvent.getPoint().x, mouseEvent.getPoint().y);
            }
        }
    }

    protected class RowHeaderTable
    extends JTable {
        private static final String ROW_SELECTION_ALLOWED = "rowSelectionAllowed";
        private TableCellRenderer renderer;

        public RowHeaderTable() {
            ListSelectionModel listSelectionModel;
            RowHeaderHandler rowHeaderHandler = new RowHeaderHandler();
            DataTable.this.table.getSelectionModel().addListSelectionListener(rowHeaderHandler);
            DataTable.this.table.addPropertyChangeListener(ROW_SELECTION_ALLOWED, rowHeaderHandler);
            this.renderer = new RowHeaderRenderer();
            ListSelectionModel listSelectionModel2 = DataTable.this.createListSelectionModel(true);
            if (listSelectionModel2 != null) {
                this.setSelectionModel(listSelectionModel2);
            }
            if ((listSelectionModel = DataTable.this.createListSelectionModel(false)) != null) {
                this.getColumnModel().setSelectionModel(listSelectionModel);
            }
            this.setRowSelectionAllowed(true);
            this.setRowHeight(DataTable.this.table.getRowHeight());
            this.setGridColor(DataTable.this.table.getGridColor());
            this.addMouseListener(rowHeaderHandler);
            this.getTableHeader().setReorderingAllowed(false);
            this.getSelectionModel().addListSelectionListener(rowHeaderHandler);
            UIUtility.setAutoResizeSupport(this);
            ToolTipManager.sharedInstance().registerComponent(this);
        }

        @Override
        public TableCellRenderer getCellRenderer(int n, int n2) {
            return this.renderer;
        }

        @Override
        public String getToolTipText(MouseEvent mouseEvent) {
            return UIUtility.getTableToolTip(mouseEvent);
        }

        protected void syncTableWithRowHeader(ListSelectionModel listSelectionModel) {
            if (listSelectionModel.isSelectionEmpty()) {
                return;
            }
            DataTable.this.table.clearSelection();
            DataTable.this.table.setRowSelectionAllowed(true);
            DataTable.this.table.setColumnSelectionAllowed(false);
            int n = listSelectionModel.getMinSelectionIndex();
            int n2 = listSelectionModel.getMaxSelectionIndex();
            for (int i = n; i <= n2; ++i) {
                if (!listSelectionModel.isSelectedIndex(i)) continue;
                DataTable.this.table.addRowSelectionInterval(i, i);
            }
        }

        private class RowHeaderHandler
        implements ListSelectionListener,
        MouseListener,
        PropertyChangeListener {
            private RowHeaderHandler() {
            }

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (listSelectionEvent.getSource() == DataTable.this.table.getSelectionModel()) {
                    RowHeaderTable.this.repaint();
                } else if (listSelectionEvent.getSource() == RowHeaderTable.this.getSelectionModel()) {
                    ListSelectionModel listSelectionModel = (ListSelectionModel)listSelectionEvent.getSource();
                    RowHeaderTable.this.syncTableWithRowHeader(listSelectionModel);
                }
            }

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
            }

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                int n = DataTable.getColumn(mouseEvent);
                int n2 = DataTable.getRow(mouseEvent);
                if (n == 0 && n2 >= 0 && UIUtility.isRightMouseButton(mouseEvent) && !ArrayUtils.contains((int[])DataTable.this.table.getSelectedRows(), (int)n2)) {
                    DataTable.this.rowHeaderTable.changeSelection(n2, n, mouseEvent.isControlDown(), mouseEvent.isShiftDown());
                }
                if (UIUtility.isRightMouseButton(mouseEvent)) {
                    if (!DataTable.isInsideTable(mouseEvent)) {
                        return;
                    }
                    JPopupMenu jPopupMenu = DataTable.this.createRowHeaderPopupMenu();
                    if (jPopupMenu != null) {
                        jPopupMenu.show((Component)mouseEvent.getSource(), mouseEvent.getPoint().x, mouseEvent.getPoint().y);
                    }
                }
            }

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
            }

            @Override
            public void mouseEntered(MouseEvent mouseEvent) {
            }

            @Override
            public void mouseExited(MouseEvent mouseEvent) {
            }

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (RowHeaderTable.ROW_SELECTION_ALLOWED.equals(propertyChangeEvent.getPropertyName())) {
                    DataTable.this.rowHeaderTable.repaint();
                }
            }
        }
    }

    private class RowHeaderChangeListener
    implements ChangeListener {
        private RowHeaderChangeListener() {
        }

        @Override
        public void stateChanged(ChangeEvent changeEvent) {
            JViewport jViewport = (JViewport)changeEvent.getSource();
            Point point = jViewport.getViewPosition();
            JViewport jViewport2 = DataTable.this.getViewport();
            Point point2 = jViewport2.getViewPosition();
            point2.y = point.y;
            jViewport2.setViewPosition(point2);
        }
    }

    private class ScrollPaneMouseHandler
    extends MouseAdapter {
        private ScrollPaneMouseHandler() {
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            JPopupMenu jPopupMenu;
            if (UIUtility.isRightMouseButton(mouseEvent) && (jPopupMenu = DataTable.this.createBackgroundPopupMenu()) != null) {
                jPopupMenu.show((Component)mouseEvent.getSource(), mouseEvent.getPoint().x, mouseEvent.getPoint().y);
            }
        }
    }

    private class DataTableActions
    extends Actions {
        public DataTableActions() {
            this.put(DataTable.ACTION_COPY, new Copy());
            this.put(DataTable.ACTION_COPY_WITH_COLNAME, new CopyWithColName());
            this.put(DataTable.ACTION_COPY_WITH_ROWNAME, new CopyWithRowName());
            this.put(DataTable.ACTION_COPY_WITH_COL_AND_ROW_NAMES, new CopyWithColAndRowName());
            this.put(DataTable.ACTION_SELECT_ALL, new SelectAll());
            this.put(DataTable.ACTION_COPY_COLUMN_NAMES, new CopyColNames());
            this.put(DataTable.ACTION_COPY_ROW_NAMES, new CopyRowNames());
        }

        private class Copy
        extends LoggableAction {
            public Copy() {
                this.putValue("Name", Messages.getString("Action.copy"));
                this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(67, UIUtility.MENU_KEY_MASK));
            }

            @Override
            public void action(ActionEvent actionEvent) {
                DataTable.this.copy(true, false, false);
            }
        }

        private class CopyWithColName
        extends LoggableAction {
            public CopyWithColName() {
                this.putValue("Name", Messages.getString("Action.copy_with_names_column"));
                this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(67, UIUtility.MENU_KEY_MASK | 1));
            }

            @Override
            public void action(ActionEvent actionEvent) {
                DataTable.this.copy(true, true, false);
            }
        }

        private class CopyWithRowName
        extends LoggableAction {
            public CopyWithRowName() {
                this.putValue("Name", Messages.getString("Action.copy_with_names_row"));
            }

            @Override
            public void action(ActionEvent actionEvent) {
                DataTable.this.copy(true, false, true);
            }
        }

        private class CopyWithColAndRowName
        extends LoggableAction {
            public CopyWithColAndRowName() {
                this.putValue("Name", Messages.getString("Action.copy_with_names_column_and_row"));
            }

            @Override
            public void action(ActionEvent actionEvent) {
                DataTable.this.copy(true, true, true);
            }
        }

        private class SelectAll
        extends LoggableAction {
            public SelectAll() {
                this.putValue("Name", Messages.getString("Action.select_all"));
                this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(65, UIUtility.MENU_KEY_MASK));
            }

            @Override
            public void action(ActionEvent actionEvent) {
                DataTable.this.selectAll();
            }
        }

        private class CopyColNames
        extends LoggableAction {
            public CopyColNames() {
                this.putValue("Name", Messages.getString("Action.copy_column_names"));
            }

            @Override
            public void action(ActionEvent actionEvent) {
                DataTable.this.copy(false, true, false);
            }
        }

        private class CopyRowNames
        extends LoggableAction {
            public CopyRowNames() {
                this.putValue("Name", Messages.getString("Action.copy_row_names"));
            }

            @Override
            public void action(ActionEvent actionEvent) {
                DataTable.this.copy(false, false, true);
            }
        }
    }

    private class CopyWorker
    extends SwingWorker<List<List<String>>, Void> {
        private CopyTableModel model;
        private boolean data;
        private boolean colName;
        private boolean rowName;

        public CopyWorker(CopyTableModel copyTableModel, boolean bl, boolean bl2, boolean bl3) {
            this.model = copyTableModel;
            this.data = bl;
            this.colName = bl2;
            this.rowName = bl3;
        }

        public BoundedRangeModel getRangeModel() {
            return new DefaultBoundedRangeModel(0, 0, 0, 100);
        }

        public long getElementCount() {
            if (this.data) {
                return (long)this.model.getColumnCount() * (long)this.model.getRowCount();
            }
            if (this.colName) {
                return this.model.getColumnCount();
            }
            if (this.rowName) {
                return this.model.getRowCount();
            }
            return 0L;
        }

        @Override
        protected List<List<String>> doInBackground() throws Exception {
            this.firePropertyChange("message", "", Messages.getString("Message.copying") + "...");
            if (this.data) {
                return this.copy(this.colName, this.rowName);
            }
            if (this.colName) {
                return this.copyColumnNames();
            }
            if (this.rowName) {
                return this.copyRowNames();
            }
            return null;
        }

        @Override
        protected void done() {
            if (this.isCancelled()) {
                return;
            }
            List list = null;
            try {
                list = (List)this.get();
            }
            catch (InterruptedException | ExecutionException exception) {
                return;
            }
            if (list != null) {
                Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
                clipboard.setContents(new TableDataTransferable(list), null);
            }
        }

        private void progress(long l, long l2) {
            this.setProgress((int)((double)l / (double)l2 * 100.0));
        }

        public List<List<String>> copy(boolean bl, boolean bl2) throws Exception {
            int n = this.model.getRowCount();
            int n2 = this.model.getColumnCount();
            long l = n + (bl ? 1 : 0);
            long l2 = n2 + (bl2 ? 1 : 0);
            long l3 = l * l2;
            long l4 = 0L;
            ArrayList<List<String>> arrayList = new ArrayList<List<String>>((int)l);
            if (bl) {
                ArrayList<String> arrayList2 = new ArrayList<String>(n2 + 1);
                if (bl2) {
                    arrayList2.add(this.model.getRowheaderColumnName());
                    this.progress(++l4, l3);
                    if (Thread.interrupted()) {
                        return null;
                    }
                }
                for (int i = 0; i < n2; ++i) {
                    arrayList2.add(this.model.getColumnName(i));
                    this.progress(++l4, l3);
                    if (!Thread.interrupted()) continue;
                    return null;
                }
                arrayList.add(arrayList2);
            }
            for (int i = 0; i < n; ++i) {
                ArrayList<String> arrayList3 = new ArrayList<String>(n2 + 1);
                if (bl2) {
                    arrayList3.add(this.model.getRowHeaderValue(i));
                    this.progress(++l4, l3);
                    if (Thread.interrupted()) {
                        return null;
                    }
                }
                for (int j = 0; j < n2; ++j) {
                    arrayList3.add(this.model.getValue(i, j));
                    this.progress(++l4, l3);
                    if (!Thread.interrupted()) continue;
                    return null;
                }
                arrayList.add(arrayList3);
            }
            return arrayList;
        }

        public List<List<String>> copyColumnNames() throws Exception {
            int n = this.model.getColumnCount();
            ArrayList<List<String>> arrayList = new ArrayList<List<String>>(1);
            ArrayList<String> arrayList2 = new ArrayList<String>(n);
            int n2 = 0;
            for (int i = 0; i < n; ++i) {
                arrayList2.add(this.model.getColumnName(i));
                this.progress(++n2, n);
                if (!Thread.interrupted()) continue;
                return null;
            }
            arrayList.add(arrayList2);
            return arrayList;
        }

        public List<List<String>> copyRowNames() throws Exception {
            int n = this.model.getRowCount();
            ArrayList<List<String>> arrayList = new ArrayList<List<String>>(n);
            int n2 = 0;
            for (int i = 0; i < n; ++i) {
                ArrayList<String> arrayList2 = new ArrayList<String>(1);
                arrayList2.add(this.model.getRowHeaderValue(i));
                arrayList.add(arrayList2);
                this.progress(++n2, n);
                if (!Thread.interrupted()) continue;
                return null;
            }
            return arrayList;
        }
    }

    public static interface CopyTableModel {
        public String getRowheaderColumnName() throws Exception;

        public String getColumnName(int var1) throws Exception;

        public String getValue(int var1, int var2) throws Exception;

        public String getRowHeaderValue(int var1) throws Exception;

        public int getRowCount();

        public int getColumnCount();

        default public String stringValue(Object object) {
            return object == null ? "" : object.toString();
        }
    }

    private static class DefaultRowHeaderTableModel
    implements CopyTableModel {
        private TableModel model;
        private TableModel rowHeaderModel;
        private int[] rows;
        private int[] cols;

        public DefaultRowHeaderTableModel(JTable jTable, JTable jTable2) {
            this.model = jTable.getModel();
            this.rowHeaderModel = jTable2.getModel();
            this.rows = jTable.getRowSelectionAllowed() ? jTable.getSelectedRows() : new int[]{};
            this.cols = jTable.getColumnSelectionAllowed() ? jTable.getSelectedColumns() : new int[]{};
        }

        @Override
        public int getRowCount() {
            return this.rows.length == 0 ? this.model.getRowCount() : this.rows.length;
        }

        @Override
        public int getColumnCount() {
            return this.cols.length == 0 ? this.model.getColumnCount() : this.cols.length;
        }

        @Override
        public String getColumnName(int n) {
            if (this.cols.length > 0) {
                n = this.cols[n];
            }
            return this.model.getColumnName(n);
        }

        @Override
        public String getValue(int n, int n2) throws Exception {
            if (this.rows.length > 0) {
                n = this.rows[n];
            }
            if (this.cols.length > 0) {
                n2 = this.cols[n2];
            }
            return this.stringValue(this.model.getValueAt(n, n2));
        }

        @Override
        public String getRowheaderColumnName() throws Exception {
            return this.rowHeaderModel.getColumnName(0);
        }

        @Override
        public String getRowHeaderValue(int n) throws Exception {
            if (this.rows.length > 0) {
                n = this.rows[n];
            }
            return this.stringValue(this.rowHeaderModel.getValueAt(n, 0));
        }
    }

    protected static class TableImpl
    extends JTable {
        @Override
        public String getToolTipText(MouseEvent mouseEvent) {
            return UIUtility.getTableToolTip(mouseEvent);
        }
    }

    private class RowHeaderRenderer
    extends DefaultTableCellRenderer {
        private final Color background = new Color(240, 240, 240);
        private Color selectedBackground = new Color(200, 200, 200);

        public RowHeaderRenderer() {
            this.setHorizontalAlignment(0);
            SubstanceColorScheme substanceColorScheme = SubstanceColorSchemeUtilities.getColorScheme((Component)DataTable.this.table.getTableHeader(), (ColorSchemeAssociationKind)ColorSchemeAssociationKind.HIGHLIGHT, (ComponentState)ComponentState.SELECTED);
            this.selectedBackground = SubstanceColorUtilities.getTopShineColor((SubstanceColorScheme)substanceColorScheme);
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            boolean bl3 = DataTable.this.getTable().getRowSelectionAllowed() && DataTable.this.getTable().getSelectionModel().isSelectedIndex(n);
            this.setBackground(bl3 ? this.selectedBackground : this.background);
            this.setToolTipText(this.getText());
            return this;
        }

        @Override
        public Color getForeground() {
            return Color.BLACK;
        }
    }
}

