/*
 * Decompiled with CFR 0.152.
 */
package com.ef_prime.rflow.ui.common.component;

import com.ef_prime.rflow.core.common.util.ThreadUtility;

public class DelayedExecutor {
    private Runnable action;
    private long waitTime;
    private DelayedRun delayedRun;

    public DelayedExecutor(Runnable runnable, long l) {
        this.action = runnable;
        this.waitTime = l;
    }

    public void requestAction() {
        this.requestAction(false);
    }

    public void requestAction(boolean bl) {
        if (this.delayedRun == null || !this.delayedRun.alive()) {
            if (bl) {
                this.action.run();
            } else {
                this.delayedRun = new DelayedRun();
                ThreadUtility.execute(this.delayedRun);
            }
        } else if (bl) {
            this.delayedRun.kill();
            this.action.run();
        } else {
            this.delayedRun.reset();
        }
    }

    public void fireWaitingActionSync() {
        if (this.delayedRun != null && this.delayedRun.alive()) {
            this.delayedRun.kill();
            this.action.run();
        }
    }

    public void cancel() {
        if (this.delayedRun != null && this.delayedRun.alive()) {
            this.delayedRun.kill();
        }
    }

    private class DelayedRun
    implements Runnable {
        private boolean alive = true;
        private boolean waitAgain = false;

        public synchronized void reset() {
            this.waitAgain = true;
            this.notifyAll();
        }

        public synchronized void kill() {
            this.waitAgain = true;
            this.alive = false;
            this.notifyAll();
        }

        public synchronized boolean alive() {
            return this.alive;
        }

        @Override
        public void run() {
            while (this.alive) {
                if (!this.doWait()) continue;
                DelayedExecutor.this.action.run();
            }
        }

        private synchronized boolean doWait() {
            try {
                this.wait(DelayedExecutor.this.waitTime);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (this.waitAgain) {
                this.waitAgain = false;
                return false;
            }
            this.alive = false;
            return true;
        }
    }
}

