/*
 * Decompiled with CFR 0.152.
 */
package com.ef_prime.rflow.ui.common.component;

import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.FlavorMap;
import java.awt.datatransfer.SystemFlavorMap;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.io.InputStream;

public class EmfSelection
implements Transferable,
ClipboardOwner {
    public static final DataFlavor EMF_FLAVOR = new DataFlavor("image/x-emf", "emf");
    protected InputStream data;

    public static void installEmfFlavor() {
        FlavorMap flavorMap = SystemFlavorMap.getDefaultFlavorMap();
        if (flavorMap instanceof SystemFlavorMap) {
            ((SystemFlavorMap)flavorMap).setNativesForFlavor(EMF_FLAVOR, new String[]{"ENHMETAFILE"});
        }
    }

    public EmfSelection(InputStream inputStream) {
        this.data = inputStream;
    }

    @Override
    public void lostOwnership(Clipboard clipboard, Transferable transferable) {
        try {
            this.data.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.data = null;
    }

    @Override
    public DataFlavor[] getTransferDataFlavors() {
        return new DataFlavor[]{EMF_FLAVOR};
    }

    @Override
    public boolean isDataFlavorSupported(DataFlavor dataFlavor) {
        return EMF_FLAVOR.equals(dataFlavor);
    }

    @Override
    public Object getTransferData(DataFlavor dataFlavor) throws UnsupportedFlavorException, IOException {
        if (this.isDataFlavorSupported(dataFlavor)) {
            return this.data;
        }
        throw new UnsupportedFlavorException(dataFlavor);
    }
}

