/*
 * Decompiled with CFR 0.152.
 */
package com.ef_prime.rflow.ui.common.component;

import com.ef_prime.rflow.resource.Messages;
import com.ef_prime.rflow.ui.common.component.RflowOptionPane;
import com.ef_prime.rflow.ui.util.UIUtility;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.PrintWriter;
import java.io.StringWriter;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.text.JTextComponent;
import net.miginfocom.layout.AC;
import net.miginfocom.layout.CC;
import net.miginfocom.layout.LC;
import net.miginfocom.swing.MigLayout;

public class ErrorPanel
extends JPanel
implements ActionListener {
    private JButton detailButton;
    private JButton copyButton;
    private JScrollPane stackTracePane;

    public ErrorPanel(String string, Throwable throwable, boolean bl) {
        if (string == null) {
            string = "";
        }
        JLabel jLabel = new JLabel(string);
        this.detailButton = new JButton();
        this.detailButton.addActionListener(this);
        this.copyButton = new JButton(Messages.getString("Action.copy"));
        this.copyButton.addActionListener(this);
        StringWriter stringWriter = new StringWriter();
        try (Object object = new PrintWriter(stringWriter);){
            throwable.printStackTrace((PrintWriter)object);
        }
        object = new JTextArea();
        ((JTextComponent)object).setText(stringWriter.toString());
        ((JTextComponent)object).setEditable(false);
        ((JTextComponent)object).setCaretPosition(0);
        this.stackTracePane = new JScrollPane((Component)object);
        this.setLayout((LayoutManager)new MigLayout(new LC().insetsAll("10").fill().hideMode(2), new AC(), new AC().gap().gap().gap().grow()));
        this.add((Component)jLabel, new CC().wrap());
        if (bl) {
            this.add((Component)new JLabel(Messages.getString("Error.error_message") + ": " + throwable.getMessage()), new CC().gapTop("10").wrap());
        }
        this.add((Component)this.detailButton, new CC().wrap());
        this.add((Component)this.stackTracePane, new CC().grow().width("600").height("200").wrap());
        this.add((Component)this.copyButton, new CC().alignX("right"));
        this.refreshDetail(false);
    }

    public static void showErrorDialog(Component component, String string, String string2, Throwable throwable, boolean bl) {
        if (string == null) {
            string = Messages.getString("Error.title.error");
        }
        ErrorPanel errorPanel = new ErrorPanel(string2, throwable, bl);
        JOptionPane jOptionPane = new JOptionPane(errorPanel, 0);
        RflowOptionPane.showDialog(jOptionPane, component, string, true);
    }

    private void refreshDetail(boolean bl) {
        if (!bl) {
            this.detailButton.setText(Messages.getString("Message.detail") + " >>");
            this.stackTracePane.setVisible(false);
            this.copyButton.setVisible(false);
        } else {
            this.detailButton.setText(Messages.getString("Message.detail") + " <<");
            this.stackTracePane.setVisible(true);
            this.copyButton.setVisible(true);
        }
        Window window = SwingUtilities.windowForComponent(this.stackTracePane);
        if (window != null) {
            window.pack();
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.detailButton) {
            this.refreshDetail(!this.stackTracePane.isVisible());
        } else if (actionEvent.getSource() == this.copyButton) {
            String string = ((JTextArea)this.stackTracePane.getViewport().getView()).getText();
            UIUtility.copyToClipboard(string);
        }
    }
}

