/*
 * Decompiled with CFR 0.152.
 */
package com.ef_prime.rflow.ui.common.component;

import com.ef_prime.rflow.core.app.file.FileUtility;
import com.ef_prime.rflow.resource.Messages;
import com.ef_prime.rflow.ui.util.UIUtility;
import java.awt.Component;
import java.awt.Window;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import javax.swing.JDialog;
import javax.swing.JOptionPane;

public class FileControl {
    private final int MAX_PATH;
    public static final int OVERWRITE_YES = 0;
    public static final int OVERWRITE_NO = 1;
    public static final int OVERWRITE_ASK = 2;
    private static final String COPY_SUFFIX = "_copy";
    private static final String COPY_PREFIX_REG0 = "(.*)(_copy)(\\.[^.]*)?$";
    private static final String COPY_PREFIX_REG = "(.*_copy)(\\d*)(\\.[^.]*)?$";
    private static final int DIR_OVERWRITE_OPTION_YES = 0;
    private static final int DIR_OVERWRITE_OPTION_YES_TO_ALL = 1;
    private static final int DIR_OVERWRITE_OPTION_NO = 2;
    private static final int DIR_OVERWRITE_OPTION_CANCEL = 3;
    private static final String[] dirOverwriteOptions = new String[]{Messages.getString("Button.yes"), Messages.getString("Button.yes_to_all"), Messages.getString("Button.no"), Messages.getString("Button.cancel")};
    private Window parent;
    public static final int PROCESS_OVERWRITE_SUCCESS = 0;
    public static final int PROCESS_OVERWRITE_SKIPPED = 1;
    public static final int PROCESS_OVERWRITE_CANCELED = 2;

    public FileControl(int n, Window window) {
        this.MAX_PATH = n;
        this.parent = window;
    }

    public boolean delete_file(File file) {
        return this.delete_file(file, true);
    }

    public boolean delete_file(File file, boolean bl) {
        if (!this.checkFileExists(file, bl)) {
            return false;
        }
        File file2 = null;
        if (file.isFile()) {
            if (file.delete()) {
                return true;
            }
            file2 = file;
        } else if (file.isDirectory()) {
            for (File file3 : file.listFiles()) {
                if (this.delete_file(file3, bl)) continue;
                file2 = file3;
                break;
            }
            if (file2 == null) {
                if (file.delete()) {
                    return true;
                }
                file2 = file;
            }
        }
        if (bl) {
            UIUtility.showErrorDialog((Component)this.parent, Messages.getString("Error.file.delete") + ": " + file2.getPath());
        }
        return false;
    }

    public void rename(File file, File file2) {
        if (!file.renameTo(file2)) {
            UIUtility.showErrorDialog((Component)this.parent, Messages.getString("Error.file.rename") + ": " + file.getPath());
        }
    }

    public File renameName(File file) {
        if (!this.checkFileExists(file)) {
            return null;
        }
        if (file.getParentFile() == null) {
            return null;
        }
        String string = UIUtility.showInputDialog(this.parent, Messages.getString("Action.rename"), Messages.getString("Message.name"), file.getName());
        if (string == null) {
            return null;
        }
        File file2 = new File(file.getParentFile(), string);
        if (!this.checkFileLength(file2)) {
            return null;
        }
        return file2;
    }

    public boolean moveFile(File file, File file2, int n, boolean bl) {
        if (!this.checkFileExists(file) || !this.checkFileLength(file2)) {
            return false;
        }
        if (file.isDirectory()) {
            return this.copyOrMoveDirectory(file, file2, false, n);
        }
        if (file.isDirectory() || file2.isDirectory()) {
            throw new IllegalArgumentException("both source and dest must be file");
        }
        int n2 = this.processOverwrite(file2, n, bl);
        switch (n2) {
            case 1: {
                return true;
            }
            case 2: {
                return false;
            }
        }
        if (!file.renameTo(file2)) {
            UIUtility.showErrorDialog((Component)this.parent, Messages.getString("Error.file.move") + ": " + file.getPath());
            return false;
        }
        return true;
    }

    public boolean makeDir(File file) {
        if (this.checkFileLength(file) && file.mkdirs()) {
            return true;
        }
        UIUtility.showErrorDialog((Component)this.parent, Messages.getString("Error.file.create_folder"));
        return false;
    }

    public void createFolderAskName(File file) {
        if (!this.checkFileExists(file)) {
            return;
        }
        if (file.isFile() && file.getParentFile() == null) {
            return;
        }
        String string = UIUtility.showInputDialog(this.parent, Messages.getString("Action.new_folder"), Messages.getString("Message.name"), "");
        if (string == null) {
            return;
        }
        File file2 = file.isDirectory() ? new File(file, string) : new File(file.getParentFile(), string);
        if (!file2.mkdir()) {
            UIUtility.showErrorDialog((Component)this.parent, Messages.getString("Error.file.create_folder"));
        }
    }

    public boolean copyFile(File file, File file2, int n, boolean bl) {
        if (!this.checkFileExists(file2) || !this.checkFileExists(file)) {
            return false;
        }
        if (file.getParentFile() == null) {
            return false;
        }
        if (file2.isFile() && file2.getParentFile() == null) {
            return false;
        }
        File file3 = file2.isDirectory() ? new File(file2, file.getName()) : new File(file2.getParentFile(), file.getName());
        if (!this.checkFileLength(file3)) {
            return false;
        }
        if (file.isDirectory()) {
            return this.copyOrMoveDirectory(file, file3, true, n);
        }
        File file4 = null;
        if (file3.equals(file)) {
            File file5 = this.getCopyFile(file3);
            if (file5 == null) {
                file4 = file;
            } else {
                file3 = file5;
                if (!this.checkFileLength(file3)) {
                    return false;
                }
            }
        } else {
            int n2 = this.processOverwrite(file3, n, bl);
            switch (n2) {
                case 1: {
                    return true;
                }
                case 2: {
                    return false;
                }
            }
        }
        if (file4 == null) {
            try {
                Files.copy(file.toPath(), file3.toPath(), StandardCopyOption.REPLACE_EXISTING);
            }
            catch (IOException iOException) {
                file4 = file;
            }
        }
        if (file4 != null) {
            UIUtility.showErrorDialog((Component)this.parent, Messages.getString("Error.file.copy") + ": " + file4.getPath());
            return false;
        }
        return true;
    }

    public int processOverwrite(File file, int n, boolean bl) {
        if (file.exists()) {
            if (n == 2) {
                int n2 = UIUtility.confirmYesNoCancel(file, this.parent, bl);
                switch (n2) {
                    case 0: {
                        n = 0;
                        break;
                    }
                    case 1: {
                        n = 1;
                        break;
                    }
                    case 2: {
                        return 2;
                    }
                }
            }
            if (n == 0) {
                if (!this.delete_file(file)) {
                    UIUtility.showErrorDialog((Component)this.parent, Messages.getString("Error.file.overwrite") + ": " + file.getPath());
                    return 2;
                }
            } else if (n == 1) {
                return 1;
            }
        }
        return 0;
    }

    private File getCopyFile(File file) {
        if (file.exists()) {
            File file2 = file.getParentFile();
            if (file2 == null) {
                throw new RuntimeException("can not copy root");
            }
            Object object = file.getName();
            int n = ((String)object).lastIndexOf(46);
            object = n < 0 ? (String)object + COPY_SUFFIX : ((String)object).substring(0, n) + COPY_SUFFIX + ((String)object).substring(n, ((String)object).length());
            while (new File(file2, (String)object).exists()) {
                if (((String)object).matches(COPY_PREFIX_REG0)) {
                    try {
                        object = ((String)object).replaceFirst(COPY_PREFIX_REG0, "$1_copy2$3");
                    }
                    catch (Exception exception) {
                        object = ((String)object).replaceFirst(COPY_PREFIX_REG0, "$1_copy2");
                    }
                    continue;
                }
                if (!((String)object).matches(COPY_PREFIX_REG)) continue;
                String string = ((String)object).replaceFirst(COPY_PREFIX_REG, "$2");
                int n2 = Integer.valueOf(string) + 1;
                if (n2 > 255) {
                    return null;
                }
                try {
                    object = ((String)object).replaceFirst(COPY_PREFIX_REG, "$1" + n2 + "$3");
                }
                catch (Exception exception) {
                    object = ((String)object).replaceFirst(COPY_PREFIX_REG, "$1" + n2);
                }
            }
            return this.getCopyFile(new File(file2, (String)object));
        }
        return file;
    }

    private boolean copyOrMoveDirectory(File file, File file2, boolean bl, int n) {
        if (!this.checkFileLength(file2)) {
            return false;
        }
        if (!this.checkIsValidAction(file, file2)) {
            return false;
        }
        int n2 = 1;
        if (bl && file.equals(file2)) {
            File file3 = this.getCopyFile(file2);
            if (file3 == null) {
                UIUtility.showErrorDialog((Component)this.parent, Messages.getString("Error.file.copy") + ": " + file2.getPath());
                return false;
            }
            return this.copyOrMoveDirectory(file, file3, bl, n);
        }
        if (file2.exists()) {
            block0 : switch (n) {
                case 2: {
                    int n3;
                    JOptionPane jOptionPane = new JOptionPane(file2.getName() + " " + Messages.getString("Message.folder_overwrite"), 1);
                    jOptionPane.setOptions(dirOverwriteOptions);
                    JDialog jDialog = jOptionPane.createDialog(this.parent, Messages.getString("Message.confirm_overwrite"));
                    jDialog.setVisible(true);
                    jDialog.dispose();
                    String string = (String)jOptionPane.getValue();
                    if (string == null) {
                        n3 = 3;
                    } else {
                        for (n3 = 0; n3 < dirOverwriteOptions.length && !dirOverwriteOptions[n3].equals(string); ++n3) {
                        }
                    }
                    switch (n3) {
                        case 1: {
                            n = 0;
                            n2 = 0;
                            break block0;
                        }
                        case 0: {
                            n2 = 0;
                            break block0;
                        }
                        case 2: {
                            n2 = 1;
                            break block0;
                        }
                        case 3: {
                            return false;
                        }
                    }
                    break;
                }
                case 0: {
                    n2 = 0;
                    break;
                }
                case 1: {
                    n2 = 1;
                }
            }
        } else if (!file2.mkdir()) {
            UIUtility.showErrorDialog((Component)this.parent, Messages.getString("Error.file.create_folder"));
            return false;
        }
        for (File file4 : file.listFiles()) {
            File file5 = new File(file2, file4.getName());
            if (!(file4.isDirectory() ? !this.copyOrMoveDirectory(file4, file5, bl, n) : (bl ? !this.copyFile(file4, file2, n2, false) : !this.moveFile(file4, file5, n2, false)))) continue;
            return false;
        }
        if (!bl && !file.delete()) {
            UIUtility.showErrorDialog((Component)this.parent, Messages.getString("Error.file.delete") + ": " + file.getPath());
            return false;
        }
        return true;
    }

    public boolean checkFileLength(File file) {
        if (file.getAbsolutePath().getBytes().length > this.MAX_PATH) {
            UIUtility.showErrorDialog((Component)this.parent, Messages.getString("Error.file.exceed_path_limit") + ": " + file.getPath());
            return false;
        }
        return true;
    }

    public boolean checkFileExists(File file) {
        return this.checkFileExists(file, true);
    }

    public boolean checkFileExists(File file, boolean bl) {
        if (!file.exists()) {
            if (bl) {
                UIUtility.showErrorDialog((Component)this.parent, Messages.getString("Error.file.file_not_found") + ": " + file.getPath());
            }
            return false;
        }
        return true;
    }

    public boolean checkIsValidAction(File file, File file2) {
        if (file.isFile()) {
            return true;
        }
        if (FileUtility.isChild(file, file2)) {
            UIUtility.showErrorDialog((Component)this.parent, Messages.getString("Error.file.folder_to_subfolder"));
            return false;
        }
        return true;
    }
}

