/*
 * Decompiled with CFR 0.152.
 */
package com.ef_prime.rflow.ui.common.component;

import com.google.common.base.Predicate;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;

public class FilteredTreeModel<T extends TreeNode>
extends DefaultTreeModel {
    private Predicate<T> filter;

    public FilteredTreeModel(TreeNode treeNode) {
        super(treeNode);
    }

    public FilteredTreeModel(TreeNode treeNode, boolean bl) {
        super(treeNode, bl);
    }

    private boolean isFilter() {
        return this.filter != null;
    }

    public void setFilter(Predicate<T> predicate) {
        this.filter = predicate;
    }

    @Override
    public Object getChild(Object object, int n) {
        if (!this.isFilter()) {
            return super.getChild(object, n);
        }
        int n2 = -1;
        TreeNode treeNode = (TreeNode)object;
        for (int i = 0; i < treeNode.getChildCount(); ++i) {
            TreeNode treeNode2 = treeNode.getChildAt(i);
            if (!this.filter.apply((Object)treeNode2) || ++n2 != n) continue;
            return treeNode2;
        }
        return null;
    }

    @Override
    public int getChildCount(Object object) {
        if (!this.isFilter()) {
            return super.getChildCount(object);
        }
        int n = 0;
        TreeNode treeNode = (TreeNode)object;
        for (int i = 0; i < treeNode.getChildCount(); ++i) {
            TreeNode treeNode2 = treeNode.getChildAt(i);
            if (!this.filter.apply((Object)treeNode2)) continue;
            ++n;
        }
        return n;
    }

    @Override
    public int getIndexOfChild(Object object, Object object2) {
        if (!this.isFilter()) {
            return super.getIndexOfChild(object, object2);
        }
        if (object == null || object2 == null) {
            return -1;
        }
        int n = -1;
        TreeNode treeNode = (TreeNode)object;
        for (int i = 0; i < treeNode.getChildCount(); ++i) {
            TreeNode treeNode2 = treeNode.getChildAt(i);
            if (!this.filter.apply((Object)treeNode2)) continue;
            ++n;
            if (!object2.equals(treeNode2)) continue;
            return n;
        }
        return -1;
    }
}

