/*
 * Decompiled with CFR 0.152.
 */
package com.ef_prime.rflow.ui.common.component;

import com.ef_prime.rflow.core.common.util.Utility;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.io.File;
import java.util.List;

public class Flavors {
    public static boolean isFileFlavorSupported(Transferable transferable) {
        return transferable.isDataFlavorSupported(DataFlavor.javaFileListFlavor);
    }

    public static List<File> getFiles(Transferable transferable) {
        if (!Flavors.isFileFlavorSupported(transferable)) {
            return null;
        }
        try {
            return (List)Utility.cast(transferable.getTransferData(DataFlavor.javaFileListFlavor));
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static File getFile(Transferable transferable) {
        if (!Flavors.isFileFlavorSupported(transferable)) {
            return null;
        }
        try {
            List list = (List)Utility.cast(transferable.getTransferData(DataFlavor.javaFileListFlavor));
            if (list != null && list.size() > 0) {
                return (File)list.get(0);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public static File getOnlyFile(Transferable transferable) {
        if (!Flavors.isFileFlavorSupported(transferable)) {
            return null;
        }
        try {
            List list = (List)Utility.cast(transferable.getTransferData(DataFlavor.javaFileListFlavor));
            if (list != null && list.size() == 1) {
                return (File)list.get(0);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public static boolean isStringFlavorSupported(Transferable transferable) {
        return transferable.isDataFlavorSupported(DataFlavor.stringFlavor);
    }

    public static String getString(Transferable transferable) {
        if (!Flavors.isStringFlavorSupported(transferable)) {
            return null;
        }
        try {
            return (String)transferable.getTransferData(DataFlavor.stringFlavor);
        }
        catch (Exception exception) {
            return null;
        }
    }
}

