/*
 * Decompiled with CFR 0.152.
 */
package com.ef_prime.rflow.ui.common.component;

import com.ef_prime.rflow.ui.util.UIUtility;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.plaf.TextUI;
import javax.swing.text.BadLocationException;
import javax.swing.text.Position;
import javax.swing.undo.UndoManager;
import org.apache.commons.lang3.StringUtils;
import org.pushingpixels.lafwidget.utils.RenderingUtils;

public class JTextFieldEx
extends JTextField {
    private static final Logger LOGGER = Logger.getLogger(JTextFieldEx.class.getName());
    private String emptyMessage;
    private Color emptyMessageColor = Color.GRAY;
    private String description;
    private Color descriptionColor = Color.GRAY;
    private boolean clearButtonEnabled;
    private int buttonSize = 10;
    private UndoManager undoManager = UIUtility.setTextComponentUndoable(this);

    public JTextFieldEx() {
        this("");
    }

    public JTextFieldEx(String string) {
        super(string);
        UIUtility.setTextComponentPopupMenu(this);
        MouseHandler mouseHandler = new MouseHandler();
        this.addMouseListener(mouseHandler);
        this.addMouseMotionListener(mouseHandler);
    }

    public void setEmptyMessage(String string) {
        this.emptyMessage = string;
        this.revalidate();
        this.repaint();
    }

    public UndoManager getUndoManager() {
        return this.undoManager;
    }

    public String getEmptyMessage() {
        return this.emptyMessage;
    }

    public void setEmptyMessageColor(Color color) {
        this.emptyMessageColor = color;
        this.repaint();
    }

    public Color getEmptyMessageColor() {
        return this.emptyMessageColor;
    }

    public void setDescription(String string) {
        this.description = string;
        this.repaint();
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescriptionColor(Color color) {
        this.descriptionColor = color;
    }

    public Color getDescriptionColor() {
        return this.descriptionColor;
    }

    public void setClearButtonEnabled(boolean bl) {
        this.clearButtonEnabled = bl;
        if (bl) {
            this.setMargin(new Insets(0, 0, 0, 5 + this.buttonSize + 8));
        } else {
            this.setMargin(new Insets(0, 0, 0, 0));
        }
    }

    public boolean isClearButtonEnabled() {
        return this.clearButtonEnabled;
    }

    @Override
    public Dimension getPreferredSize() {
        FontMetrics fontMetrics;
        Dimension dimension = super.getPreferredSize();
        if (this.isPreferredSizeSet()) {
            return dimension;
        }
        dimension.width += 10;
        if (this.getDocument().getLength() <= 0 && !StringUtils.isEmpty((CharSequence)this.emptyMessage)) {
            fontMetrics = this.getFontMetrics(this.getFont());
            dimension.width += SwingUtilities.computeStringWidth(fontMetrics, this.emptyMessage);
        }
        if (this.description != null) {
            fontMetrics = this.getFontMetrics(this.getFont());
            dimension.width += SwingUtilities.computeStringWidth(fontMetrics, this.description);
        }
        return dimension;
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        this.paintEmptyMessage(graphics);
        this.paintDescription(graphics);
        this.paintClearButton(graphics);
    }

    private void paintEmptyMessage(Graphics graphics) {
        Rectangle rectangle;
        if (this.getDocument().getLength() > 0 || StringUtils.isEmpty((CharSequence)this.emptyMessage)) {
            return;
        }
        Graphics2D graphics2D = (Graphics2D)graphics.create();
        RenderingUtils.installDesktopHints((Graphics2D)graphics2D, (Component)this);
        TextUI textUI = this.getUI();
        try {
            rectangle = textUI.modelToView(this, 0, Position.Bias.Backward);
        }
        catch (BadLocationException badLocationException) {
            LOGGER.log(Level.SEVERE, badLocationException.getMessage(), badLocationException);
            return;
        }
        graphics2D.setColor(this.emptyMessageColor);
        UIUtility.drawStringCenterY(graphics2D, this, this.emptyMessage, rectangle.x);
        graphics2D.dispose();
    }

    private void paintDescription(Graphics graphics) {
        Rectangle rectangle;
        if (this.description == null) {
            return;
        }
        int n = this.getDocument().getLength();
        TextUI textUI = this.getUI();
        try {
            rectangle = textUI.modelToView(this, n, Position.Bias.Backward);
        }
        catch (BadLocationException badLocationException) {
            LOGGER.log(Level.SEVERE, "Unexpected BadLocationException.", badLocationException);
            return;
        }
        int n2 = n == 0 ? 0 : 5;
        Graphics2D graphics2D = (Graphics2D)graphics.create();
        RenderingUtils.installDesktopHints((Graphics2D)graphics2D, (Component)this);
        graphics2D.setColor(this.descriptionColor);
        UIUtility.drawStringCenterY(graphics, this, this.description, rectangle.x + rectangle.width + n2);
        graphics2D.dispose();
    }

    private void paintClearButton(Graphics graphics) {
        if (!this.isClearButtonEnabled() || this.getDocument().getLength() == 0) {
            return;
        }
        Point point = this.getMousePosition();
        int n = 2;
        Rectangle rectangle = this.clearButtonArea();
        Graphics2D graphics2D = (Graphics2D)graphics.create();
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.setColor(this.getBackground());
        graphics2D.fillRect(rectangle.x - 5, 0, this.getWidth() - rectangle.x, this.getHeight());
        graphics2D.setStroke(new BasicStroke(2.0f));
        graphics2D.setColor(point == null || !rectangle.contains(point) ? Color.LIGHT_GRAY : Color.GRAY);
        graphics2D.drawLine(rectangle.x + n, rectangle.y + n, rectangle.x + this.buttonSize - n, rectangle.y + this.buttonSize - n);
        graphics2D.drawLine(rectangle.x + n, rectangle.y + this.buttonSize - n, rectangle.x + this.buttonSize - n, rectangle.y + n);
        graphics2D.dispose();
    }

    private Rectangle clearButtonArea() {
        int n = 8;
        return new Rectangle(this.getSize().width - n - this.buttonSize, this.getSize().height / 2 - this.buttonSize / 2, this.buttonSize, this.buttonSize);
    }

    private class MouseHandler
    extends MouseAdapter {
        private MouseHandler() {
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            if (!JTextFieldEx.this.isClearButtonEnabled()) {
                return;
            }
            if (JTextFieldEx.this.clearButtonArea().contains(mouseEvent.getPoint())) {
                JTextFieldEx.this.setText("");
            }
        }

        @Override
        public void mouseMoved(MouseEvent mouseEvent) {
            if (!JTextFieldEx.this.isClearButtonEnabled()) {
                return;
            }
            Cursor cursor = JTextFieldEx.this.clearButtonArea().contains(mouseEvent.getPoint()) ? Cursor.getDefaultCursor() : Cursor.getPredefinedCursor(2);
            if (JTextFieldEx.this.getCursor() != cursor) {
                JTextFieldEx.this.setCursor(cursor);
                JTextFieldEx.this.repaint();
            }
        }
    }
}

