/*
 * Decompiled with CFR 0.152.
 */
package com.ef_prime.rflow.ui.common.component;

import com.ef_prime.rflow.core.common.util.ThreadUtility;

public class LightDelayedExecutor {
    private Runnable action;
    private long waitTime;
    private long checkInterval;
    private DelayedRun delayedRun;

    public LightDelayedExecutor(Runnable runnable, long l, long l2) {
        this.action = runnable;
        this.waitTime = l;
        this.checkInterval = l2;
    }

    public void requestAction() {
        this.requestAction(false);
    }

    public void requestAction(boolean bl) {
        if (this.delayedRun == null || !this.delayedRun.alive()) {
            if (bl) {
                this.action.run();
            } else {
                this.delayedRun = new DelayedRun();
                ThreadUtility.execute(this.delayedRun);
            }
        } else if (bl) {
            this.delayedRun.kill();
            this.action.run();
        } else {
            this.delayedRun.reset();
        }
    }

    public void fireWaitingActionSync() {
        if (this.delayedRun != null && this.delayedRun.alive()) {
            this.delayedRun.kill();
            this.action.run();
        }
    }

    public void cancel() {
        if (this.delayedRun != null && this.delayedRun.alive()) {
            this.delayedRun.kill();
        }
    }

    private class DelayedRun
    implements Runnable {
        private long start;
        private boolean alive = true;

        public void reset() {
            this.start = System.currentTimeMillis();
        }

        public void kill() {
            this.alive = false;
        }

        public boolean alive() {
            return this.alive;
        }

        @Override
        public void run() {
            this.start = System.currentTimeMillis();
            while (this.alive) {
                long l;
                try {
                    Thread.sleep(LightDelayedExecutor.this.checkInterval);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if ((l = System.currentTimeMillis() - this.start) <= LightDelayedExecutor.this.waitTime || !this.alive) continue;
                this.alive = false;
                LightDelayedExecutor.this.action.run();
            }
        }
    }
}

