/*
 * Decompiled with CFR 0.152.
 */
package com.ef_prime.rflow.ui.common.component;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.awt.event.MouseEvent;
import javax.swing.JList;
import javax.swing.Timer;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.MouseInputListener;

public class ListRollOverSelectionHandler
implements MouseInputListener,
ActionListener,
ListSelectionListener,
HierarchyListener {
    private Timer timer = new Timer(200, this);
    private JList<?> list;
    private int targetIndex = -1;
    private boolean ignoreMove = true;

    public ListRollOverSelectionHandler() {
        this.timer.setRepeats(false);
    }

    public void install(JList<?> jList) {
        this.list = jList;
        jList.addMouseListener(this);
        jList.addMouseMotionListener(this);
        jList.addListSelectionListener(this);
        jList.addHierarchyListener(this);
    }

    public void uninstall() {
        if (this.list != null) {
            this.list.removeMouseListener(this);
            this.list.removeMouseMotionListener(this);
            this.list.removeListSelectionListener(this);
            this.list.removeHierarchyListener(this);
            this.list = null;
        }
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
        if (this.ignoreMove) {
            this.ignoreMove = false;
            return;
        }
        int n = this.list.locationToIndex(mouseEvent.getPoint());
        if (n < 0) {
            return;
        }
        if (n != this.targetIndex) {
            this.targetIndex = n;
            this.timer.stop();
            this.timer.start();
        }
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
        this.timer.stop();
        this.targetIndex = -1;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (this.targetIndex >= 0) {
            this.list.setSelectedIndex(this.targetIndex);
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        if (listSelectionEvent.getValueIsAdjusting()) {
            return;
        }
        this.targetIndex = this.list.getSelectedIndex();
    }

    @Override
    public void hierarchyChanged(HierarchyEvent hierarchyEvent) {
        if ((hierarchyEvent.getChangeFlags() & 4L) == 0L) {
            return;
        }
        Component component = hierarchyEvent.getComponent();
        if (component == null) {
            return;
        }
        if (!component.isShowing()) {
            this.ignoreMove = true;
        }
    }
}

