/*
 * Decompiled with CFR 0.152.
 */
package com.ef_prime.rflow.ui.common.component;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import org.apache.commons.io.FileUtils;

public class LockFile {
    public static final String LOCK_FILE = ".lock";
    private File file;
    private FileOutputStream lockFileStream;
    private FileLock fileLock;

    public LockFile(File file) {
        this.file = file;
    }

    public File getFile() {
        return this.file;
    }

    public FileLock tryLock() {
        if (this.fileLock != null) {
            return this.fileLock;
        }
        try {
            FileUtils.forceMkdir((File)this.file.getParentFile());
            this.lockFileStream = new FileOutputStream(this.file, true);
            FileChannel fileChannel = this.lockFileStream.getChannel();
            this.fileLock = fileChannel.tryLock();
            return this.fileLock;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public FileLock lock() throws IOException {
        if (this.fileLock != null) {
            return this.fileLock;
        }
        FileUtils.forceMkdir((File)this.file.getParentFile());
        this.lockFileStream = new FileOutputStream(this.file, true);
        FileChannel fileChannel = this.lockFileStream.getChannel();
        this.fileLock = fileChannel.lock();
        return this.fileLock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean canObtainLock() {
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(this.file, true);
            FileChannel fileChannel = fileOutputStream.getChannel();
            try {
                FileLock fileLock = fileChannel.tryLock();
                if (fileLock == null) {
                    boolean bl = false;
                    return bl;
                }
                fileLock.release();
                return true;
            }
            finally {
                fileChannel.close();
                fileOutputStream.close();
            }
        }
        catch (Exception exception) {
            return false;
        }
    }

    public void release() {
        if (this.fileLock != null) {
            try {
                this.fileLock.release();
                this.fileLock = null;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (this.lockFileStream != null) {
            try {
                this.lockFileStream.close();
                this.lockFileStream = null;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        FileUtils.deleteQuietly((File)this.file);
    }

    public static LockFile createLockFile(File file) {
        return new LockFile(new File(file, LOCK_FILE));
    }

    public static LockFile getDirWithLock(File file, String string) {
        LockFile lockFile;
        LockFile lockFile2;
        block1: {
            int n = 1;
            File file2 = new File(file, string + n);
            lockFile2 = null;
            do {
                FileLock fileLock;
                if (!file2.exists() && file2.mkdirs() && (fileLock = (lockFile = new LockFile(new File(file2, LOCK_FILE))).tryLock()) != null) break block1;
                file2 = new File(file, string + ++n);
            } while (n <= 2000);
            throw new RuntimeException("Failed to create folder for new project");
        }
        lockFile2 = lockFile;
        return lockFile2;
    }
}

