/*
 * Decompiled with CFR 0.152.
 */
package com.ef_prime.rflow.ui.common.component;

import java.io.File;
import java.util.Collections;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.swing.filechooser.FileFilter;

public class MyFileFilter
extends FileFilter {
    SortedSet<String> extension = new TreeSet<String>();
    String delegateExtension = null;
    String description = "file";

    @Override
    public boolean accept(File file) {
        if (file == null) {
            return false;
        }
        if (file.isDirectory()) {
            return true;
        }
        String string = file.getName();
        int n = string.lastIndexOf(46);
        if (n == -1) {
            return false;
        }
        String string2 = string.substring(n + 1).toLowerCase();
        return this.extension.contains(string2);
    }

    @Override
    public String getDescription() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.description);
        stringBuilder.append(" (");
        for (String string : this.extension) {
            stringBuilder.append("*.");
            stringBuilder.append(string);
            stringBuilder.append(", ");
        }
        stringBuilder.delete(stringBuilder.length() - 2, stringBuilder.length());
        stringBuilder.append(")");
        return stringBuilder.toString();
    }

    public void setDescription(String string) {
        if (string == null) {
            return;
        }
        this.description = string;
    }

    public void addExtention(String string) {
        if (string == null) {
            return;
        }
        String string2 = string.toLowerCase();
        this.extension.add(string2);
    }

    public SortedSet<String> getExtension() {
        return Collections.unmodifiableSortedSet(this.extension);
    }

    public String getDelegateExtension() {
        if (this.delegateExtension == null) {
            return this.extension.first();
        }
        return this.delegateExtension;
    }

    public void setDelegateExtension(String string) {
        this.delegateExtension = string;
    }
}

