/*
 * Decompiled with CFR 0.152.
 */
package com.ef_prime.rflow.ui.common.component;

import javax.swing.SizeRequirements;
import javax.swing.text.BoxView;
import javax.swing.text.ComponentView;
import javax.swing.text.Element;
import javax.swing.text.IconView;
import javax.swing.text.LabelView;
import javax.swing.text.ParagraphView;
import javax.swing.text.StyledEditorKit;
import javax.swing.text.View;
import javax.swing.text.ViewFactory;

public class NoWrapEditorKit
extends StyledEditorKit {
    private static final ViewFactory factory = new NoWrapViewFactory();

    @Override
    public ViewFactory getViewFactory() {
        return factory;
    }

    private static class NoWrapViewFactory
    implements ViewFactory {
        private NoWrapViewFactory() {
        }

        @Override
        public View create(Element element) {
            String string = element.getName();
            if (string != null) {
                if (string.equals("content")) {
                    return new LabelView(element);
                }
                if (string.equals("paragraph")) {
                    return new NoWrapParagraphView(element);
                }
                if (string.equals("section")) {
                    return new BoxView(element, 1);
                }
                if (string.equals("component")) {
                    return new ComponentView(element);
                }
                if (string.equals("icon")) {
                    return new IconView(element);
                }
            }
            return new LabelView(element);
        }
    }

    private static class NoWrapParagraphView
    extends ParagraphView {
        public NoWrapParagraphView(Element element) {
            super(element);
        }

        @Override
        protected SizeRequirements calculateMinorAxisRequirements(int n, SizeRequirements sizeRequirements) {
            SizeRequirements sizeRequirements2 = super.calculateMinorAxisRequirements(n, sizeRequirements);
            sizeRequirements2.minimum = sizeRequirements2.preferred;
            return sizeRequirements2;
        }

        @Override
        public int getFlowSpan(int n) {
            return Integer.MAX_VALUE;
        }
    }
}

