/*
 * Decompiled with CFR 0.152.
 */
package com.ef_prime.rflow.ui.common.component;

import com.ef_prime.rflow.resource.Messages;
import com.ef_prime.rflow.ui.base.Icons;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import net.miginfocom.layout.AC;
import net.miginfocom.layout.CC;
import net.miginfocom.layout.LC;
import net.miginfocom.swing.MigLayout;

public class OptionPane
extends JPanel
implements ActionListener {
    public static final int OPTIONS_CLOSE = 0;
    public static final int OPTIONS_OK_CANCEL = 1;
    public static final int OPTION_NONE = -1;
    public static final int OPTION_OK = 0;
    public static final int OPTION_CANCEL = 1;
    private static final String ACTION_OK = "ok";
    private static final String ACTION_CANCEL = "cancel";
    private static final String ACTION_CLOSE = "close";
    private int result = -1;

    public OptionPane(Component component, int n) {
        this.setLayout(new BorderLayout());
        this.setBorder(new EmptyBorder(10, 10, 10, 10));
        this.add(component, "Center");
        JPanel jPanel = new JPanel((LayoutManager)new MigLayout(new LC().insets("10", "0", "0", "0").fill(), new AC().grow()));
        CC cC = new CC().width("120").alignX("right");
        CC cC2 = new CC().width("120").cell(new int[]{0, 0});
        switch (n) {
            case 0: {
                jPanel.add((Component)this.createCloseButton(), cC);
                break;
            }
            case 1: {
                jPanel.add((Component)this.createOkButton(), cC);
                jPanel.add((Component)this.createCancelButton(), cC2);
                break;
            }
        }
        this.add((Component)jPanel, "South");
    }

    public static void showDialog(Component component, Component component2, String string, Dimension dimension, boolean bl) {
        OptionPane optionPane = new OptionPane(component2, 0);
        JDialog jDialog = OptionPane.createDialog(component, optionPane, string, dimension, bl);
        jDialog.setVisible(true);
    }

    public static int showOkCancelDialog(Component component, Component component2, String string, Dimension dimension) {
        OptionPane optionPane = new OptionPane(component2, 1);
        JDialog jDialog = OptionPane.createDialog(component, optionPane, string, dimension, true);
        jDialog.setVisible(true);
        return optionPane.getResult();
    }

    private static JDialog createDialog(Component component, OptionPane optionPane, String string, Dimension dimension, boolean bl) {
        Window window = component instanceof Window ? (Window)component : SwingUtilities.windowForComponent(component);
        JDialog jDialog = new JDialog(window, string);
        jDialog.setDefaultCloseOperation(2);
        jDialog.setModal(bl);
        jDialog.add(optionPane);
        if (dimension != null) {
            jDialog.setSize(dimension);
        } else {
            jDialog.pack();
        }
        jDialog.setLocationRelativeTo(window);
        return jDialog;
    }

    public int getResult() {
        return this.result;
    }

    private JButton createOkButton() {
        return this.createButton(Messages.getString("Button.ok"), "16/tick.png", ACTION_OK);
    }

    private JButton createCancelButton() {
        return this.createButton(Messages.getString("Button.cancel"), "16/cross.png", ACTION_CANCEL);
    }

    private JButton createCloseButton() {
        return this.createButton(Messages.getString("Button.close"), null, ACTION_CLOSE);
    }

    protected JButton createButton(String string, String string2, String string3) {
        JButton jButton = new JButton(string);
        if (string2 != null) {
            jButton.setIcon(Icons.getIcon(string2));
        }
        jButton.setActionCommand(string3);
        jButton.addActionListener(this);
        return jButton;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        switch (actionEvent.getActionCommand()) {
            case "ok": {
                this.result = 0;
                break;
            }
            case "cancel": {
                this.result = 1;
                break;
            }
            case "close": {
                break;
            }
        }
        Object object = SwingUtilities.windowForComponent(this);
        if (object != null) {
            ((Window)object).dispose();
        }
    }
}

